/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VersionSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(VersionSummary.getter(VersionSummary::applicationId)).setter(VersionSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(VersionSummary.getter(VersionSummary::creationTime)).setter(VersionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(VersionSummary.getter(VersionSummary::semanticVersion)).setter(VersionSummary.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCodeUrl").getter(VersionSummary.getter(VersionSummary::sourceCodeUrl)).setter(VersionSummary.setter(Builder::sourceCodeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CREATION_TIME_FIELD, SEMANTIC_VERSION_FIELD, SOURCE_CODE_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("semanticVersion", SEMANTIC_VERSION_FIELD);
            this.put("sourceCodeUrl", SOURCE_CODE_URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String creationTime;
    private final String semanticVersion;
    private final String sourceCodeUrl;

    private VersionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeUrl = builder.sourceCodeUrl;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final String sourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionSummary)) {
            return false;
        }
        VersionSummary other = (VersionSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.sourceCodeUrl(), other.sourceCodeUrl());
    }

    public final String toString() {
        return ToString.builder((String)"VersionSummary").add("ApplicationId", (Object)this.applicationId()).add("CreationTime", (Object)this.creationTime()).add("SemanticVersion", (Object)this.semanticVersion()).add("SourceCodeUrl", (Object)this.sourceCodeUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "SourceCodeUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VersionSummary, T> g) {
        return obj -> g.apply((VersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationTime;
        private String semanticVersion;
        private String sourceCodeUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionSummary model) {
            this.applicationId(model.applicationId);
            this.creationTime(model.creationTime);
            this.semanticVersion(model.semanticVersion);
            this.sourceCodeUrl(model.sourceCodeUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public VersionSummary build() {
            return new VersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VersionSummary> {
        public Builder applicationId(String var1);

        public Builder creationTime(String var1);

        public Builder semanticVersion(String var1);

        public Builder sourceCodeUrl(String var1);
    }
}

