/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> AUTHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::author)).setter(setter(Builder::author))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> HOME_PAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::homePageUrl)).setter(setter(Builder::homePageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePageUrl").build()).build();

    private static final SdkField<Boolean> IS_VERIFIED_AUTHOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetApplicationResponse::isVerifiedAuthor)).setter(setter(Builder::isVerifiedAuthor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isVerifiedAuthor").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetApplicationResponse::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LICENSE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::licenseUrl)).setter(setter(Builder::licenseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseUrl").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> README_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::readmeUrl)).setter(setter(Builder::readmeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUrl").build()).build();

    private static final SdkField<String> SPDX_LICENSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::spdxLicenseId)).setter(setter(Builder::spdxLicenseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spdxLicenseId").build()).build();

    private static final SdkField<String> VERIFIED_AUTHOR_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApplicationResponse::verifiedAuthorUrl)).setter(setter(Builder::verifiedAuthorUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verifiedAuthorUrl").build()).build();

    private static final SdkField<Version> VERSION_FIELD = SdkField.<Version> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetApplicationResponse::version)).setter(setter(Builder::version)).constructor(Version::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            AUTHOR_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, HOME_PAGE_URL_FIELD, IS_VERIFIED_AUTHOR_FIELD, LABELS_FIELD,
            LICENSE_URL_FIELD, NAME_FIELD, README_URL_FIELD, SPDX_LICENSE_ID_FIELD, VERIFIED_AUTHOR_URL_FIELD, VERSION_FIELD));

    private final String applicationId;

    private final String author;

    private final String creationTime;

    private final String description;

    private final String homePageUrl;

    private final Boolean isVerifiedAuthor;

    private final List<String> labels;

    private final String licenseUrl;

    private final String name;

    private final String readmeUrl;

    private final String spdxLicenseId;

    private final String verifiedAuthorUrl;

    private final Version version;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.isVerifiedAuthor = builder.isVerifiedAuthor;
        this.labels = builder.labels;
        this.licenseUrl = builder.licenseUrl;
        this.name = builder.name;
        this.readmeUrl = builder.readmeUrl;
        this.spdxLicenseId = builder.spdxLicenseId;
        this.verifiedAuthorUrl = builder.verifiedAuthorUrl;
        this.version = builder.version;
    }

    /**
     * <p>
     * The application Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The name of the author publishing the app.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=127.
     * </p>
     * <p>
     * Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     * </p>
     * 
     * @return The name of the author publishing the app.</p>
     *         <p>
     *         Minimum length=1. Maximum length=127.
     *         </p>
     *         <p>
     *         Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     */
    public String author() {
        return author;
    }

    /**
     * <p>
     * The date and time this resource was created.
     * </p>
     * 
     * @return The date and time this resource was created.
     */
    public String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=256
     * </p>
     * 
     * @return The description of the application.</p>
     *         <p>
     *         Minimum length=1. Maximum length=256
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A URL with more information about the application, for example the location of your GitHub repository for the
     * application.
     * </p>
     * 
     * @return A URL with more information about the application, for example the location of your GitHub repository for
     *         the application.
     */
    public String homePageUrl() {
        return homePageUrl;
    }

    /**
     * <p>
     * Whether the author of this application has been verified. This means means that AWS has made a good faith review,
     * as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that
     * the requester's identity is as claimed.
     * </p>
     * 
     * @return Whether the author of this application has been verified. This means means that AWS has made a good faith
     *         review, as a reasonable and prudent service provider, of the information provided by the requester and
     *         has confirmed that the requester's identity is as claimed.
     */
    public Boolean isVerifiedAuthor() {
        return isVerifiedAuthor;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Labels to improve discovery of apps in search results.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=127. Maximum number of labels: 10
     * </p>
     * <p>
     * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Labels to improve discovery of apps in search results.</p>
     *         <p>
     *         Minimum length=1. Maximum length=127. Maximum number of labels: 10
     *         </p>
     *         <p>
     *         Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     */
    public List<String> labels() {
        return labels;
    }

    /**
     * <p>
     * A link to a license file of the app that matches the spdxLicenseID value of your application.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * 
     * @return A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
     *         <p>
     *         Maximum size 5 MB
     */
    public String licenseUrl() {
        return licenseUrl;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=140
     * </p>
     * <p>
     * Pattern: "[a-zA-Z0-9\\-]+";
     * </p>
     * 
     * @return The name of the application.</p>
     *         <p>
     *         Minimum length=1. Maximum length=140
     *         </p>
     *         <p>
     *         Pattern: "[a-zA-Z0-9\\-]+";
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A link to the readme file in Markdown language that contains a more detailed description of the application and
     * how it works.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * 
     * @return A link to the readme file in Markdown language that contains a more detailed description of the
     *         application and how it works.</p>
     *         <p>
     *         Maximum size 5 MB
     */
    public String readmeUrl() {
        return readmeUrl;
    }

    /**
     * <p>
     * A valid identifier from https://spdx.org/licenses/.
     * </p>
     * 
     * @return A valid identifier from https://spdx.org/licenses/.
     */
    public String spdxLicenseId() {
        return spdxLicenseId;
    }

    /**
     * <p>
     * The URL to the public profile of a verified author. This URL is submitted by the author.
     * </p>
     * 
     * @return The URL to the public profile of a verified author. This URL is submitted by the author.
     */
    public String verifiedAuthorUrl() {
        return verifiedAuthorUrl;
    }

    /**
     * <p>
     * Version information about the application.
     * </p>
     * 
     * @return Version information about the application.
     */
    public Version version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(isVerifiedAuthor());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        hashCode = 31 * hashCode + Objects.hashCode(licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(readmeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(spdxLicenseId());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAuthorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(author(), other.author())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(homePageUrl(), other.homePageUrl())
                && Objects.equals(isVerifiedAuthor(), other.isVerifiedAuthor()) && Objects.equals(labels(), other.labels())
                && Objects.equals(licenseUrl(), other.licenseUrl()) && Objects.equals(name(), other.name())
                && Objects.equals(readmeUrl(), other.readmeUrl()) && Objects.equals(spdxLicenseId(), other.spdxLicenseId())
                && Objects.equals(verifiedAuthorUrl(), other.verifiedAuthorUrl()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetApplicationResponse").add("ApplicationId", applicationId()).add("Author", author())
                .add("CreationTime", creationTime()).add("Description", description()).add("HomePageUrl", homePageUrl())
                .add("IsVerifiedAuthor", isVerifiedAuthor()).add("Labels", labels()).add("LicenseUrl", licenseUrl())
                .add("Name", name()).add("ReadmeUrl", readmeUrl()).add("SpdxLicenseId", spdxLicenseId())
                .add("VerifiedAuthorUrl", verifiedAuthorUrl()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Author":
            return Optional.ofNullable(clazz.cast(author()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HomePageUrl":
            return Optional.ofNullable(clazz.cast(homePageUrl()));
        case "IsVerifiedAuthor":
            return Optional.ofNullable(clazz.cast(isVerifiedAuthor()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "LicenseUrl":
            return Optional.ofNullable(clazz.cast(licenseUrl()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ReadmeUrl":
            return Optional.ofNullable(clazz.cast(readmeUrl()));
        case "SpdxLicenseId":
            return Optional.ofNullable(clazz.cast(spdxLicenseId()));
        case "VerifiedAuthorUrl":
            return Optional.ofNullable(clazz.cast(verifiedAuthorUrl()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * The application Amazon Resource Name (ARN).
         * </p>
         * 
         * @param applicationId
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The name of the author publishing the app.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127.
         * </p>
         * <p>
         * Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * </p>
         * 
         * @param author
         *        The name of the author publishing the app.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127.
         *        </p>
         *        <p>
         *        Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * <p>
         * The date and time this resource was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time this resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The description of the application.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=256
         * </p>
         * 
         * @param description
         *        The description of the application.</p>
         *        <p>
         *        Minimum length=1. Maximum length=256
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A URL with more information about the application, for example the location of your GitHub repository for the
         * application.
         * </p>
         * 
         * @param homePageUrl
         *        A URL with more information about the application, for example the location of your GitHub repository
         *        for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePageUrl(String homePageUrl);

        /**
         * <p>
         * Whether the author of this application has been verified. This means means that AWS has made a good faith
         * review, as a reasonable and prudent service provider, of the information provided by the requester and has
         * confirmed that the requester's identity is as claimed.
         * </p>
         * 
         * @param isVerifiedAuthor
         *        Whether the author of this application has been verified. This means means that AWS has made a good
         *        faith review, as a reasonable and prudent service provider, of the information provided by the
         *        requester and has confirmed that the requester's identity is as claimed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isVerifiedAuthor(Boolean isVerifiedAuthor);

        /**
         * <p>
         * Labels to improve discovery of apps in search results.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         * </p>
         * <p>
         * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * </p>
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *        </p>
         *        <p>
         *        Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * Labels to improve discovery of apps in search results.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         * </p>
         * <p>
         * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * </p>
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *        </p>
         *        <p>
         *        Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * A link to a license file of the app that matches the spdxLicenseID value of your application.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * 
         * @param licenseUrl
         *        A link to a license file of the app that matches the spdxLicenseID value of your application.</p>
         *        <p>
         *        Maximum size 5 MB
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseUrl(String licenseUrl);

        /**
         * <p>
         * The name of the application.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=140
         * </p>
         * <p>
         * Pattern: "[a-zA-Z0-9\\-]+";
         * </p>
         * 
         * @param name
         *        The name of the application.</p>
         *        <p>
         *        Minimum length=1. Maximum length=140
         *        </p>
         *        <p>
         *        Pattern: "[a-zA-Z0-9\\-]+";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A link to the readme file in Markdown language that contains a more detailed description of the application
         * and how it works.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * 
         * @param readmeUrl
         *        A link to the readme file in Markdown language that contains a more detailed description of the
         *        application and how it works.</p>
         *        <p>
         *        Maximum size 5 MB
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeUrl(String readmeUrl);

        /**
         * <p>
         * A valid identifier from https://spdx.org/licenses/.
         * </p>
         * 
         * @param spdxLicenseId
         *        A valid identifier from https://spdx.org/licenses/.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spdxLicenseId(String spdxLicenseId);

        /**
         * <p>
         * The URL to the public profile of a verified author. This URL is submitted by the author.
         * </p>
         * 
         * @param verifiedAuthorUrl
         *        The URL to the public profile of a verified author. This URL is submitted by the author.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAuthorUrl(String verifiedAuthorUrl);

        /**
         * <p>
         * Version information about the application.
         * </p>
         * 
         * @param version
         *        Version information about the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Version version);

        /**
         * <p>
         * Version information about the application.
         * </p>
         * This is a convenience that creates an instance of the {@link Version.Builder} avoiding the need to create one
         * manually via {@link Version#builder()}.
         *
         * When the {@link Consumer} completes, {@link Version.Builder#build()} is called immediately and its result is
         * passed to {@link #version(Version)}.
         * 
         * @param version
         *        a consumer that will call methods on {@link Version.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #version(Version)
         */
        default Builder version(Consumer<Version.Builder> version) {
            return version(Version.builder().applyMutation(version).build());
        }
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String author;

        private String creationTime;

        private String description;

        private String homePageUrl;

        private Boolean isVerifiedAuthor;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private String licenseUrl;

        private String name;

        private String readmeUrl;

        private String spdxLicenseId;

        private String verifiedAuthorUrl;

        private Version version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            applicationId(model.applicationId);
            author(model.author);
            creationTime(model.creationTime);
            description(model.description);
            homePageUrl(model.homePageUrl);
            isVerifiedAuthor(model.isVerifiedAuthor);
            labels(model.labels);
            licenseUrl(model.licenseUrl);
            name(model.name);
            readmeUrl(model.readmeUrl);
            spdxLicenseId(model.spdxLicenseId);
            verifiedAuthorUrl(model.verifiedAuthorUrl);
            version(model.version);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAuthor() {
            return author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHomePageUrl() {
            return homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        public final Boolean getIsVerifiedAuthor() {
            return isVerifiedAuthor;
        }

        @Override
        public final Builder isVerifiedAuthor(Boolean isVerifiedAuthor) {
            this.isVerifiedAuthor = isVerifiedAuthor;
            return this;
        }

        public final void setIsVerifiedAuthor(Boolean isVerifiedAuthor) {
            this.isVerifiedAuthor = isVerifiedAuthor;
        }

        public final Collection<String> getLabels() {
            return labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        public final String getLicenseUrl() {
            return licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getReadmeUrl() {
            return readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        public final String getSpdxLicenseId() {
            return spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        public final String getVerifiedAuthorUrl() {
            return verifiedAuthorUrl;
        }

        @Override
        public final Builder verifiedAuthorUrl(String verifiedAuthorUrl) {
            this.verifiedAuthorUrl = verifiedAuthorUrl;
            return this;
        }

        public final void setVerifiedAuthorUrl(String verifiedAuthorUrl) {
            this.verifiedAuthorUrl = verifiedAuthorUrl;
        }

        public final Version.Builder getVersion() {
            return version != null ? version.toBuilder() : null;
        }

        @Override
        public final Builder version(Version version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Version.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
