/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.internal.UserAgentUtils;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse;
import software.amazon.awssdk.services.securitylake.model.SubscriberResource;

public class ListSubscribersPublisher
implements SdkPublisher<ListSubscribersResponse> {
    private final SecurityLakeAsyncClient client;
    private final ListSubscribersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscribersPublisher(SecurityLakeAsyncClient client, ListSubscribersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscribersPublisher(SecurityLakeAsyncClient client, ListSubscribersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscribersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubscribersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubscriberResource> subscribers() {
        Function<ListSubscribersResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscribers() != null) {
                return response.subscribers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubscribersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubscribersResponseFetcher
    implements AsyncPageFetcher<ListSubscribersResponse> {
        private ListSubscribersResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscribersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubscribersResponse> nextPage(ListSubscribersResponse previousPage) {
            if (previousPage == null) {
                return ListSubscribersPublisher.this.client.listSubscribers(ListSubscribersPublisher.this.firstRequest);
            }
            return ListSubscribersPublisher.this.client.listSubscribers((ListSubscribersRequest)((Object)ListSubscribersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

