/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.DataLakeEncryptionConfiguration;
import software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleConfiguration;
import software.amazon.awssdk.services.securitylake.model.DataLakeReplicationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeConfiguration> {
    private static final SdkField<DataLakeEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(DataLakeConfiguration.getter(DataLakeConfiguration::encryptionConfiguration)).setter(DataLakeConfiguration.setter(Builder::encryptionConfiguration)).constructor(DataLakeEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<DataLakeLifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifecycleConfiguration").getter(DataLakeConfiguration.getter(DataLakeConfiguration::lifecycleConfiguration)).setter(DataLakeConfiguration.setter(Builder::lifecycleConfiguration)).constructor(DataLakeLifecycleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleConfiguration").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(DataLakeConfiguration.getter(DataLakeConfiguration::region)).setter(DataLakeConfiguration.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<DataLakeReplicationConfiguration> REPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("replicationConfiguration").getter(DataLakeConfiguration.getter(DataLakeConfiguration::replicationConfiguration)).setter(DataLakeConfiguration.setter(Builder::replicationConfiguration)).constructor(DataLakeReplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_CONFIGURATION_FIELD, LIFECYCLE_CONFIGURATION_FIELD, REGION_FIELD, REPLICATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLakeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataLakeEncryptionConfiguration encryptionConfiguration;
    private final DataLakeLifecycleConfiguration lifecycleConfiguration;
    private final String region;
    private final DataLakeReplicationConfiguration replicationConfiguration;

    private DataLakeConfiguration(BuilderImpl builder) {
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
        this.region = builder.region;
        this.replicationConfiguration = builder.replicationConfiguration;
    }

    public final DataLakeEncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final DataLakeLifecycleConfiguration lifecycleConfiguration() {
        return this.lifecycleConfiguration;
    }

    public final String region() {
        return this.region;
    }

    public final DataLakeReplicationConfiguration replicationConfiguration() {
        return this.replicationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeConfiguration)) {
            return false;
        }
        DataLakeConfiguration other = (DataLakeConfiguration)obj;
        return Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.lifecycleConfiguration(), other.lifecycleConfiguration()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.replicationConfiguration(), other.replicationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeConfiguration").add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("LifecycleConfiguration", (Object)this.lifecycleConfiguration()).add("Region", (Object)this.region()).add("ReplicationConfiguration", (Object)this.replicationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "lifecycleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfiguration()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "replicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.replicationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("lifecycleConfiguration", LIFECYCLE_CONFIGURATION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("replicationConfiguration", REPLICATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeConfiguration, T> g) {
        return obj -> g.apply((DataLakeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataLakeEncryptionConfiguration encryptionConfiguration;
        private DataLakeLifecycleConfiguration lifecycleConfiguration;
        private String region;
        private DataLakeReplicationConfiguration replicationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeConfiguration model) {
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.lifecycleConfiguration(model.lifecycleConfiguration);
            this.region(model.region);
            this.replicationConfiguration(model.replicationConfiguration);
        }

        public final DataLakeEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(DataLakeEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final DataLakeLifecycleConfiguration.Builder getLifecycleConfiguration() {
            return this.lifecycleConfiguration != null ? this.lifecycleConfiguration.toBuilder() : null;
        }

        public final void setLifecycleConfiguration(DataLakeLifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final DataLakeReplicationConfiguration.Builder getReplicationConfiguration() {
            return this.replicationConfiguration != null ? this.replicationConfiguration.toBuilder() : null;
        }

        public final void setReplicationConfiguration(DataLakeReplicationConfiguration.BuilderImpl replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration != null ? replicationConfiguration.build() : null;
        }

        @Override
        public final Builder replicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        public DataLakeConfiguration build() {
            return new DataLakeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeConfiguration> {
        public Builder encryptionConfiguration(DataLakeEncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<DataLakeEncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((DataLakeEncryptionConfiguration)((DataLakeEncryptionConfiguration.Builder)DataLakeEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder lifecycleConfiguration(DataLakeLifecycleConfiguration var1);

        default public Builder lifecycleConfiguration(Consumer<DataLakeLifecycleConfiguration.Builder> lifecycleConfiguration) {
            return this.lifecycleConfiguration((DataLakeLifecycleConfiguration)((DataLakeLifecycleConfiguration.Builder)DataLakeLifecycleConfiguration.builder().applyMutation(lifecycleConfiguration)).build());
        }

        public Builder region(String var1);

        public Builder replicationConfiguration(DataLakeReplicationConfiguration var1);

        default public Builder replicationConfiguration(Consumer<DataLakeReplicationConfiguration.Builder> replicationConfiguration) {
            return this.replicationConfiguration((DataLakeReplicationConfiguration)((DataLakeReplicationConfiguration.Builder)DataLakeReplicationConfiguration.builder().applyMutation(replicationConfiguration)).build());
        }
    }
}

