/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccountListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAwsLogSourceResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, CreateAwsLogSourceResponse> {
    private static final SdkField<List<String>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failed").getter(CreateAwsLogSourceResponse.getter(CreateAwsLogSourceResponse::failed)).setter(CreateAwsLogSourceResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAwsLogSourceResponse.memberNameToFieldInitializer();
    private final List<String> failed;

    private CreateAwsLogSourceResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<String> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAwsLogSourceResponse)) {
            return false;
        }
        CreateAwsLogSourceResponse other = (CreateAwsLogSourceResponse)((Object)obj);
        return this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAwsLogSourceResponse").add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAwsLogSourceResponse, T> g) {
        return obj -> g.apply((CreateAwsLogSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private List<String> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAwsLogSourceResponse model) {
            super(model);
            this.failed(model.failed);
        }

        public final Collection<String> getFailed() {
            if (this.failed instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failed;
        }

        public final void setFailed(Collection<String> failed) {
            this.failed = AccountListCopier.copy(failed);
        }

        @Override
        public final Builder failed(Collection<String> failed) {
            this.failed = AccountListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(String ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        public CreateAwsLogSourceResponse build() {
            return new CreateAwsLogSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAwsLogSourceResponse> {
        public Builder failed(Collection<String> var1);

        public Builder failed(String ... var1);
    }
}

