/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AwsIdentity;
import software.amazon.awssdk.services.securitylake.model.LogSourceResource;
import software.amazon.awssdk.services.securitylake.model.LogSourceResourceListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSubscriberRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, UpdateSubscriberRequest> {
    private static final SdkField<List<LogSourceResource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::sources)).setter(UpdateSubscriberRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberDescription").getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::subscriberDescription)).setter(UpdateSubscriberRequest.setter(Builder::subscriberDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build()}).build();
    private static final SdkField<String> SUBSCRIBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberId").getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::subscriberId)).setter(UpdateSubscriberRequest.setter(Builder::subscriberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("subscriberId").build()}).build();
    private static final SdkField<AwsIdentity> SUBSCRIBER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("subscriberIdentity").getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::subscriberIdentity)).setter(UpdateSubscriberRequest.setter(Builder::subscriberIdentity)).constructor(AwsIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberIdentity").build()}).build();
    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberName").getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::subscriberName)).setter(UpdateSubscriberRequest.setter(Builder::subscriberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD, SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_ID_FIELD, SUBSCRIBER_IDENTITY_FIELD, SUBSCRIBER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSubscriberRequest.memberNameToFieldInitializer();
    private final List<LogSourceResource> sources;
    private final String subscriberDescription;
    private final String subscriberId;
    private final AwsIdentity subscriberIdentity;
    private final String subscriberName;

    private UpdateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.sources = builder.sources;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberId = builder.subscriberId;
        this.subscriberIdentity = builder.subscriberIdentity;
        this.subscriberName = builder.subscriberName;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<LogSourceResource> sources() {
        return this.sources;
    }

    public final String subscriberDescription() {
        return this.subscriberDescription;
    }

    public final String subscriberId() {
        return this.subscriberId;
    }

    public final AwsIdentity subscriberIdentity() {
        return this.subscriberIdentity;
    }

    public final String subscriberName() {
        return this.subscriberName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest)((Object)obj);
        return this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.subscriberDescription(), other.subscriberDescription()) && Objects.equals(this.subscriberId(), other.subscriberId()) && Objects.equals(this.subscriberIdentity(), other.subscriberIdentity()) && Objects.equals(this.subscriberName(), other.subscriberName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSubscriberRequest").add("Sources", this.hasSources() ? this.sources() : null).add("SubscriberDescription", (Object)this.subscriberDescription()).add("SubscriberId", (Object)this.subscriberId()).add("SubscriberIdentity", (Object)this.subscriberIdentity()).add("SubscriberName", (Object)this.subscriberName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "subscriberDescription": {
                return Optional.ofNullable(clazz.cast(this.subscriberDescription()));
            }
            case "subscriberId": {
                return Optional.ofNullable(clazz.cast(this.subscriberId()));
            }
            case "subscriberIdentity": {
                return Optional.ofNullable(clazz.cast(this.subscriberIdentity()));
            }
            case "subscriberName": {
                return Optional.ofNullable(clazz.cast(this.subscriberName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sources", SOURCES_FIELD);
        map.put("subscriberDescription", SUBSCRIBER_DESCRIPTION_FIELD);
        map.put("subscriberId", SUBSCRIBER_ID_FIELD);
        map.put("subscriberIdentity", SUBSCRIBER_IDENTITY_FIELD);
        map.put("subscriberName", SUBSCRIBER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriberRequest, T> g) {
        return obj -> g.apply((UpdateSubscriberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private List<LogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();
        private String subscriberDescription;
        private String subscriberId;
        private AwsIdentity subscriberIdentity;
        private String subscriberName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberRequest model) {
            super(model);
            this.sources(model.sources);
            this.subscriberDescription(model.subscriberDescription);
            this.subscriberId(model.subscriberId);
            this.subscriberIdentity(model.subscriberIdentity);
            this.subscriberName(model.subscriberName);
        }

        public final List<LogSourceResource.Builder> getSources() {
            List<LogSourceResource.Builder> result = LogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LogSourceResource.BuilderImpl> sources) {
            this.sources = LogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LogSourceResource> sources) {
            this.sources = LogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LogSourceResource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LogSourceResource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (LogSourceResource)((LogSourceResource.Builder)LogSourceResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberDescription() {
            return this.subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final String getSubscriberId() {
            return this.subscriberId;
        }

        public final void setSubscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
        }

        @Override
        public final Builder subscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
            return this;
        }

        public final AwsIdentity.Builder getSubscriberIdentity() {
            return this.subscriberIdentity != null ? this.subscriberIdentity.toBuilder() : null;
        }

        public final void setSubscriberIdentity(AwsIdentity.BuilderImpl subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity != null ? subscriberIdentity.build() : null;
        }

        @Override
        public final Builder subscriberIdentity(AwsIdentity subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity;
            return this;
        }

        public final String getSubscriberName() {
            return this.subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSubscriberRequest build() {
            return new UpdateSubscriberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSubscriberRequest> {
        public Builder sources(Collection<LogSourceResource> var1);

        public Builder sources(LogSourceResource ... var1);

        public Builder sources(Consumer<LogSourceResource.Builder> ... var1);

        public Builder subscriberDescription(String var1);

        public Builder subscriberId(String var1);

        public Builder subscriberIdentity(AwsIdentity var1);

        default public Builder subscriberIdentity(Consumer<AwsIdentity.Builder> subscriberIdentity) {
            return this.subscriberIdentity((AwsIdentity)((AwsIdentity.Builder)AwsIdentity.builder().applyMutation(subscriberIdentity)).build());
        }

        public Builder subscriberName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

