/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccessType;
import software.amazon.awssdk.services.securitylake.model.AccessTypeListCopier;
import software.amazon.awssdk.services.securitylake.model.AwsIdentity;
import software.amazon.awssdk.services.securitylake.model.LogSourceResource;
import software.amazon.awssdk.services.securitylake.model.LogSourceResourceListCopier;
import software.amazon.awssdk.services.securitylake.model.SubscriberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscriberResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscriberResource> {
    private static final SdkField<List<String>> ACCESS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessTypes").getter(SubscriberResource.getter(SubscriberResource::accessTypesAsStrings)).setter(SubscriberResource.setter(Builder::accessTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SubscriberResource.getter(SubscriberResource::createdAt)).setter(SubscriberResource.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(SubscriberResource.getter(SubscriberResource::resourceShareArn)).setter(SubscriberResource.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareName").getter(SubscriberResource.getter(SubscriberResource::resourceShareName)).setter(SubscriberResource.setter(Builder::resourceShareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(SubscriberResource.getter(SubscriberResource::roleArn)).setter(SubscriberResource.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketArn").getter(SubscriberResource.getter(SubscriberResource::s3BucketArn)).setter(SubscriberResource.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()}).build();
    private static final SdkField<List<LogSourceResource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(SubscriberResource.getter(SubscriberResource::sources)).setter(SubscriberResource.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSCRIBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberArn").getter(SubscriberResource.getter(SubscriberResource::subscriberArn)).setter(SubscriberResource.setter(Builder::subscriberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberArn").build()}).build();
    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberDescription").getter(SubscriberResource.getter(SubscriberResource::subscriberDescription)).setter(SubscriberResource.setter(Builder::subscriberDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build()}).build();
    private static final SdkField<String> SUBSCRIBER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberEndpoint").getter(SubscriberResource.getter(SubscriberResource::subscriberEndpoint)).setter(SubscriberResource.setter(Builder::subscriberEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberEndpoint").build()}).build();
    private static final SdkField<String> SUBSCRIBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberId").getter(SubscriberResource.getter(SubscriberResource::subscriberId)).setter(SubscriberResource.setter(Builder::subscriberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberId").build()}).build();
    private static final SdkField<AwsIdentity> SUBSCRIBER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("subscriberIdentity").getter(SubscriberResource.getter(SubscriberResource::subscriberIdentity)).setter(SubscriberResource.setter(Builder::subscriberIdentity)).constructor(AwsIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberIdentity").build()}).build();
    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberName").getter(SubscriberResource.getter(SubscriberResource::subscriberName)).setter(SubscriberResource.setter(Builder::subscriberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()}).build();
    private static final SdkField<String> SUBSCRIBER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberStatus").getter(SubscriberResource.getter(SubscriberResource::subscriberStatusAsString)).setter(SubscriberResource.setter(Builder::subscriberStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberStatus").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(SubscriberResource.getter(SubscriberResource::updatedAt)).setter(SubscriberResource.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPES_FIELD, CREATED_AT_FIELD, RESOURCE_SHARE_ARN_FIELD, RESOURCE_SHARE_NAME_FIELD, ROLE_ARN_FIELD, S3_BUCKET_ARN_FIELD, SOURCES_FIELD, SUBSCRIBER_ARN_FIELD, SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_ENDPOINT_FIELD, SUBSCRIBER_ID_FIELD, SUBSCRIBER_IDENTITY_FIELD, SUBSCRIBER_NAME_FIELD, SUBSCRIBER_STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accessTypes", ACCESS_TYPES_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
            this.put("resourceShareName", RESOURCE_SHARE_NAME_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("s3BucketArn", S3_BUCKET_ARN_FIELD);
            this.put("sources", SOURCES_FIELD);
            this.put("subscriberArn", SUBSCRIBER_ARN_FIELD);
            this.put("subscriberDescription", SUBSCRIBER_DESCRIPTION_FIELD);
            this.put("subscriberEndpoint", SUBSCRIBER_ENDPOINT_FIELD);
            this.put("subscriberId", SUBSCRIBER_ID_FIELD);
            this.put("subscriberIdentity", SUBSCRIBER_IDENTITY_FIELD);
            this.put("subscriberName", SUBSCRIBER_NAME_FIELD);
            this.put("subscriberStatus", SUBSCRIBER_STATUS_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> accessTypes;
    private final Instant createdAt;
    private final String resourceShareArn;
    private final String resourceShareName;
    private final String roleArn;
    private final String s3BucketArn;
    private final List<LogSourceResource> sources;
    private final String subscriberArn;
    private final String subscriberDescription;
    private final String subscriberEndpoint;
    private final String subscriberId;
    private final AwsIdentity subscriberIdentity;
    private final String subscriberName;
    private final String subscriberStatus;
    private final Instant updatedAt;

    private SubscriberResource(BuilderImpl builder) {
        this.accessTypes = builder.accessTypes;
        this.createdAt = builder.createdAt;
        this.resourceShareArn = builder.resourceShareArn;
        this.resourceShareName = builder.resourceShareName;
        this.roleArn = builder.roleArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.sources = builder.sources;
        this.subscriberArn = builder.subscriberArn;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberEndpoint = builder.subscriberEndpoint;
        this.subscriberId = builder.subscriberId;
        this.subscriberIdentity = builder.subscriberIdentity;
        this.subscriberName = builder.subscriberName;
        this.subscriberStatus = builder.subscriberStatus;
        this.updatedAt = builder.updatedAt;
    }

    public final List<AccessType> accessTypes() {
        return AccessTypeListCopier.copyStringToEnum(this.accessTypes);
    }

    public final boolean hasAccessTypes() {
        return this.accessTypes != null && !(this.accessTypes instanceof SdkAutoConstructList);
    }

    public final List<String> accessTypesAsStrings() {
        return this.accessTypes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String resourceShareArn() {
        return this.resourceShareArn;
    }

    public final String resourceShareName() {
        return this.resourceShareName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<LogSourceResource> sources() {
        return this.sources;
    }

    public final String subscriberArn() {
        return this.subscriberArn;
    }

    public final String subscriberDescription() {
        return this.subscriberDescription;
    }

    public final String subscriberEndpoint() {
        return this.subscriberEndpoint;
    }

    public final String subscriberId() {
        return this.subscriberId;
    }

    public final AwsIdentity subscriberIdentity() {
        return this.subscriberIdentity;
    }

    public final String subscriberName() {
        return this.subscriberName;
    }

    public final SubscriberStatus subscriberStatus() {
        return SubscriberStatus.fromValue(this.subscriberStatus);
    }

    public final String subscriberStatusAsString() {
        return this.subscriberStatus;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessTypes() ? this.accessTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriberResource)) {
            return false;
        }
        SubscriberResource other = (SubscriberResource)obj;
        return this.hasAccessTypes() == other.hasAccessTypes() && Objects.equals(this.accessTypesAsStrings(), other.accessTypesAsStrings()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.resourceShareName(), other.resourceShareName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.subscriberArn(), other.subscriberArn()) && Objects.equals(this.subscriberDescription(), other.subscriberDescription()) && Objects.equals(this.subscriberEndpoint(), other.subscriberEndpoint()) && Objects.equals(this.subscriberId(), other.subscriberId()) && Objects.equals(this.subscriberIdentity(), other.subscriberIdentity()) && Objects.equals(this.subscriberName(), other.subscriberName()) && Objects.equals(this.subscriberStatusAsString(), other.subscriberStatusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"SubscriberResource").add("AccessTypes", this.hasAccessTypes() ? this.accessTypesAsStrings() : null).add("CreatedAt", (Object)this.createdAt()).add("ResourceShareArn", (Object)this.resourceShareArn()).add("ResourceShareName", (Object)this.resourceShareName()).add("RoleArn", (Object)this.roleArn()).add("S3BucketArn", (Object)this.s3BucketArn()).add("Sources", this.hasSources() ? this.sources() : null).add("SubscriberArn", (Object)this.subscriberArn()).add("SubscriberDescription", (Object)this.subscriberDescription()).add("SubscriberEndpoint", (Object)this.subscriberEndpoint()).add("SubscriberId", (Object)this.subscriberId()).add("SubscriberIdentity", (Object)this.subscriberIdentity()).add("SubscriberName", (Object)this.subscriberName()).add("SubscriberStatus", (Object)this.subscriberStatusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessTypes": {
                return Optional.ofNullable(clazz.cast(this.accessTypesAsStrings()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "resourceShareName": {
                return Optional.ofNullable(clazz.cast(this.resourceShareName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "s3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "subscriberArn": {
                return Optional.ofNullable(clazz.cast(this.subscriberArn()));
            }
            case "subscriberDescription": {
                return Optional.ofNullable(clazz.cast(this.subscriberDescription()));
            }
            case "subscriberEndpoint": {
                return Optional.ofNullable(clazz.cast(this.subscriberEndpoint()));
            }
            case "subscriberId": {
                return Optional.ofNullable(clazz.cast(this.subscriberId()));
            }
            case "subscriberIdentity": {
                return Optional.ofNullable(clazz.cast(this.subscriberIdentity()));
            }
            case "subscriberName": {
                return Optional.ofNullable(clazz.cast(this.subscriberName()));
            }
            case "subscriberStatus": {
                return Optional.ofNullable(clazz.cast(this.subscriberStatusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SubscriberResource, T> g) {
        return obj -> g.apply((SubscriberResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accessTypes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String resourceShareArn;
        private String resourceShareName;
        private String roleArn;
        private String s3BucketArn;
        private List<LogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();
        private String subscriberArn;
        private String subscriberDescription;
        private String subscriberEndpoint;
        private String subscriberId;
        private AwsIdentity subscriberIdentity;
        private String subscriberName;
        private String subscriberStatus;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriberResource model) {
            this.accessTypesWithStrings(model.accessTypes);
            this.createdAt(model.createdAt);
            this.resourceShareArn(model.resourceShareArn);
            this.resourceShareName(model.resourceShareName);
            this.roleArn(model.roleArn);
            this.s3BucketArn(model.s3BucketArn);
            this.sources(model.sources);
            this.subscriberArn(model.subscriberArn);
            this.subscriberDescription(model.subscriberDescription);
            this.subscriberEndpoint(model.subscriberEndpoint);
            this.subscriberId(model.subscriberId);
            this.subscriberIdentity(model.subscriberIdentity);
            this.subscriberName(model.subscriberName);
            this.subscriberStatus(model.subscriberStatus);
            this.updatedAt(model.updatedAt);
        }

        public final Collection<String> getAccessTypes() {
            if (this.accessTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessTypes;
        }

        public final void setAccessTypes(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
        }

        @Override
        public final Builder accessTypesWithStrings(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypesWithStrings(String ... accessTypes) {
            this.accessTypesWithStrings(Arrays.asList(accessTypes));
            return this;
        }

        @Override
        public final Builder accessTypes(Collection<AccessType> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copyEnumToString(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypes(AccessType ... accessTypes) {
            this.accessTypes(Arrays.asList(accessTypes));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getResourceShareName() {
            return this.resourceShareName;
        }

        public final void setResourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
        }

        @Override
        public final Builder resourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final List<LogSourceResource.Builder> getSources() {
            List<LogSourceResource.Builder> result = LogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LogSourceResource.BuilderImpl> sources) {
            this.sources = LogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LogSourceResource> sources) {
            this.sources = LogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LogSourceResource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LogSourceResource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (LogSourceResource)((LogSourceResource.Builder)LogSourceResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberArn() {
            return this.subscriberArn;
        }

        public final void setSubscriberArn(String subscriberArn) {
            this.subscriberArn = subscriberArn;
        }

        @Override
        public final Builder subscriberArn(String subscriberArn) {
            this.subscriberArn = subscriberArn;
            return this;
        }

        public final String getSubscriberDescription() {
            return this.subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final String getSubscriberEndpoint() {
            return this.subscriberEndpoint;
        }

        public final void setSubscriberEndpoint(String subscriberEndpoint) {
            this.subscriberEndpoint = subscriberEndpoint;
        }

        @Override
        public final Builder subscriberEndpoint(String subscriberEndpoint) {
            this.subscriberEndpoint = subscriberEndpoint;
            return this;
        }

        public final String getSubscriberId() {
            return this.subscriberId;
        }

        public final void setSubscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
        }

        @Override
        public final Builder subscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
            return this;
        }

        public final AwsIdentity.Builder getSubscriberIdentity() {
            return this.subscriberIdentity != null ? this.subscriberIdentity.toBuilder() : null;
        }

        public final void setSubscriberIdentity(AwsIdentity.BuilderImpl subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity != null ? subscriberIdentity.build() : null;
        }

        @Override
        public final Builder subscriberIdentity(AwsIdentity subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity;
            return this;
        }

        public final String getSubscriberName() {
            return this.subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        public final String getSubscriberStatus() {
            return this.subscriberStatus;
        }

        public final void setSubscriberStatus(String subscriberStatus) {
            this.subscriberStatus = subscriberStatus;
        }

        @Override
        public final Builder subscriberStatus(String subscriberStatus) {
            this.subscriberStatus = subscriberStatus;
            return this;
        }

        @Override
        public final Builder subscriberStatus(SubscriberStatus subscriberStatus) {
            this.subscriberStatus(subscriberStatus == null ? null : subscriberStatus.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SubscriberResource build() {
            return new SubscriberResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscriberResource> {
        public Builder accessTypesWithStrings(Collection<String> var1);

        public Builder accessTypesWithStrings(String ... var1);

        public Builder accessTypes(Collection<AccessType> var1);

        public Builder accessTypes(AccessType ... var1);

        public Builder createdAt(Instant var1);

        public Builder resourceShareArn(String var1);

        public Builder resourceShareName(String var1);

        public Builder roleArn(String var1);

        public Builder s3BucketArn(String var1);

        public Builder sources(Collection<LogSourceResource> var1);

        public Builder sources(LogSourceResource ... var1);

        public Builder sources(Consumer<LogSourceResource.Builder> ... var1);

        public Builder subscriberArn(String var1);

        public Builder subscriberDescription(String var1);

        public Builder subscriberEndpoint(String var1);

        public Builder subscriberId(String var1);

        public Builder subscriberIdentity(AwsIdentity var1);

        default public Builder subscriberIdentity(Consumer<AwsIdentity.Builder> subscriberIdentity) {
            return this.subscriberIdentity((AwsIdentity)((AwsIdentity.Builder)AwsIdentity.builder().applyMutation(subscriberIdentity)).build());
        }

        public Builder subscriberName(String var1);

        public Builder subscriberStatus(String var1);

        public Builder subscriberStatus(SubscriberStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

