/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.DataLakeSource;
import software.amazon.awssdk.services.securitylake.model.DataLakeSourceListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataLakeSourcesResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, GetDataLakeSourcesResponse> {
    private static final SdkField<String> DATA_LAKE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataLakeArn").getter(GetDataLakeSourcesResponse.getter(GetDataLakeSourcesResponse::dataLakeArn)).setter(GetDataLakeSourcesResponse.setter(Builder::dataLakeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLakeArn").build()}).build();
    private static final SdkField<List<DataLakeSource>> DATA_LAKE_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataLakeSources").getter(GetDataLakeSourcesResponse.getter(GetDataLakeSourcesResponse::dataLakeSources)).setter(GetDataLakeSourcesResponse.setter(Builder::dataLakeSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLakeSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetDataLakeSourcesResponse.getter(GetDataLakeSourcesResponse::nextToken)).setter(GetDataLakeSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ARN_FIELD, DATA_LAKE_SOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final String dataLakeArn;
    private final List<DataLakeSource> dataLakeSources;
    private final String nextToken;

    private GetDataLakeSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.dataLakeArn = builder.dataLakeArn;
        this.dataLakeSources = builder.dataLakeSources;
        this.nextToken = builder.nextToken;
    }

    public final String dataLakeArn() {
        return this.dataLakeArn;
    }

    public final boolean hasDataLakeSources() {
        return this.dataLakeSources != null && !(this.dataLakeSources instanceof SdkAutoConstructList);
    }

    public final List<DataLakeSource> dataLakeSources() {
        return this.dataLakeSources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataLakeSources() ? this.dataLakeSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataLakeSourcesResponse)) {
            return false;
        }
        GetDataLakeSourcesResponse other = (GetDataLakeSourcesResponse)((Object)obj);
        return Objects.equals(this.dataLakeArn(), other.dataLakeArn()) && this.hasDataLakeSources() == other.hasDataLakeSources() && Objects.equals(this.dataLakeSources(), other.dataLakeSources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataLakeSourcesResponse").add("DataLakeArn", (Object)this.dataLakeArn()).add("DataLakeSources", this.hasDataLakeSources() ? this.dataLakeSources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataLakeArn": {
                return Optional.ofNullable(clazz.cast(this.dataLakeArn()));
            }
            case "dataLakeSources": {
                return Optional.ofNullable(clazz.cast(this.dataLakeSources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataLakeSourcesResponse, T> g) {
        return obj -> g.apply((GetDataLakeSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private String dataLakeArn;
        private List<DataLakeSource> dataLakeSources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataLakeSourcesResponse model) {
            super(model);
            this.dataLakeArn(model.dataLakeArn);
            this.dataLakeSources(model.dataLakeSources);
            this.nextToken(model.nextToken);
        }

        public final String getDataLakeArn() {
            return this.dataLakeArn;
        }

        public final void setDataLakeArn(String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
        }

        @Override
        public final Builder dataLakeArn(String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
            return this;
        }

        public final List<DataLakeSource.Builder> getDataLakeSources() {
            List<DataLakeSource.Builder> result = DataLakeSourceListCopier.copyToBuilder(this.dataLakeSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataLakeSources(Collection<DataLakeSource.BuilderImpl> dataLakeSources) {
            this.dataLakeSources = DataLakeSourceListCopier.copyFromBuilder(dataLakeSources);
        }

        @Override
        public final Builder dataLakeSources(Collection<DataLakeSource> dataLakeSources) {
            this.dataLakeSources = DataLakeSourceListCopier.copy(dataLakeSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeSources(DataLakeSource ... dataLakeSources) {
            this.dataLakeSources(Arrays.asList(dataLakeSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeSources(Consumer<DataLakeSource.Builder> ... dataLakeSources) {
            this.dataLakeSources(Stream.of(dataLakeSources).map(c -> (DataLakeSource)((DataLakeSource.Builder)DataLakeSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDataLakeSourcesResponse build() {
            return new GetDataLakeSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataLakeSourcesResponse> {
        public Builder dataLakeArn(String var1);

        public Builder dataLakeSources(Collection<DataLakeSource> var1);

        public Builder dataLakeSources(DataLakeSource ... var1);

        public Builder dataLakeSources(Consumer<DataLakeSource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

