/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration;
import software.amazon.awssdk.services.securitylake.model.DataLakeConfigurationListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataLakeRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, UpdateDataLakeRequest> {
    private static final SdkField<List<DataLakeConfiguration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurations").getter(UpdateDataLakeRequest.getter(UpdateDataLakeRequest::configurations)).setter(UpdateDataLakeRequest.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> META_STORE_MANAGER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metaStoreManagerRoleArn").getter(UpdateDataLakeRequest.getter(UpdateDataLakeRequest::metaStoreManagerRoleArn)).setter(UpdateDataLakeRequest.setter(Builder::metaStoreManagerRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaStoreManagerRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD, META_STORE_MANAGER_ROLE_ARN_FIELD));
    private final List<DataLakeConfiguration> configurations;
    private final String metaStoreManagerRoleArn;

    private UpdateDataLakeRequest(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.metaStoreManagerRoleArn = builder.metaStoreManagerRoleArn;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<DataLakeConfiguration> configurations() {
        return this.configurations;
    }

    public final String metaStoreManagerRoleArn() {
        return this.metaStoreManagerRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metaStoreManagerRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataLakeRequest)) {
            return false;
        }
        UpdateDataLakeRequest other = (UpdateDataLakeRequest)((Object)obj);
        return this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.metaStoreManagerRoleArn(), other.metaStoreManagerRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataLakeRequest").add("Configurations", this.hasConfigurations() ? this.configurations() : null).add("MetaStoreManagerRoleArn", (Object)this.metaStoreManagerRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "metaStoreManagerRoleArn": {
                return Optional.ofNullable(clazz.cast(this.metaStoreManagerRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataLakeRequest, T> g) {
        return obj -> g.apply((UpdateDataLakeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private List<DataLakeConfiguration> configurations = DefaultSdkAutoConstructList.getInstance();
        private String metaStoreManagerRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataLakeRequest model) {
            super(model);
            this.configurations(model.configurations);
            this.metaStoreManagerRoleArn(model.metaStoreManagerRoleArn);
        }

        public final List<DataLakeConfiguration.Builder> getConfigurations() {
            List<DataLakeConfiguration.Builder> result = DataLakeConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<DataLakeConfiguration.BuilderImpl> configurations) {
            this.configurations = DataLakeConfigurationListCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Collection<DataLakeConfiguration> configurations) {
            this.configurations = DataLakeConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(DataLakeConfiguration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<DataLakeConfiguration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (DataLakeConfiguration)((DataLakeConfiguration.Builder)DataLakeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetaStoreManagerRoleArn() {
            return this.metaStoreManagerRoleArn;
        }

        public final void setMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
            this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
        }

        @Override
        public final Builder metaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
            this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataLakeRequest build() {
            return new UpdateDataLakeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataLakeRequest> {
        public Builder configurations(Collection<DataLakeConfiguration> var1);

        public Builder configurations(DataLakeConfiguration ... var1);

        public Builder configurations(Consumer<DataLakeConfiguration.Builder> ... var1);

        public Builder metaStoreManagerRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

