/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.model.DataLakeSource;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse;

public class GetDataLakeSourcesIterable
implements SdkIterable<GetDataLakeSourcesResponse> {
    private final SecurityLakeClient client;
    private final GetDataLakeSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDataLakeSourcesIterable(SecurityLakeClient client, GetDataLakeSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDataLakeSourcesResponseFetcher();
    }

    public Iterator<GetDataLakeSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataLakeSource> dataLakeSources() {
        Function<GetDataLakeSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataLakeSources() != null) {
                return response.dataLakeSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetDataLakeSourcesResponseFetcher
    implements SyncPageFetcher<GetDataLakeSourcesResponse> {
        private GetDataLakeSourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetDataLakeSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDataLakeSourcesResponse nextPage(GetDataLakeSourcesResponse previousPage) {
            if (previousPage == null) {
                return GetDataLakeSourcesIterable.this.client.getDataLakeSources(GetDataLakeSourcesIterable.this.firstRequest);
            }
            return GetDataLakeSourcesIterable.this.client.getDataLakeSources((GetDataLakeSourcesRequest)((Object)GetDataLakeSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

