/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.model.DataLakeSource;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse;

public class GetDataLakeSourcesPublisher
implements SdkPublisher<GetDataLakeSourcesResponse> {
    private final SecurityLakeAsyncClient client;
    private final GetDataLakeSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDataLakeSourcesPublisher(SecurityLakeAsyncClient client, GetDataLakeSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDataLakeSourcesPublisher(SecurityLakeAsyncClient client, GetDataLakeSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDataLakeSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDataLakeSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataLakeSource> dataLakeSources() {
        Function<GetDataLakeSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataLakeSources() != null) {
                return response.dataLakeSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDataLakeSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDataLakeSourcesResponseFetcher
    implements AsyncPageFetcher<GetDataLakeSourcesResponse> {
        private GetDataLakeSourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetDataLakeSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDataLakeSourcesResponse> nextPage(GetDataLakeSourcesResponse previousPage) {
            if (previousPage == null) {
                return GetDataLakeSourcesPublisher.this.client.getDataLakeSources(GetDataLakeSourcesPublisher.this.firstRequest);
            }
            return GetDataLakeSourcesPublisher.this.client.getDataLakeSources((GetDataLakeSourcesRequest)((Object)GetDataLakeSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

