/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securitylake.model.Region;
import software.amazon.awssdk.services.securitylake.model.RegionSetCopier;
import software.amazon.awssdk.services.securitylake.model.RetentionSetting;
import software.amazon.awssdk.services.securitylake.model.RetentionSettingListCopier;
import software.amazon.awssdk.services.securitylake.model.SettingsStatus;
import software.amazon.awssdk.services.securitylake.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LakeConfigurationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LakeConfigurationResponse> {
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(LakeConfigurationResponse.getter(LakeConfigurationResponse::encryptionKey)).setter(LakeConfigurationResponse.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<List<String>> REPLICATION_DESTINATION_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationDestinationRegions").getter(LakeConfigurationResponse.getter(LakeConfigurationResponse::replicationDestinationRegionsAsStrings)).setter(LakeConfigurationResponse.setter(Builder::replicationDestinationRegionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationDestinationRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationRoleArn").getter(LakeConfigurationResponse.getter(LakeConfigurationResponse::replicationRoleArn)).setter(LakeConfigurationResponse.setter(Builder::replicationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRoleArn").build()}).build();
    private static final SdkField<List<RetentionSetting>> RETENTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("retentionSettings").getter(LakeConfigurationResponse.getter(LakeConfigurationResponse::retentionSettings)).setter(LakeConfigurationResponse.setter(Builder::retentionSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetentionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketArn").getter(LakeConfigurationResponse.getter(LakeConfigurationResponse::s3BucketArn)).setter(LakeConfigurationResponse.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LakeConfigurationResponse.getter(LakeConfigurationResponse::statusAsString)).setter(LakeConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tagsMap").getter(LakeConfigurationResponse.getter(LakeConfigurationResponse::tagsMap)).setter(LakeConfigurationResponse.setter(Builder::tagsMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagsMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_FIELD, REPLICATION_DESTINATION_REGIONS_FIELD, REPLICATION_ROLE_ARN_FIELD, RETENTION_SETTINGS_FIELD, S3_BUCKET_ARN_FIELD, STATUS_FIELD, TAGS_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String encryptionKey;
    private final List<String> replicationDestinationRegions;
    private final String replicationRoleArn;
    private final List<RetentionSetting> retentionSettings;
    private final String s3BucketArn;
    private final String status;
    private final Map<String, String> tagsMap;

    private LakeConfigurationResponse(BuilderImpl builder) {
        this.encryptionKey = builder.encryptionKey;
        this.replicationDestinationRegions = builder.replicationDestinationRegions;
        this.replicationRoleArn = builder.replicationRoleArn;
        this.retentionSettings = builder.retentionSettings;
        this.s3BucketArn = builder.s3BucketArn;
        this.status = builder.status;
        this.tagsMap = builder.tagsMap;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final List<Region> replicationDestinationRegions() {
        return RegionSetCopier.copyStringToEnum(this.replicationDestinationRegions);
    }

    public final boolean hasReplicationDestinationRegions() {
        return this.replicationDestinationRegions != null && !(this.replicationDestinationRegions instanceof SdkAutoConstructList);
    }

    public final List<String> replicationDestinationRegionsAsStrings() {
        return this.replicationDestinationRegions;
    }

    public final String replicationRoleArn() {
        return this.replicationRoleArn;
    }

    public final boolean hasRetentionSettings() {
        return this.retentionSettings != null && !(this.retentionSettings instanceof SdkAutoConstructList);
    }

    public final List<RetentionSetting> retentionSettings() {
        return this.retentionSettings;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final SettingsStatus status() {
        return SettingsStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTagsMap() {
        return this.tagsMap != null && !(this.tagsMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tagsMap() {
        return this.tagsMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationDestinationRegions() ? this.replicationDestinationRegionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetentionSettings() ? this.retentionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsMap() ? this.tagsMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeConfigurationResponse)) {
            return false;
        }
        LakeConfigurationResponse other = (LakeConfigurationResponse)obj;
        return Objects.equals(this.encryptionKey(), other.encryptionKey()) && this.hasReplicationDestinationRegions() == other.hasReplicationDestinationRegions() && Objects.equals(this.replicationDestinationRegionsAsStrings(), other.replicationDestinationRegionsAsStrings()) && Objects.equals(this.replicationRoleArn(), other.replicationRoleArn()) && this.hasRetentionSettings() == other.hasRetentionSettings() && Objects.equals(this.retentionSettings(), other.retentionSettings()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTagsMap() == other.hasTagsMap() && Objects.equals(this.tagsMap(), other.tagsMap());
    }

    public final String toString() {
        return ToString.builder((String)"LakeConfigurationResponse").add("EncryptionKey", (Object)this.encryptionKey()).add("ReplicationDestinationRegions", this.hasReplicationDestinationRegions() ? this.replicationDestinationRegionsAsStrings() : null).add("ReplicationRoleArn", (Object)this.replicationRoleArn()).add("RetentionSettings", this.hasRetentionSettings() ? this.retentionSettings() : null).add("S3BucketArn", (Object)this.s3BucketArn()).add("Status", (Object)this.statusAsString()).add("TagsMap", this.hasTagsMap() ? this.tagsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "replicationDestinationRegions": {
                return Optional.ofNullable(clazz.cast(this.replicationDestinationRegionsAsStrings()));
            }
            case "replicationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.replicationRoleArn()));
            }
            case "retentionSettings": {
                return Optional.ofNullable(clazz.cast(this.retentionSettings()));
            }
            case "s3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tagsMap": {
                return Optional.ofNullable(clazz.cast(this.tagsMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeConfigurationResponse, T> g) {
        return obj -> g.apply((LakeConfigurationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionKey;
        private List<String> replicationDestinationRegions = DefaultSdkAutoConstructList.getInstance();
        private String replicationRoleArn;
        private List<RetentionSetting> retentionSettings = DefaultSdkAutoConstructList.getInstance();
        private String s3BucketArn;
        private String status;
        private Map<String, String> tagsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LakeConfigurationResponse model) {
            this.encryptionKey(model.encryptionKey);
            this.replicationDestinationRegionsWithStrings(model.replicationDestinationRegions);
            this.replicationRoleArn(model.replicationRoleArn);
            this.retentionSettings(model.retentionSettings);
            this.s3BucketArn(model.s3BucketArn);
            this.status(model.status);
            this.tagsMap(model.tagsMap);
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Collection<String> getReplicationDestinationRegions() {
            if (this.replicationDestinationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationDestinationRegions;
        }

        public final void setReplicationDestinationRegions(Collection<String> replicationDestinationRegions) {
            this.replicationDestinationRegions = RegionSetCopier.copy(replicationDestinationRegions);
        }

        @Override
        public final Builder replicationDestinationRegionsWithStrings(Collection<String> replicationDestinationRegions) {
            this.replicationDestinationRegions = RegionSetCopier.copy(replicationDestinationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationDestinationRegionsWithStrings(String ... replicationDestinationRegions) {
            this.replicationDestinationRegionsWithStrings(Arrays.asList(replicationDestinationRegions));
            return this;
        }

        @Override
        public final Builder replicationDestinationRegions(Collection<Region> replicationDestinationRegions) {
            this.replicationDestinationRegions = RegionSetCopier.copyEnumToString(replicationDestinationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationDestinationRegions(Region ... replicationDestinationRegions) {
            this.replicationDestinationRegions(Arrays.asList(replicationDestinationRegions));
            return this;
        }

        public final String getReplicationRoleArn() {
            return this.replicationRoleArn;
        }

        public final void setReplicationRoleArn(String replicationRoleArn) {
            this.replicationRoleArn = replicationRoleArn;
        }

        @Override
        public final Builder replicationRoleArn(String replicationRoleArn) {
            this.replicationRoleArn = replicationRoleArn;
            return this;
        }

        public final List<RetentionSetting.Builder> getRetentionSettings() {
            List<RetentionSetting.Builder> result = RetentionSettingListCopier.copyToBuilder(this.retentionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetentionSettings(Collection<RetentionSetting.BuilderImpl> retentionSettings) {
            this.retentionSettings = RetentionSettingListCopier.copyFromBuilder(retentionSettings);
        }

        @Override
        public final Builder retentionSettings(Collection<RetentionSetting> retentionSettings) {
            this.retentionSettings = RetentionSettingListCopier.copy(retentionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionSettings(RetentionSetting ... retentionSettings) {
            this.retentionSettings(Arrays.asList(retentionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionSettings(Consumer<RetentionSetting.Builder> ... retentionSettings) {
            this.retentionSettings(Stream.of(retentionSettings).map(c -> (RetentionSetting)((RetentionSetting.Builder)RetentionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SettingsStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTagsMap() {
            if (this.tagsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tagsMap;
        }

        public final void setTagsMap(Map<String, String> tagsMap) {
            this.tagsMap = TagsMapCopier.copy(tagsMap);
        }

        @Override
        public final Builder tagsMap(Map<String, String> tagsMap) {
            this.tagsMap = TagsMapCopier.copy(tagsMap);
            return this;
        }

        public LakeConfigurationResponse build() {
            return new LakeConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LakeConfigurationResponse> {
        public Builder encryptionKey(String var1);

        public Builder replicationDestinationRegionsWithStrings(Collection<String> var1);

        public Builder replicationDestinationRegionsWithStrings(String ... var1);

        public Builder replicationDestinationRegions(Collection<Region> var1);

        public Builder replicationDestinationRegions(Region ... var1);

        public Builder replicationRoleArn(String var1);

        public Builder retentionSettings(Collection<RetentionSetting> var1);

        public Builder retentionSettings(RetentionSetting ... var1);

        public Builder retentionSettings(Consumer<RetentionSetting.Builder> ... var1);

        public Builder s3BucketArn(String var1);

        public Builder status(String var1);

        public Builder status(SettingsStatus var1);

        public Builder tagsMap(Map<String, String> var1);
    }
}

