/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securitylake.model.AllDimensionsMapCopier;
import software.amazon.awssdk.services.securitylake.model.Dimension;
import software.amazon.awssdk.services.securitylake.model.DimensionSetCopier;
import software.amazon.awssdk.services.securitylake.model.InputSetCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.services.securitylake.model.TwoDimensionsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLogSourcesRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, ListLogSourcesRequest> {
    private static final SdkField<List<String>> INPUT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputOrder").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::inputOrderAsStrings)).setter(ListLogSourcesRequest.setter(Builder::inputOrderWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Map<String, List<String>>>> LIST_ALL_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("listAllDimensions").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::listAllDimensions)).setter(ListLogSourcesRequest.setter(Builder::listAllDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAllDimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIST_SINGLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listSingleDimension").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::listSingleDimension)).setter(ListLogSourcesRequest.setter(Builder::listSingleDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listSingleDimension").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> LIST_TWO_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("listTwoDimensions").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::listTwoDimensions)).setter(ListLogSourcesRequest.setter(Builder::listTwoDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listTwoDimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::maxResults)).setter(ListLogSourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::nextToken)).setter(ListLogSourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ORDER_FIELD, LIST_ALL_DIMENSIONS_FIELD, LIST_SINGLE_DIMENSION_FIELD, LIST_TWO_DIMENSIONS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> inputOrder;
    private final Map<String, Map<String, List<String>>> listAllDimensions;
    private final List<String> listSingleDimension;
    private final Map<String, List<String>> listTwoDimensions;
    private final Integer maxResults;
    private final String nextToken;

    private ListLogSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.inputOrder = builder.inputOrder;
        this.listAllDimensions = builder.listAllDimensions;
        this.listSingleDimension = builder.listSingleDimension;
        this.listTwoDimensions = builder.listTwoDimensions;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final List<Dimension> inputOrder() {
        return DimensionSetCopier.copyStringToEnum(this.inputOrder);
    }

    public final boolean hasInputOrder() {
        return this.inputOrder != null && !(this.inputOrder instanceof SdkAutoConstructList);
    }

    public final List<String> inputOrderAsStrings() {
        return this.inputOrder;
    }

    public final boolean hasListAllDimensions() {
        return this.listAllDimensions != null && !(this.listAllDimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, List<String>>> listAllDimensions() {
        return this.listAllDimensions;
    }

    public final boolean hasListSingleDimension() {
        return this.listSingleDimension != null && !(this.listSingleDimension instanceof SdkAutoConstructList);
    }

    public final List<String> listSingleDimension() {
        return this.listSingleDimension;
    }

    public final boolean hasListTwoDimensions() {
        return this.listTwoDimensions != null && !(this.listTwoDimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> listTwoDimensions() {
        return this.listTwoDimensions;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputOrder() ? this.inputOrderAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListAllDimensions() ? this.listAllDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListSingleDimension() ? this.listSingleDimension() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListTwoDimensions() ? this.listTwoDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogSourcesRequest)) {
            return false;
        }
        ListLogSourcesRequest other = (ListLogSourcesRequest)((Object)obj);
        return this.hasInputOrder() == other.hasInputOrder() && Objects.equals(this.inputOrderAsStrings(), other.inputOrderAsStrings()) && this.hasListAllDimensions() == other.hasListAllDimensions() && Objects.equals(this.listAllDimensions(), other.listAllDimensions()) && this.hasListSingleDimension() == other.hasListSingleDimension() && Objects.equals(this.listSingleDimension(), other.listSingleDimension()) && this.hasListTwoDimensions() == other.hasListTwoDimensions() && Objects.equals(this.listTwoDimensions(), other.listTwoDimensions()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLogSourcesRequest").add("InputOrder", this.hasInputOrder() ? this.inputOrderAsStrings() : null).add("ListAllDimensions", this.hasListAllDimensions() ? this.listAllDimensions() : null).add("ListSingleDimension", this.hasListSingleDimension() ? this.listSingleDimension() : null).add("ListTwoDimensions", this.hasListTwoDimensions() ? this.listTwoDimensions() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputOrder": {
                return Optional.ofNullable(clazz.cast(this.inputOrderAsStrings()));
            }
            case "listAllDimensions": {
                return Optional.ofNullable(clazz.cast(this.listAllDimensions()));
            }
            case "listSingleDimension": {
                return Optional.ofNullable(clazz.cast(this.listSingleDimension()));
            }
            case "listTwoDimensions": {
                return Optional.ofNullable(clazz.cast(this.listTwoDimensions()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogSourcesRequest, T> g) {
        return obj -> g.apply((ListLogSourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private List<String> inputOrder = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Map<String, List<String>>> listAllDimensions = DefaultSdkAutoConstructMap.getInstance();
        private List<String> listSingleDimension = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> listTwoDimensions = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogSourcesRequest model) {
            super(model);
            this.inputOrderWithStrings(model.inputOrder);
            this.listAllDimensions(model.listAllDimensions);
            this.listSingleDimension(model.listSingleDimension);
            this.listTwoDimensions(model.listTwoDimensions);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getInputOrder() {
            if (this.inputOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputOrder;
        }

        public final void setInputOrder(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
        }

        @Override
        public final Builder inputOrderWithStrings(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrderWithStrings(String ... inputOrder) {
            this.inputOrderWithStrings(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public final Builder inputOrder(Collection<Dimension> inputOrder) {
            this.inputOrder = DimensionSetCopier.copyEnumToString(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrder(Dimension ... inputOrder) {
            this.inputOrder(Arrays.asList(inputOrder));
            return this;
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getListAllDimensions() {
            if (this.listAllDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.listAllDimensions;
        }

        public final void setListAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> listAllDimensions) {
            this.listAllDimensions = AllDimensionsMapCopier.copy(listAllDimensions);
        }

        @Override
        public final Builder listAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> listAllDimensions) {
            this.listAllDimensions = AllDimensionsMapCopier.copy(listAllDimensions);
            return this;
        }

        public final Collection<String> getListSingleDimension() {
            if (this.listSingleDimension instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listSingleDimension;
        }

        public final void setListSingleDimension(Collection<String> listSingleDimension) {
            this.listSingleDimension = InputSetCopier.copy(listSingleDimension);
        }

        @Override
        public final Builder listSingleDimension(Collection<String> listSingleDimension) {
            this.listSingleDimension = InputSetCopier.copy(listSingleDimension);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listSingleDimension(String ... listSingleDimension) {
            this.listSingleDimension(Arrays.asList(listSingleDimension));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getListTwoDimensions() {
            if (this.listTwoDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.listTwoDimensions;
        }

        public final void setListTwoDimensions(Map<String, ? extends Collection<String>> listTwoDimensions) {
            this.listTwoDimensions = TwoDimensionsMapCopier.copy(listTwoDimensions);
        }

        @Override
        public final Builder listTwoDimensions(Map<String, ? extends Collection<String>> listTwoDimensions) {
            this.listTwoDimensions = TwoDimensionsMapCopier.copy(listTwoDimensions);
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLogSourcesRequest build() {
            return new ListLogSourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLogSourcesRequest> {
        public Builder inputOrderWithStrings(Collection<String> var1);

        public Builder inputOrderWithStrings(String ... var1);

        public Builder inputOrder(Collection<Dimension> var1);

        public Builder inputOrder(Dimension ... var1);

        public Builder listAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> var1);

        public Builder listSingleDimension(Collection<String> var1);

        public Builder listSingleDimension(String ... var1);

        public Builder listTwoDimensions(Map<String, ? extends Collection<String>> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

