/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriberResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, CreateSubscriberResponse> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(CreateSubscriberResponse.getter(CreateSubscriberResponse::resourceShareArn)).setter(CreateSubscriberResponse.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareName").getter(CreateSubscriberResponse.getter(CreateSubscriberResponse::resourceShareName)).setter(CreateSubscriberResponse.setter(Builder::resourceShareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateSubscriberResponse.getter(CreateSubscriberResponse::roleArn)).setter(CreateSubscriberResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketArn").getter(CreateSubscriberResponse.getter(CreateSubscriberResponse::s3BucketArn)).setter(CreateSubscriberResponse.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()}).build();
    private static final SdkField<String> SNS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsArn").getter(CreateSubscriberResponse.getter(CreateSubscriberResponse::snsArn)).setter(CreateSubscriberResponse.setter(Builder::snsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsArn").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionId").getter(CreateSubscriberResponse.getter(CreateSubscriberResponse::subscriptionId)).setter(CreateSubscriberResponse.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD, RESOURCE_SHARE_NAME_FIELD, ROLE_ARN_FIELD, S3_BUCKET_ARN_FIELD, SNS_ARN_FIELD, SUBSCRIPTION_ID_FIELD));
    private final String resourceShareArn;
    private final String resourceShareName;
    private final String roleArn;
    private final String s3BucketArn;
    private final String snsArn;
    private final String subscriptionId;

    private CreateSubscriberResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.resourceShareName = builder.resourceShareName;
        this.roleArn = builder.roleArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.snsArn = builder.snsArn;
        this.subscriptionId = builder.subscriptionId;
    }

    public final String resourceShareArn() {
        return this.resourceShareArn;
    }

    public final String resourceShareName() {
        return this.resourceShareName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final String snsArn() {
        return this.snsArn;
    }

    public final String subscriptionId() {
        return this.subscriptionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberResponse)) {
            return false;
        }
        CreateSubscriberResponse other = (CreateSubscriberResponse)((Object)obj);
        return Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.resourceShareName(), other.resourceShareName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.snsArn(), other.snsArn()) && Objects.equals(this.subscriptionId(), other.subscriptionId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubscriberResponse").add("ResourceShareArn", (Object)this.resourceShareArn()).add("ResourceShareName", (Object)this.resourceShareName()).add("RoleArn", (Object)this.roleArn()).add("S3BucketArn", (Object)this.s3BucketArn()).add("SnsArn", (Object)this.snsArn()).add("SubscriptionId", (Object)this.subscriptionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "resourceShareName": {
                return Optional.ofNullable(clazz.cast(this.resourceShareName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "s3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "snsArn": {
                return Optional.ofNullable(clazz.cast(this.snsArn()));
            }
            case "subscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriberResponse, T> g) {
        return obj -> g.apply((CreateSubscriberResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private String resourceShareArn;
        private String resourceShareName;
        private String roleArn;
        private String s3BucketArn;
        private String snsArn;
        private String subscriptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriberResponse model) {
            super(model);
            this.resourceShareArn(model.resourceShareArn);
            this.resourceShareName(model.resourceShareName);
            this.roleArn(model.roleArn);
            this.s3BucketArn(model.s3BucketArn);
            this.snsArn(model.snsArn);
            this.subscriptionId(model.subscriptionId);
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getResourceShareName() {
            return this.resourceShareName;
        }

        public final void setResourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
        }

        @Override
        public final Builder resourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getSnsArn() {
            return this.snsArn;
        }

        public final void setSnsArn(String snsArn) {
            this.snsArn = snsArn;
        }

        @Override
        public final Builder snsArn(String snsArn) {
            this.snsArn = snsArn;
            return this;
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Override
        public CreateSubscriberResponse build() {
            return new CreateSubscriberResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriberResponse> {
        public Builder resourceShareArn(String var1);

        public Builder resourceShareName(String var1);

        public Builder roleArn(String var1);

        public Builder s3BucketArn(String var1);

        public Builder snsArn(String var1);

        public Builder subscriptionId(String var1);
    }
}

