/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HttpsMethod {
    POST("POST"),
    PUT("PUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HttpsMethod> VALUE_MAP;
    private final String value;

    private HttpsMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HttpsMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HttpsMethod> knownValues() {
        EnumSet<HttpsMethod> knownValues = EnumSet.allOf(HttpsMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HttpsMethod.class, HttpsMethod::toString);
    }
}

