/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.securitylake.DefaultSecurityLakeBaseClientBuilder;
import software.amazon.awssdk.services.securitylake.DefaultSecurityLakeClient;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.SecurityLakeClientBuilder;
import software.amazon.awssdk.services.securitylake.SecurityLakeServiceClientConfiguration;
import software.amazon.awssdk.services.securitylake.endpoints.SecurityLakeEndpointProvider;

@SdkInternalApi
final class DefaultSecurityLakeClientBuilder
extends DefaultSecurityLakeBaseClientBuilder<SecurityLakeClientBuilder, SecurityLakeClient>
implements SecurityLakeClientBuilder {
    DefaultSecurityLakeClientBuilder() {
    }

    @Override
    public DefaultSecurityLakeClientBuilder endpointProvider(SecurityLakeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SecurityLakeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSecurityLakeClientBuilder.validateClientOptions(clientConfiguration);
        SecurityLakeServiceClientConfiguration serviceClientConfiguration = SecurityLakeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultSecurityLakeClient(serviceClientConfiguration, clientConfiguration);
    }
}

