/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Region {
    US_EAST_1("us-east-1"),
    US_WEST_2("us-west-2"),
    EU_CENTRAL_1("eu-central-1"),
    US_EAST_2("us-east-2"),
    EU_WEST_1("eu-west-1"),
    AP_NORTHEAST_1("ap-northeast-1"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Region> VALUE_MAP;
    private final String value;

    private Region(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Region fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Region> knownValues() {
        EnumSet<Region> knownValues = EnumSet.allOf(Region.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Region.class, Region::toString);
    }
}

