/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.model.AccountSources;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse;

public class GetDatalakeStatusPublisher
implements SdkPublisher<GetDatalakeStatusResponse> {
    private final SecurityLakeAsyncClient client;
    private final GetDatalakeStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDatalakeStatusPublisher(SecurityLakeAsyncClient client, GetDatalakeStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDatalakeStatusPublisher(SecurityLakeAsyncClient client, GetDatalakeStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDatalakeStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDatalakeStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountSources> accountSourcesList() {
        Function<GetDatalakeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountSourcesList() != null) {
                return response.accountSourcesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDatalakeStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDatalakeStatusResponseFetcher
    implements AsyncPageFetcher<GetDatalakeStatusResponse> {
        private GetDatalakeStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetDatalakeStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDatalakeStatusResponse> nextPage(GetDatalakeStatusResponse previousPage) {
            if (previousPage == null) {
                return GetDatalakeStatusPublisher.this.client.getDatalakeStatus(GetDatalakeStatusPublisher.this.firstRequest);
            }
            return GetDatalakeStatusPublisher.this.client.getDatalakeStatus((GetDatalakeStatusRequest)((Object)GetDatalakeStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

