/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securitylake.model.AwsLogSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceType> {
    private static final SdkField<String> AWS_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsSourceType").getter(SourceType.getter(SourceType::awsSourceTypeAsString)).setter(SourceType.setter(Builder::awsSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSourceType").build()}).build();
    private static final SdkField<String> CUSTOM_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customSourceType").getter(SourceType.getter(SourceType::customSourceType)).setter(SourceType.setter(Builder::customSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customSourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SOURCE_TYPE_FIELD, CUSTOM_SOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsSourceType;
    private final String customSourceType;
    private final Type type;

    private SourceType(BuilderImpl builder) {
        this.awsSourceType = builder.awsSourceType;
        this.customSourceType = builder.customSourceType;
        this.type = builder.type;
    }

    public final AwsLogSourceType awsSourceType() {
        return AwsLogSourceType.fromValue(this.awsSourceType);
    }

    public final String awsSourceTypeAsString() {
        return this.awsSourceType;
    }

    public final String customSourceType() {
        return this.customSourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceType)) {
            return false;
        }
        SourceType other = (SourceType)obj;
        return Objects.equals(this.awsSourceTypeAsString(), other.awsSourceTypeAsString()) && Objects.equals(this.customSourceType(), other.customSourceType());
    }

    public final String toString() {
        return ToString.builder((String)"SourceType").add("AwsSourceType", (Object)this.awsSourceTypeAsString()).add("CustomSourceType", (Object)this.customSourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsSourceType": {
                return Optional.ofNullable(clazz.cast(this.awsSourceTypeAsString()));
            }
            case "customSourceType": {
                return Optional.ofNullable(clazz.cast(this.customSourceType()));
            }
        }
        return Optional.empty();
    }

    public static SourceType fromAwsSourceType(String awsSourceType) {
        return (SourceType)SourceType.builder().awsSourceType(awsSourceType).build();
    }

    public static SourceType fromAwsSourceType(AwsLogSourceType awsSourceType) {
        return (SourceType)SourceType.builder().awsSourceType(awsSourceType).build();
    }

    public static SourceType fromCustomSourceType(String customSourceType) {
        return (SourceType)SourceType.builder().customSourceType(customSourceType).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceType, T> g) {
        return obj -> g.apply((SourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AWS_SOURCE_TYPE,
        CUSTOM_SOURCE_TYPE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String awsSourceType;
        private String customSourceType;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SourceType model) {
            this.awsSourceType(model.awsSourceType);
            this.customSourceType(model.customSourceType);
        }

        public final String getAwsSourceType() {
            return this.awsSourceType;
        }

        public final void setAwsSourceType(String awsSourceType) {
            String oldValue = this.awsSourceType;
            this.awsSourceType = awsSourceType;
            this.handleUnionValueChange(Type.AWS_SOURCE_TYPE, oldValue, this.awsSourceType);
        }

        @Override
        public final Builder awsSourceType(String awsSourceType) {
            String oldValue = this.awsSourceType;
            this.awsSourceType = awsSourceType;
            this.handleUnionValueChange(Type.AWS_SOURCE_TYPE, oldValue, this.awsSourceType);
            return this;
        }

        @Override
        public final Builder awsSourceType(AwsLogSourceType awsSourceType) {
            this.awsSourceType(awsSourceType == null ? null : awsSourceType.toString());
            return this;
        }

        public final String getCustomSourceType() {
            return this.customSourceType;
        }

        public final void setCustomSourceType(String customSourceType) {
            String oldValue = this.customSourceType;
            this.customSourceType = customSourceType;
            this.handleUnionValueChange(Type.CUSTOM_SOURCE_TYPE, oldValue, this.customSourceType);
        }

        @Override
        public final Builder customSourceType(String customSourceType) {
            String oldValue = this.customSourceType;
            this.customSourceType = customSourceType;
            this.handleUnionValueChange(Type.CUSTOM_SOURCE_TYPE, oldValue, this.customSourceType);
            return this;
        }

        public SourceType build() {
            return new SourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceType> {
        public Builder awsSourceType(String var1);

        public Builder awsSourceType(AwsLogSourceType var1);

        public Builder customSourceType(String var1);
    }
}

