/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccessType;
import software.amazon.awssdk.services.securitylake.model.AccessTypeListCopier;
import software.amazon.awssdk.services.securitylake.model.EndpointProtocol;
import software.amazon.awssdk.services.securitylake.model.SourceType;
import software.amazon.awssdk.services.securitylake.model.SourceTypeListCopier;
import software.amazon.awssdk.services.securitylake.model.SubscriptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscriberResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscriberResource> {
    private static final SdkField<List<String>> ACCESS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessTypes").getter(SubscriberResource.getter(SubscriberResource::accessTypesAsStrings)).setter(SubscriberResource.setter(Builder::accessTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(SubscriberResource.getter(SubscriberResource::accountId)).setter(SubscriberResource.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SubscriberResource.getter(SubscriberResource::createdAt)).setter(SubscriberResource.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(SubscriberResource.getter(SubscriberResource::externalId)).setter(SubscriberResource.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(SubscriberResource.getter(SubscriberResource::roleArn)).setter(SubscriberResource.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketArn").getter(SubscriberResource.getter(SubscriberResource::s3BucketArn)).setter(SubscriberResource.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()}).build();
    private static final SdkField<String> SNS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsArn").getter(SubscriberResource.getter(SubscriberResource::snsArn)).setter(SubscriberResource.setter(Builder::snsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsArn").build()}).build();
    private static final SdkField<List<SourceType>> SOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceTypes").getter(SubscriberResource.getter(SubscriberResource::sourceTypes)).setter(SubscriberResource.setter(Builder::sourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberDescription").getter(SubscriberResource.getter(SubscriberResource::subscriberDescription)).setter(SubscriberResource.setter(Builder::subscriberDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build()}).build();
    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberName").getter(SubscriberResource.getter(SubscriberResource::subscriberName)).setter(SubscriberResource.setter(Builder::subscriberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionEndpoint").getter(SubscriberResource.getter(SubscriberResource::subscriptionEndpoint)).setter(SubscriberResource.setter(Builder::subscriptionEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionEndpoint").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionId").getter(SubscriberResource.getter(SubscriberResource::subscriptionId)).setter(SubscriberResource.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionId").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionProtocol").getter(SubscriberResource.getter(SubscriberResource::subscriptionProtocolAsString)).setter(SubscriberResource.setter(Builder::subscriptionProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionProtocol").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionStatus").getter(SubscriberResource.getter(SubscriberResource::subscriptionStatusAsString)).setter(SubscriberResource.setter(Builder::subscriptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionStatus").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(SubscriberResource.getter(SubscriberResource::updatedAt)).setter(SubscriberResource.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPES_FIELD, ACCOUNT_ID_FIELD, CREATED_AT_FIELD, EXTERNAL_ID_FIELD, ROLE_ARN_FIELD, S3_BUCKET_ARN_FIELD, SNS_ARN_FIELD, SOURCE_TYPES_FIELD, SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_NAME_FIELD, SUBSCRIPTION_ENDPOINT_FIELD, SUBSCRIPTION_ID_FIELD, SUBSCRIPTION_PROTOCOL_FIELD, SUBSCRIPTION_STATUS_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> accessTypes;
    private final String accountId;
    private final Instant createdAt;
    private final String externalId;
    private final String roleArn;
    private final String s3BucketArn;
    private final String snsArn;
    private final List<SourceType> sourceTypes;
    private final String subscriberDescription;
    private final String subscriberName;
    private final String subscriptionEndpoint;
    private final String subscriptionId;
    private final String subscriptionProtocol;
    private final String subscriptionStatus;
    private final Instant updatedAt;

    private SubscriberResource(BuilderImpl builder) {
        this.accessTypes = builder.accessTypes;
        this.accountId = builder.accountId;
        this.createdAt = builder.createdAt;
        this.externalId = builder.externalId;
        this.roleArn = builder.roleArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.snsArn = builder.snsArn;
        this.sourceTypes = builder.sourceTypes;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberName = builder.subscriberName;
        this.subscriptionEndpoint = builder.subscriptionEndpoint;
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionProtocol = builder.subscriptionProtocol;
        this.subscriptionStatus = builder.subscriptionStatus;
        this.updatedAt = builder.updatedAt;
    }

    public final List<AccessType> accessTypes() {
        return AccessTypeListCopier.copyStringToEnum(this.accessTypes);
    }

    public final boolean hasAccessTypes() {
        return this.accessTypes != null && !(this.accessTypes instanceof SdkAutoConstructList);
    }

    public final List<String> accessTypesAsStrings() {
        return this.accessTypes;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final String snsArn() {
        return this.snsArn;
    }

    public final boolean hasSourceTypes() {
        return this.sourceTypes != null && !(this.sourceTypes instanceof SdkAutoConstructList);
    }

    public final List<SourceType> sourceTypes() {
        return this.sourceTypes;
    }

    public final String subscriberDescription() {
        return this.subscriberDescription;
    }

    public final String subscriberName() {
        return this.subscriberName;
    }

    public final String subscriptionEndpoint() {
        return this.subscriptionEndpoint;
    }

    public final String subscriptionId() {
        return this.subscriptionId;
    }

    public final EndpointProtocol subscriptionProtocol() {
        return EndpointProtocol.fromValue(this.subscriptionProtocol);
    }

    public final String subscriptionProtocolAsString() {
        return this.subscriptionProtocol;
    }

    public final SubscriptionStatus subscriptionStatus() {
        return SubscriptionStatus.fromValue(this.subscriptionStatus);
    }

    public final String subscriptionStatusAsString() {
        return this.subscriptionStatus;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessTypes() ? this.accessTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceTypes() ? this.sourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriberResource)) {
            return false;
        }
        SubscriberResource other = (SubscriberResource)obj;
        return this.hasAccessTypes() == other.hasAccessTypes() && Objects.equals(this.accessTypesAsStrings(), other.accessTypesAsStrings()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.snsArn(), other.snsArn()) && this.hasSourceTypes() == other.hasSourceTypes() && Objects.equals(this.sourceTypes(), other.sourceTypes()) && Objects.equals(this.subscriberDescription(), other.subscriberDescription()) && Objects.equals(this.subscriberName(), other.subscriberName()) && Objects.equals(this.subscriptionEndpoint(), other.subscriptionEndpoint()) && Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.subscriptionProtocolAsString(), other.subscriptionProtocolAsString()) && Objects.equals(this.subscriptionStatusAsString(), other.subscriptionStatusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"SubscriberResource").add("AccessTypes", this.hasAccessTypes() ? this.accessTypesAsStrings() : null).add("AccountId", (Object)this.accountId()).add("CreatedAt", (Object)this.createdAt()).add("ExternalId", (Object)this.externalId()).add("RoleArn", (Object)this.roleArn()).add("S3BucketArn", (Object)this.s3BucketArn()).add("SnsArn", (Object)this.snsArn()).add("SourceTypes", this.hasSourceTypes() ? this.sourceTypes() : null).add("SubscriberDescription", (Object)this.subscriberDescription()).add("SubscriberName", (Object)this.subscriberName()).add("SubscriptionEndpoint", (Object)this.subscriptionEndpoint()).add("SubscriptionId", (Object)this.subscriptionId()).add("SubscriptionProtocol", (Object)this.subscriptionProtocolAsString()).add("SubscriptionStatus", (Object)this.subscriptionStatusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessTypes": {
                return Optional.ofNullable(clazz.cast(this.accessTypesAsStrings()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "s3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "snsArn": {
                return Optional.ofNullable(clazz.cast(this.snsArn()));
            }
            case "sourceTypes": {
                return Optional.ofNullable(clazz.cast(this.sourceTypes()));
            }
            case "subscriberDescription": {
                return Optional.ofNullable(clazz.cast(this.subscriberDescription()));
            }
            case "subscriberName": {
                return Optional.ofNullable(clazz.cast(this.subscriberName()));
            }
            case "subscriptionEndpoint": {
                return Optional.ofNullable(clazz.cast(this.subscriptionEndpoint()));
            }
            case "subscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
            case "subscriptionProtocol": {
                return Optional.ofNullable(clazz.cast(this.subscriptionProtocolAsString()));
            }
            case "subscriptionStatus": {
                return Optional.ofNullable(clazz.cast(this.subscriptionStatusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscriberResource, T> g) {
        return obj -> g.apply((SubscriberResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accessTypes = DefaultSdkAutoConstructList.getInstance();
        private String accountId;
        private Instant createdAt;
        private String externalId;
        private String roleArn;
        private String s3BucketArn;
        private String snsArn;
        private List<SourceType> sourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String subscriberDescription;
        private String subscriberName;
        private String subscriptionEndpoint;
        private String subscriptionId;
        private String subscriptionProtocol;
        private String subscriptionStatus;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriberResource model) {
            this.accessTypesWithStrings(model.accessTypes);
            this.accountId(model.accountId);
            this.createdAt(model.createdAt);
            this.externalId(model.externalId);
            this.roleArn(model.roleArn);
            this.s3BucketArn(model.s3BucketArn);
            this.snsArn(model.snsArn);
            this.sourceTypes(model.sourceTypes);
            this.subscriberDescription(model.subscriberDescription);
            this.subscriberName(model.subscriberName);
            this.subscriptionEndpoint(model.subscriptionEndpoint);
            this.subscriptionId(model.subscriptionId);
            this.subscriptionProtocol(model.subscriptionProtocol);
            this.subscriptionStatus(model.subscriptionStatus);
            this.updatedAt(model.updatedAt);
        }

        public final Collection<String> getAccessTypes() {
            if (this.accessTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessTypes;
        }

        public final void setAccessTypes(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
        }

        @Override
        public final Builder accessTypesWithStrings(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypesWithStrings(String ... accessTypes) {
            this.accessTypesWithStrings(Arrays.asList(accessTypes));
            return this;
        }

        @Override
        public final Builder accessTypes(Collection<AccessType> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copyEnumToString(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypes(AccessType ... accessTypes) {
            this.accessTypes(Arrays.asList(accessTypes));
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getSnsArn() {
            return this.snsArn;
        }

        public final void setSnsArn(String snsArn) {
            this.snsArn = snsArn;
        }

        @Override
        public final Builder snsArn(String snsArn) {
            this.snsArn = snsArn;
            return this;
        }

        public final List<SourceType.Builder> getSourceTypes() {
            List<SourceType.Builder> result = SourceTypeListCopier.copyToBuilder(this.sourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceTypes(Collection<SourceType.BuilderImpl> sourceTypes) {
            this.sourceTypes = SourceTypeListCopier.copyFromBuilder(sourceTypes);
        }

        @Override
        public final Builder sourceTypes(Collection<SourceType> sourceTypes) {
            this.sourceTypes = SourceTypeListCopier.copy(sourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(SourceType ... sourceTypes) {
            this.sourceTypes(Arrays.asList(sourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(Consumer<SourceType.Builder> ... sourceTypes) {
            this.sourceTypes(Stream.of(sourceTypes).map(c -> (SourceType)((SourceType.Builder)SourceType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberDescription() {
            return this.subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final String getSubscriberName() {
            return this.subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        public final String getSubscriptionEndpoint() {
            return this.subscriptionEndpoint;
        }

        public final void setSubscriptionEndpoint(String subscriptionEndpoint) {
            this.subscriptionEndpoint = subscriptionEndpoint;
        }

        @Override
        public final Builder subscriptionEndpoint(String subscriptionEndpoint) {
            this.subscriptionEndpoint = subscriptionEndpoint;
            return this;
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionProtocol() {
            return this.subscriptionProtocol;
        }

        public final void setSubscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
        }

        @Override
        public final Builder subscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
            return this;
        }

        @Override
        public final Builder subscriptionProtocol(EndpointProtocol subscriptionProtocol) {
            this.subscriptionProtocol(subscriptionProtocol == null ? null : subscriptionProtocol.toString());
            return this;
        }

        public final String getSubscriptionStatus() {
            return this.subscriptionStatus;
        }

        public final void setSubscriptionStatus(String subscriptionStatus) {
            this.subscriptionStatus = subscriptionStatus;
        }

        @Override
        public final Builder subscriptionStatus(String subscriptionStatus) {
            this.subscriptionStatus = subscriptionStatus;
            return this;
        }

        @Override
        public final Builder subscriptionStatus(SubscriptionStatus subscriptionStatus) {
            this.subscriptionStatus(subscriptionStatus == null ? null : subscriptionStatus.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SubscriberResource build() {
            return new SubscriberResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscriberResource> {
        public Builder accessTypesWithStrings(Collection<String> var1);

        public Builder accessTypesWithStrings(String ... var1);

        public Builder accessTypes(Collection<AccessType> var1);

        public Builder accessTypes(AccessType ... var1);

        public Builder accountId(String var1);

        public Builder createdAt(Instant var1);

        public Builder externalId(String var1);

        public Builder roleArn(String var1);

        public Builder s3BucketArn(String var1);

        public Builder snsArn(String var1);

        public Builder sourceTypes(Collection<SourceType> var1);

        public Builder sourceTypes(SourceType ... var1);

        public Builder sourceTypes(Consumer<SourceType.Builder> ... var1);

        public Builder subscriberDescription(String var1);

        public Builder subscriberName(String var1);

        public Builder subscriptionEndpoint(String var1);

        public Builder subscriptionId(String var1);

        public Builder subscriptionProtocol(String var1);

        public Builder subscriptionProtocol(EndpointProtocol var1);

        public Builder subscriptionStatus(String var1);

        public Builder subscriptionStatus(SubscriptionStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

