/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.AwsRegion;
import software.amazon.awssdk.services.securityir.model.CustomerType;
import software.amazon.awssdk.services.securityir.model.IncidentResponder;
import software.amazon.awssdk.services.securityir.model.IncidentResponseTeamCopier;
import software.amazon.awssdk.services.securityir.model.MembershipAccountsConfigurations;
import software.amazon.awssdk.services.securityir.model.MembershipStatus;
import software.amazon.awssdk.services.securityir.model.OptInFeature;
import software.amazon.awssdk.services.securityir.model.OptInFeaturesCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMembershipResponse
extends SecurityIrResponse
implements ToCopyableBuilder<Builder, GetMembershipResponse> {
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(GetMembershipResponse.getter(GetMembershipResponse::membershipId)).setter(GetMembershipResponse.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(GetMembershipResponse.getter(GetMembershipResponse::accountId)).setter(GetMembershipResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(GetMembershipResponse.getter(GetMembershipResponse::regionAsString)).setter(GetMembershipResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> MEMBERSHIP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipName").getter(GetMembershipResponse.getter(GetMembershipResponse::membershipName)).setter(GetMembershipResponse.setter(Builder::membershipName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipName").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(GetMembershipResponse.getter(GetMembershipResponse::membershipArn)).setter(GetMembershipResponse.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipStatus").getter(GetMembershipResponse.getter(GetMembershipResponse::membershipStatusAsString)).setter(GetMembershipResponse.setter(Builder::membershipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()}).build();
    private static final SdkField<Instant> MEMBERSHIP_ACTIVATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("membershipActivationTimestamp").getter(GetMembershipResponse.getter(GetMembershipResponse::membershipActivationTimestamp)).setter(GetMembershipResponse.setter(Builder::membershipActivationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipActivationTimestamp").build()}).build();
    private static final SdkField<Instant> MEMBERSHIP_DEACTIVATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("membershipDeactivationTimestamp").getter(GetMembershipResponse.getter(GetMembershipResponse::membershipDeactivationTimestamp)).setter(GetMembershipResponse.setter(Builder::membershipDeactivationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipDeactivationTimestamp").build()}).build();
    private static final SdkField<String> CUSTOMER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerType").getter(GetMembershipResponse.getter(GetMembershipResponse::customerTypeAsString)).setter(GetMembershipResponse.setter(Builder::customerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerType").build()}).build();
    private static final SdkField<Long> NUMBER_OF_ACCOUNTS_COVERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfAccountsCovered").getter(GetMembershipResponse.getter(GetMembershipResponse::numberOfAccountsCovered)).setter(GetMembershipResponse.setter(Builder::numberOfAccountsCovered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAccountsCovered").build()}).build();
    private static final SdkField<List<IncidentResponder>> INCIDENT_RESPONSE_TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("incidentResponseTeam").getter(GetMembershipResponse.getter(GetMembershipResponse::incidentResponseTeam)).setter(GetMembershipResponse.setter(Builder::incidentResponseTeam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentResponseTeam").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncidentResponder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OptInFeature>> OPT_IN_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("optInFeatures").getter(GetMembershipResponse.getter(GetMembershipResponse::optInFeatures)).setter(GetMembershipResponse.setter(Builder::optInFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptInFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MembershipAccountsConfigurations> MEMBERSHIP_ACCOUNTS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("membershipAccountsConfigurations").getter(GetMembershipResponse.getter(GetMembershipResponse::membershipAccountsConfigurations)).setter(GetMembershipResponse.setter(Builder::membershipAccountsConfigurations)).constructor(MembershipAccountsConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipAccountsConfigurations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_ID_FIELD, ACCOUNT_ID_FIELD, REGION_FIELD, MEMBERSHIP_NAME_FIELD, MEMBERSHIP_ARN_FIELD, MEMBERSHIP_STATUS_FIELD, MEMBERSHIP_ACTIVATION_TIMESTAMP_FIELD, MEMBERSHIP_DEACTIVATION_TIMESTAMP_FIELD, CUSTOMER_TYPE_FIELD, NUMBER_OF_ACCOUNTS_COVERED_FIELD, INCIDENT_RESPONSE_TEAM_FIELD, OPT_IN_FEATURES_FIELD, MEMBERSHIP_ACCOUNTS_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMembershipResponse.memberNameToFieldInitializer();
    private final String membershipId;
    private final String accountId;
    private final String region;
    private final String membershipName;
    private final String membershipArn;
    private final String membershipStatus;
    private final Instant membershipActivationTimestamp;
    private final Instant membershipDeactivationTimestamp;
    private final String customerType;
    private final Long numberOfAccountsCovered;
    private final List<IncidentResponder> incidentResponseTeam;
    private final List<OptInFeature> optInFeatures;
    private final MembershipAccountsConfigurations membershipAccountsConfigurations;

    private GetMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.membershipId = builder.membershipId;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.membershipName = builder.membershipName;
        this.membershipArn = builder.membershipArn;
        this.membershipStatus = builder.membershipStatus;
        this.membershipActivationTimestamp = builder.membershipActivationTimestamp;
        this.membershipDeactivationTimestamp = builder.membershipDeactivationTimestamp;
        this.customerType = builder.customerType;
        this.numberOfAccountsCovered = builder.numberOfAccountsCovered;
        this.incidentResponseTeam = builder.incidentResponseTeam;
        this.optInFeatures = builder.optInFeatures;
        this.membershipAccountsConfigurations = builder.membershipAccountsConfigurations;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AwsRegion region() {
        return AwsRegion.fromValue(this.region);
    }

    public final String regionAsString() {
        return this.region;
    }

    public final String membershipName() {
        return this.membershipName;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final MembershipStatus membershipStatus() {
        return MembershipStatus.fromValue(this.membershipStatus);
    }

    public final String membershipStatusAsString() {
        return this.membershipStatus;
    }

    public final Instant membershipActivationTimestamp() {
        return this.membershipActivationTimestamp;
    }

    public final Instant membershipDeactivationTimestamp() {
        return this.membershipDeactivationTimestamp;
    }

    public final CustomerType customerType() {
        return CustomerType.fromValue(this.customerType);
    }

    public final String customerTypeAsString() {
        return this.customerType;
    }

    public final Long numberOfAccountsCovered() {
        return this.numberOfAccountsCovered;
    }

    public final boolean hasIncidentResponseTeam() {
        return this.incidentResponseTeam != null && !(this.incidentResponseTeam instanceof SdkAutoConstructList);
    }

    public final List<IncidentResponder> incidentResponseTeam() {
        return this.incidentResponseTeam;
    }

    public final boolean hasOptInFeatures() {
        return this.optInFeatures != null && !(this.optInFeatures instanceof SdkAutoConstructList);
    }

    public final List<OptInFeature> optInFeatures() {
        return this.optInFeatures;
    }

    public final MembershipAccountsConfigurations membershipAccountsConfigurations() {
        return this.membershipAccountsConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipName());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipActivationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipDeactivationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAccountsCovered());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidentResponseTeam() ? this.incidentResponseTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptInFeatures() ? this.optInFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipAccountsConfigurations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMembershipResponse)) {
            return false;
        }
        GetMembershipResponse other = (GetMembershipResponse)((Object)obj);
        return Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.regionAsString(), other.regionAsString()) && Objects.equals(this.membershipName(), other.membershipName()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.membershipStatusAsString(), other.membershipStatusAsString()) && Objects.equals(this.membershipActivationTimestamp(), other.membershipActivationTimestamp()) && Objects.equals(this.membershipDeactivationTimestamp(), other.membershipDeactivationTimestamp()) && Objects.equals(this.customerTypeAsString(), other.customerTypeAsString()) && Objects.equals(this.numberOfAccountsCovered(), other.numberOfAccountsCovered()) && this.hasIncidentResponseTeam() == other.hasIncidentResponseTeam() && Objects.equals(this.incidentResponseTeam(), other.incidentResponseTeam()) && this.hasOptInFeatures() == other.hasOptInFeatures() && Objects.equals(this.optInFeatures(), other.optInFeatures()) && Objects.equals(this.membershipAccountsConfigurations(), other.membershipAccountsConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"GetMembershipResponse").add("MembershipId", (Object)this.membershipId()).add("AccountId", (Object)this.accountId()).add("Region", (Object)this.regionAsString()).add("MembershipName", (Object)(this.membershipName() == null ? null : "*** Sensitive Data Redacted ***")).add("MembershipArn", (Object)this.membershipArn()).add("MembershipStatus", (Object)this.membershipStatusAsString()).add("MembershipActivationTimestamp", (Object)this.membershipActivationTimestamp()).add("MembershipDeactivationTimestamp", (Object)this.membershipDeactivationTimestamp()).add("CustomerType", (Object)this.customerTypeAsString()).add("NumberOfAccountsCovered", (Object)this.numberOfAccountsCovered()).add("IncidentResponseTeam", this.hasIncidentResponseTeam() ? this.incidentResponseTeam() : null).add("OptInFeatures", this.hasOptInFeatures() ? this.optInFeatures() : null).add("MembershipAccountsConfigurations", (Object)this.membershipAccountsConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.regionAsString()));
            }
            case "membershipName": {
                return Optional.ofNullable(clazz.cast(this.membershipName()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "membershipStatus": {
                return Optional.ofNullable(clazz.cast(this.membershipStatusAsString()));
            }
            case "membershipActivationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.membershipActivationTimestamp()));
            }
            case "membershipDeactivationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.membershipDeactivationTimestamp()));
            }
            case "customerType": {
                return Optional.ofNullable(clazz.cast(this.customerTypeAsString()));
            }
            case "numberOfAccountsCovered": {
                return Optional.ofNullable(clazz.cast(this.numberOfAccountsCovered()));
            }
            case "incidentResponseTeam": {
                return Optional.ofNullable(clazz.cast(this.incidentResponseTeam()));
            }
            case "optInFeatures": {
                return Optional.ofNullable(clazz.cast(this.optInFeatures()));
            }
            case "membershipAccountsConfigurations": {
                return Optional.ofNullable(clazz.cast(this.membershipAccountsConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("region", REGION_FIELD);
        map.put("membershipName", MEMBERSHIP_NAME_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("membershipStatus", MEMBERSHIP_STATUS_FIELD);
        map.put("membershipActivationTimestamp", MEMBERSHIP_ACTIVATION_TIMESTAMP_FIELD);
        map.put("membershipDeactivationTimestamp", MEMBERSHIP_DEACTIVATION_TIMESTAMP_FIELD);
        map.put("customerType", CUSTOMER_TYPE_FIELD);
        map.put("numberOfAccountsCovered", NUMBER_OF_ACCOUNTS_COVERED_FIELD);
        map.put("incidentResponseTeam", INCIDENT_RESPONSE_TEAM_FIELD);
        map.put("optInFeatures", OPT_IN_FEATURES_FIELD);
        map.put("membershipAccountsConfigurations", MEMBERSHIP_ACCOUNTS_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMembershipResponse, T> g) {
        return obj -> g.apply((GetMembershipResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrResponse.BuilderImpl
    implements Builder {
        private String membershipId;
        private String accountId;
        private String region;
        private String membershipName;
        private String membershipArn;
        private String membershipStatus;
        private Instant membershipActivationTimestamp;
        private Instant membershipDeactivationTimestamp;
        private String customerType;
        private Long numberOfAccountsCovered;
        private List<IncidentResponder> incidentResponseTeam = DefaultSdkAutoConstructList.getInstance();
        private List<OptInFeature> optInFeatures = DefaultSdkAutoConstructList.getInstance();
        private MembershipAccountsConfigurations membershipAccountsConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMembershipResponse model) {
            super(model);
            this.membershipId(model.membershipId);
            this.accountId(model.accountId);
            this.region(model.region);
            this.membershipName(model.membershipName);
            this.membershipArn(model.membershipArn);
            this.membershipStatus(model.membershipStatus);
            this.membershipActivationTimestamp(model.membershipActivationTimestamp);
            this.membershipDeactivationTimestamp(model.membershipDeactivationTimestamp);
            this.customerType(model.customerType);
            this.numberOfAccountsCovered(model.numberOfAccountsCovered);
            this.incidentResponseTeam(model.incidentResponseTeam);
            this.optInFeatures(model.optInFeatures);
            this.membershipAccountsConfigurations(model.membershipAccountsConfigurations);
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(AwsRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final String getMembershipName() {
            return this.membershipName;
        }

        public final void setMembershipName(String membershipName) {
            this.membershipName = membershipName;
        }

        @Override
        public final Builder membershipName(String membershipName) {
            this.membershipName = membershipName;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getMembershipStatus() {
            return this.membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(MembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        public final Instant getMembershipActivationTimestamp() {
            return this.membershipActivationTimestamp;
        }

        public final void setMembershipActivationTimestamp(Instant membershipActivationTimestamp) {
            this.membershipActivationTimestamp = membershipActivationTimestamp;
        }

        @Override
        public final Builder membershipActivationTimestamp(Instant membershipActivationTimestamp) {
            this.membershipActivationTimestamp = membershipActivationTimestamp;
            return this;
        }

        public final Instant getMembershipDeactivationTimestamp() {
            return this.membershipDeactivationTimestamp;
        }

        public final void setMembershipDeactivationTimestamp(Instant membershipDeactivationTimestamp) {
            this.membershipDeactivationTimestamp = membershipDeactivationTimestamp;
        }

        @Override
        public final Builder membershipDeactivationTimestamp(Instant membershipDeactivationTimestamp) {
            this.membershipDeactivationTimestamp = membershipDeactivationTimestamp;
            return this;
        }

        public final String getCustomerType() {
            return this.customerType;
        }

        public final void setCustomerType(String customerType) {
            this.customerType = customerType;
        }

        @Override
        public final Builder customerType(String customerType) {
            this.customerType = customerType;
            return this;
        }

        @Override
        public final Builder customerType(CustomerType customerType) {
            this.customerType(customerType == null ? null : customerType.toString());
            return this;
        }

        public final Long getNumberOfAccountsCovered() {
            return this.numberOfAccountsCovered;
        }

        public final void setNumberOfAccountsCovered(Long numberOfAccountsCovered) {
            this.numberOfAccountsCovered = numberOfAccountsCovered;
        }

        @Override
        public final Builder numberOfAccountsCovered(Long numberOfAccountsCovered) {
            this.numberOfAccountsCovered = numberOfAccountsCovered;
            return this;
        }

        public final List<IncidentResponder.Builder> getIncidentResponseTeam() {
            List<IncidentResponder.Builder> result = IncidentResponseTeamCopier.copyToBuilder(this.incidentResponseTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidentResponseTeam(Collection<IncidentResponder.BuilderImpl> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copyFromBuilder(incidentResponseTeam);
        }

        @Override
        public final Builder incidentResponseTeam(Collection<IncidentResponder> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copy(incidentResponseTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(IncidentResponder ... incidentResponseTeam) {
            this.incidentResponseTeam(Arrays.asList(incidentResponseTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(Consumer<IncidentResponder.Builder> ... incidentResponseTeam) {
            this.incidentResponseTeam(Stream.of(incidentResponseTeam).map(c -> (IncidentResponder)((IncidentResponder.Builder)IncidentResponder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OptInFeature.Builder> getOptInFeatures() {
            List<OptInFeature.Builder> result = OptInFeaturesCopier.copyToBuilder(this.optInFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptInFeatures(Collection<OptInFeature.BuilderImpl> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copyFromBuilder(optInFeatures);
        }

        @Override
        public final Builder optInFeatures(Collection<OptInFeature> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copy(optInFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(OptInFeature ... optInFeatures) {
            this.optInFeatures(Arrays.asList(optInFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(Consumer<OptInFeature.Builder> ... optInFeatures) {
            this.optInFeatures(Stream.of(optInFeatures).map(c -> (OptInFeature)((OptInFeature.Builder)OptInFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MembershipAccountsConfigurations.Builder getMembershipAccountsConfigurations() {
            return this.membershipAccountsConfigurations != null ? this.membershipAccountsConfigurations.toBuilder() : null;
        }

        public final void setMembershipAccountsConfigurations(MembershipAccountsConfigurations.BuilderImpl membershipAccountsConfigurations) {
            this.membershipAccountsConfigurations = membershipAccountsConfigurations != null ? membershipAccountsConfigurations.build() : null;
        }

        @Override
        public final Builder membershipAccountsConfigurations(MembershipAccountsConfigurations membershipAccountsConfigurations) {
            this.membershipAccountsConfigurations = membershipAccountsConfigurations;
            return this;
        }

        @Override
        public GetMembershipResponse build() {
            return new GetMembershipResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityIrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMembershipResponse> {
        public Builder membershipId(String var1);

        public Builder accountId(String var1);

        public Builder region(String var1);

        public Builder region(AwsRegion var1);

        public Builder membershipName(String var1);

        public Builder membershipArn(String var1);

        public Builder membershipStatus(String var1);

        public Builder membershipStatus(MembershipStatus var1);

        public Builder membershipActivationTimestamp(Instant var1);

        public Builder membershipDeactivationTimestamp(Instant var1);

        public Builder customerType(String var1);

        public Builder customerType(CustomerType var1);

        public Builder numberOfAccountsCovered(Long var1);

        public Builder incidentResponseTeam(Collection<IncidentResponder> var1);

        public Builder incidentResponseTeam(IncidentResponder ... var1);

        public Builder incidentResponseTeam(Consumer<IncidentResponder.Builder> ... var1);

        public Builder optInFeatures(Collection<OptInFeature> var1);

        public Builder optInFeatures(OptInFeature ... var1);

        public Builder optInFeatures(Consumer<OptInFeature.Builder> ... var1);

        public Builder membershipAccountsConfigurations(MembershipAccountsConfigurations var1);

        default public Builder membershipAccountsConfigurations(Consumer<MembershipAccountsConfigurations.Builder> membershipAccountsConfigurations) {
            return this.membershipAccountsConfigurations((MembershipAccountsConfigurations)((MembershipAccountsConfigurations.Builder)MembershipAccountsConfigurations.builder().applyMutation(membershipAccountsConfigurations)).build());
        }
    }
}

