/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvestigationsResponse extends SecurityIrResponse implements
        ToCopyableBuilder<ListInvestigationsResponse.Builder, ListInvestigationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInvestigationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<InvestigationAction>> INVESTIGATION_ACTIONS_FIELD = SdkField
            .<List<InvestigationAction>> builder(MarshallingType.LIST)
            .memberName("investigationActions")
            .getter(getter(ListInvestigationsResponse::investigationActions))
            .setter(setter(Builder::investigationActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("investigationActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvestigationAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvestigationAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            INVESTIGATION_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<InvestigationAction> investigationActions;

    private ListInvestigationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.investigationActions = builder.investigationActions;
    }

    /**
     * <p>
     * Investigation performed by an agent for a security incident for next Token
     * </p>
     * 
     * @return Investigation performed by an agent for a security incident for next Token
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvestigationActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvestigationActions() {
        return investigationActions != null && !(investigationActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Investigation performed by an agent for a security incid…Unique identifier for the specific investigation&gt;
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvestigationActions} method.
     * </p>
     * 
     * @return Investigation performed by an agent for a security incid…Unique identifier for the specific
     *         investigation&gt;
     */
    public final List<InvestigationAction> investigationActions() {
        return investigationActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInvestigationActions() ? investigationActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvestigationsResponse)) {
            return false;
        }
        ListInvestigationsResponse other = (ListInvestigationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasInvestigationActions() == other.hasInvestigationActions()
                && Objects.equals(investigationActions(), other.investigationActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvestigationsResponse").add("NextToken", nextToken())
                .add("InvestigationActions", hasInvestigationActions() ? investigationActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "investigationActions":
            return Optional.ofNullable(clazz.cast(investigationActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("investigationActions", INVESTIGATION_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvestigationsResponse, T> g) {
        return obj -> g.apply((ListInvestigationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityIrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInvestigationsResponse> {
        /**
         * <p>
         * Investigation performed by an agent for a security incident for next Token
         * </p>
         * 
         * @param nextToken
         *        Investigation performed by an agent for a security incident for next Token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Investigation performed by an agent for a security incid…Unique identifier for the specific investigation&gt;
         * </p>
         * 
         * @param investigationActions
         *        Investigation performed by an agent for a security incid…Unique identifier for the specific
         *        investigation&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationActions(Collection<InvestigationAction> investigationActions);

        /**
         * <p>
         * Investigation performed by an agent for a security incid…Unique identifier for the specific investigation&gt;
         * </p>
         * 
         * @param investigationActions
         *        Investigation performed by an agent for a security incid…Unique identifier for the specific
         *        investigation&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationActions(InvestigationAction... investigationActions);

        /**
         * <p>
         * Investigation performed by an agent for a security incid…Unique identifier for the specific investigation&gt;
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.InvestigationAction.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityir.model.InvestigationAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.InvestigationAction.Builder#build()} is called
         * immediately and its result is passed to {@link #investigationActions(List<InvestigationAction>)}.
         * 
         * @param investigationActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.InvestigationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #investigationActions(java.util.Collection<InvestigationAction>)
         */
        Builder investigationActions(Consumer<InvestigationAction.Builder>... investigationActions);
    }

    static final class BuilderImpl extends SecurityIrResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<InvestigationAction> investigationActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvestigationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            investigationActions(model.investigationActions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<InvestigationAction.Builder> getInvestigationActions() {
            List<InvestigationAction.Builder> result = InvestigationActionListCopier.copyToBuilder(this.investigationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvestigationActions(Collection<InvestigationAction.BuilderImpl> investigationActions) {
            this.investigationActions = InvestigationActionListCopier.copyFromBuilder(investigationActions);
        }

        @Override
        public final Builder investigationActions(Collection<InvestigationAction> investigationActions) {
            this.investigationActions = InvestigationActionListCopier.copy(investigationActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationActions(InvestigationAction... investigationActions) {
            investigationActions(Arrays.asList(investigationActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationActions(Consumer<InvestigationAction.Builder>... investigationActions) {
            investigationActions(Stream.of(investigationActions).map(c -> InvestigationAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListInvestigationsResponse build() {
            return new ListInvestigationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
