/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsRequest;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsResponse;
import software.amazon.awssdk.services.securityir.model.CancelMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CancelMembershipResponse;
import software.amazon.awssdk.services.securityir.model.CloseCaseRequest;
import software.amazon.awssdk.services.securityir.model.CloseCaseResponse;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.CreateCaseRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseResponse;
import software.amazon.awssdk.services.securityir.model.CreateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CreateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseResponse;
import software.amazon.awssdk.services.securityir.model.GetMembershipRequest;
import software.amazon.awssdk.services.securityir.model.GetMembershipResponse;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse;
import software.amazon.awssdk.services.securityir.model.ListCasesRequest;
import software.amazon.awssdk.services.securityir.model.ListCasesResponse;
import software.amazon.awssdk.services.securityir.model.ListCommentsRequest;
import software.amazon.awssdk.services.securityir.model.ListCommentsResponse;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse;
import software.amazon.awssdk.services.securityir.model.ListMembershipsRequest;
import software.amazon.awssdk.services.securityir.model.ListMembershipsResponse;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityir.model.SendFeedbackRequest;
import software.amazon.awssdk.services.securityir.model.SendFeedbackResponse;
import software.amazon.awssdk.services.securityir.model.TagResourceRequest;
import software.amazon.awssdk.services.securityir.model.TagResourceResponse;
import software.amazon.awssdk.services.securityir.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityir.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusResponse;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeRequest;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeResponse;
import software.amazon.awssdk.services.securityir.paginators.ListCaseEditsPublisher;
import software.amazon.awssdk.services.securityir.paginators.ListCasesPublisher;
import software.amazon.awssdk.services.securityir.paginators.ListCommentsPublisher;
import software.amazon.awssdk.services.securityir.paginators.ListInvestigationsPublisher;
import software.amazon.awssdk.services.securityir.paginators.ListMembershipsPublisher;

/**
 * Service client for accessing Security Incident Response asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * This guide documents the action and response elements for use of the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecurityIrAsyncClient extends AwsClient {
    String SERVICE_NAME = "security-ir";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "security-ir";

    /**
     * <p>
     * Provides information on whether the supplied account IDs are associated with a membership.
     * </p>
     * <note>
     * <p>
     * AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
     * <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>. Not
     * zero-prepending to 12 digits could result in errors.
     * </p>
     * </note>
     *
     * @param batchGetMemberAccountDetailsRequest
     * @return A Java Future containing the result of the BatchGetMemberAccountDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.BatchGetMemberAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/BatchGetMemberAccountDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetMemberAccountDetailsResponse> batchGetMemberAccountDetails(
            BatchGetMemberAccountDetailsRequest batchGetMemberAccountDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information on whether the supplied account IDs are associated with a membership.
     * </p>
     * <note>
     * <p>
     * AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
     * <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>. Not
     * zero-prepending to 12 digits could result in errors.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetMemberAccountDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetMemberAccountDetailsRequest#builder()}
     * </p>
     *
     * @param batchGetMemberAccountDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetMemberAccountDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.BatchGetMemberAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/BatchGetMemberAccountDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetMemberAccountDetailsResponse> batchGetMemberAccountDetails(
            Consumer<BatchGetMemberAccountDetailsRequest.Builder> batchGetMemberAccountDetailsRequest) {
        return batchGetMemberAccountDetails(BatchGetMemberAccountDetailsRequest.builder()
                .applyMutation(batchGetMemberAccountDetailsRequest).build());
    }

    /**
     * <p>
     * Cancels an existing membership.
     * </p>
     *
     * @param cancelMembershipRequest
     * @return A Java Future containing the result of the CancelMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CancelMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CancelMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelMembershipResponse> cancelMembership(CancelMembershipRequest cancelMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an existing membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link CancelMembershipRequest#builder()}
     * </p>
     *
     * @param cancelMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CancelMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CancelMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CancelMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelMembershipResponse> cancelMembership(
            Consumer<CancelMembershipRequest.Builder> cancelMembershipRequest) {
        return cancelMembership(CancelMembershipRequest.builder().applyMutation(cancelMembershipRequest).build());
    }

    /**
     * <p>
     * Closes an existing case.
     * </p>
     *
     * @param closeCaseRequest
     * @return A Java Future containing the result of the CloseCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CloseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CloseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CloseCaseResponse> closeCase(CloseCaseRequest closeCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Closes an existing case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CloseCaseRequest#builder()}
     * </p>
     *
     * @param closeCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CloseCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CloseCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CloseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CloseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CloseCaseResponse> closeCase(Consumer<CloseCaseRequest.Builder> closeCaseRequest) {
        return closeCase(CloseCaseRequest.builder().applyMutation(closeCaseRequest).build());
    }

    /**
     * <p>
     * Creates a new case.
     * </p>
     *
     * @param createCaseRequest
     * @return A Java Future containing the result of the CreateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCaseResponse> createCase(CreateCaseRequest createCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCaseRequest#builder()}
     * </p>
     *
     * @param createCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CreateCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCaseResponse> createCase(Consumer<CreateCaseRequest.Builder> createCaseRequest) {
        return createCase(CreateCaseRequest.builder().applyMutation(createCaseRequest).build());
    }

    /**
     * <p>
     * Adds a comment to an existing case.
     * </p>
     *
     * @param createCaseCommentRequest
     * @return A Java Future containing the result of the CreateCaseComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCaseCommentResponse> createCaseComment(CreateCaseCommentRequest createCaseCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a comment to an existing case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCaseCommentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCaseCommentRequest#builder()}
     * </p>
     *
     * @param createCaseCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CreateCaseCommentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCaseComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCaseCommentResponse> createCaseComment(
            Consumer<CreateCaseCommentRequest.Builder> createCaseCommentRequest) {
        return createCaseComment(CreateCaseCommentRequest.builder().applyMutation(createCaseCommentRequest).build());
    }

    /**
     * <p>
     * Creates a new membership.
     * </p>
     *
     * @param createMembershipRequest
     * @return A Java Future containing the result of the CreateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMembershipResponse> createMembership(CreateMembershipRequest createMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMembershipRequest#builder()}
     * </p>
     *
     * @param createMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CreateMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMembershipResponse> createMembership(
            Consumer<CreateMembershipRequest.Builder> createMembershipRequest) {
        return createMembership(CreateMembershipRequest.builder().applyMutation(createMembershipRequest).build());
    }

    /**
     * <p>
     * Returns the attributes of a case.
     * </p>
     *
     * @param getCaseRequest
     * @return A Java Future containing the result of the GetCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCaseResponse> getCase(GetCaseRequest getCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the attributes of a case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseRequest.Builder} avoiding the need to create
     * one manually via {@link GetCaseRequest#builder()}
     * </p>
     *
     * @param getCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCaseResponse> getCase(Consumer<GetCaseRequest.Builder> getCaseRequest) {
        return getCase(GetCaseRequest.builder().applyMutation(getCaseRequest).build());
    }

    /**
     * <p>
     * Returns a Pre-Signed URL for uploading attachments into a case.
     * </p>
     *
     * @param getCaseAttachmentDownloadUrlRequest
     * @return A Java Future containing the result of the GetCaseAttachmentDownloadUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCaseAttachmentDownloadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentDownloadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCaseAttachmentDownloadUrlResponse> getCaseAttachmentDownloadUrl(
            GetCaseAttachmentDownloadUrlRequest getCaseAttachmentDownloadUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Pre-Signed URL for uploading attachments into a case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseAttachmentDownloadUrlRequest.Builder}
     * avoiding the need to create one manually via {@link GetCaseAttachmentDownloadUrlRequest#builder()}
     * </p>
     *
     * @param getCaseAttachmentDownloadUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCaseAttachmentDownloadUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCaseAttachmentDownloadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentDownloadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCaseAttachmentDownloadUrlResponse> getCaseAttachmentDownloadUrl(
            Consumer<GetCaseAttachmentDownloadUrlRequest.Builder> getCaseAttachmentDownloadUrlRequest) {
        return getCaseAttachmentDownloadUrl(GetCaseAttachmentDownloadUrlRequest.builder()
                .applyMutation(getCaseAttachmentDownloadUrlRequest).build());
    }

    /**
     * <p>
     * Uploads an attachment to a case.
     * </p>
     *
     * @param getCaseAttachmentUploadUrlRequest
     * @return A Java Future containing the result of the GetCaseAttachmentUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCaseAttachmentUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCaseAttachmentUploadUrlResponse> getCaseAttachmentUploadUrl(
            GetCaseAttachmentUploadUrlRequest getCaseAttachmentUploadUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an attachment to a case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseAttachmentUploadUrlRequest.Builder} avoiding
     * the need to create one manually via {@link GetCaseAttachmentUploadUrlRequest#builder()}
     * </p>
     *
     * @param getCaseAttachmentUploadUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCaseAttachmentUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCaseAttachmentUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCaseAttachmentUploadUrlResponse> getCaseAttachmentUploadUrl(
            Consumer<GetCaseAttachmentUploadUrlRequest.Builder> getCaseAttachmentUploadUrlRequest) {
        return getCaseAttachmentUploadUrl(GetCaseAttachmentUploadUrlRequest.builder()
                .applyMutation(getCaseAttachmentUploadUrlRequest).build());
    }

    /**
     * <p>
     * Returns the attributes of a membership.
     * </p>
     *
     * @param getMembershipRequest
     * @return A Java Future containing the result of the GetMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembershipResponse> getMembership(GetMembershipRequest getMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the attributes of a membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembershipRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembershipRequest#builder()}
     * </p>
     *
     * @param getMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetMembershipRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMembershipResponse> getMembership(Consumer<GetMembershipRequest.Builder> getMembershipRequest) {
        return getMembership(GetMembershipRequest.builder().applyMutation(getMembershipRequest).build());
    }

    /**
     * <p>
     * Views the case history for edits made to a designated case.
     * </p>
     *
     * @param listCaseEditsRequest
     * @return A Java Future containing the result of the ListCaseEdits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCaseEditsResponse> listCaseEdits(ListCaseEditsRequest listCaseEditsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Views the case history for edits made to a designated case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCaseEditsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCaseEditsRequest#builder()}
     * </p>
     *
     * @param listCaseEditsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCaseEdits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCaseEditsResponse> listCaseEdits(Consumer<ListCaseEditsRequest.Builder> listCaseEditsRequest) {
        return listCaseEdits(ListCaseEditsRequest.builder().applyMutation(listCaseEditsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsPublisher publisher = client.listCaseEditsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsPublisher publisher = client.listCaseEditsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation.</b>
     * </p>
     *
     * @param listCaseEditsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCaseEditsPublisher listCaseEditsPaginator(ListCaseEditsRequest listCaseEditsRequest) {
        return new ListCaseEditsPublisher(this, listCaseEditsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsPublisher publisher = client.listCaseEditsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsPublisher publisher = client.listCaseEditsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCaseEditsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCaseEditsRequest#builder()}
     * </p>
     *
     * @param listCaseEditsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCaseEditsPublisher listCaseEditsPaginator(Consumer<ListCaseEditsRequest.Builder> listCaseEditsRequest) {
        return listCaseEditsPaginator(ListCaseEditsRequest.builder().applyMutation(listCaseEditsRequest).build());
    }

    /**
     * <p>
     * Lists all cases the requester has access to.
     * </p>
     *
     * @param listCasesRequest
     * @return A Java Future containing the result of the ListCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCasesResponse> listCases(ListCasesRequest listCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all cases the requester has access to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListCasesRequest#builder()}
     * </p>
     *
     * @param listCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCasesResponse> listCases(Consumer<ListCasesRequest.Builder> listCasesRequest) {
        return listCases(ListCasesRequest.builder().applyMutation(listCasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesPublisher publisher = client.listCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesPublisher publisher = client.listCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)} operation.</b>
     * </p>
     *
     * @param listCasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCasesPublisher listCasesPaginator(ListCasesRequest listCasesRequest) {
        return new ListCasesPublisher(this, listCasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesPublisher publisher = client.listCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesPublisher publisher = client.listCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListCasesRequest#builder()}
     * </p>
     *
     * @param listCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCasesPublisher listCasesPaginator(Consumer<ListCasesRequest.Builder> listCasesRequest) {
        return listCasesPaginator(ListCasesRequest.builder().applyMutation(listCasesRequest).build());
    }

    /**
     * <p>
     * Returns comments for a designated case.
     * </p>
     *
     * @param listCommentsRequest
     * @return A Java Future containing the result of the ListComments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommentsResponse> listComments(ListCommentsRequest listCommentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns comments for a designated case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommentsRequest#builder()}
     * </p>
     *
     * @param listCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCommentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListComments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommentsResponse> listComments(Consumer<ListCommentsRequest.Builder> listCommentsRequest) {
        return listComments(ListCommentsRequest.builder().applyMutation(listCommentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsPublisher publisher = client.listCommentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsPublisher publisher = client.listCommentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListCommentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListCommentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)} operation.</b>
     * </p>
     *
     * @param listCommentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommentsPublisher listCommentsPaginator(ListCommentsRequest listCommentsRequest) {
        return new ListCommentsPublisher(this, listCommentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsPublisher publisher = client.listCommentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsPublisher publisher = client.listCommentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListCommentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListCommentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommentsRequest#builder()}
     * </p>
     *
     * @param listCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCommentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommentsPublisher listCommentsPaginator(Consumer<ListCommentsRequest.Builder> listCommentsRequest) {
        return listCommentsPaginator(ListCommentsRequest.builder().applyMutation(listCommentsRequest).build());
    }

    /**
     * <p>
     * Investigation performed by an agent for a security incident...
     * </p>
     *
     * @param listInvestigationsRequest
     * @return A Java Future containing the result of the ListInvestigations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvestigationsResponse> listInvestigations(ListInvestigationsRequest listInvestigationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Investigation performed by an agent for a security incident...
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvestigationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvestigationsRequest#builder()}
     * </p>
     *
     * @param listInvestigationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInvestigations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvestigationsResponse> listInvestigations(
            Consumer<ListInvestigationsRequest.Builder> listInvestigationsRequest) {
        return listInvestigations(ListInvestigationsRequest.builder().applyMutation(listInvestigationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsPublisher publisher = client.listInvestigationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsPublisher publisher = client.listInvestigationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvestigationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvestigationsPublisher listInvestigationsPaginator(ListInvestigationsRequest listInvestigationsRequest) {
        return new ListInvestigationsPublisher(this, listInvestigationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsPublisher publisher = client.listInvestigationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsPublisher publisher = client.listInvestigationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvestigationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvestigationsRequest#builder()}
     * </p>
     *
     * @param listInvestigationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvestigationsPublisher listInvestigationsPaginator(
            Consumer<ListInvestigationsRequest.Builder> listInvestigationsRequest) {
        return listInvestigationsPaginator(ListInvestigationsRequest.builder().applyMutation(listInvestigationsRequest).build());
    }

    /**
     * <p>
     * Returns the memberships that the calling principal can access.
     * </p>
     *
     * @param listMembershipsRequest
     * @return A Java Future containing the result of the ListMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMembershipsResponse> listMemberships(ListMembershipsRequest listMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the memberships that the calling principal can access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMembershipsRequest#builder()}
     * </p>
     *
     * @param listMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListMembershipsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMembershipsResponse> listMemberships(
            Consumer<ListMembershipsRequest.Builder> listMembershipsRequest) {
        return listMemberships(ListMembershipsRequest.builder().applyMutation(listMembershipsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsPublisher publisher = client.listMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsPublisher publisher = client.listMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation.</b>
     * </p>
     *
     * @param listMembershipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsPublisher listMembershipsPaginator(ListMembershipsRequest listMembershipsRequest) {
        return new ListMembershipsPublisher(this, listMembershipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsPublisher publisher = client.listMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsPublisher publisher = client.listMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.securityir.model.ListMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.securityir.model.ListMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMembershipsRequest#builder()}
     * </p>
     *
     * @param listMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListMembershipsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsPublisher listMembershipsPaginator(Consumer<ListMembershipsRequest.Builder> listMembershipsRequest) {
        return listMembershipsPaginator(ListMembershipsRequest.builder().applyMutation(listMembershipsRequest).build());
    }

    /**
     * <p>
     * Returns currently configured tags on a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns currently configured tags on a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Send feedback based on response investigation action
     * </p>
     *
     * @param sendFeedbackRequest
     * @return A Java Future containing the result of the SendFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.SendFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/SendFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendFeedbackResponse> sendFeedback(SendFeedbackRequest sendFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send feedback based on response investigation action
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link SendFeedbackRequest#builder()}
     * </p>
     *
     * @param sendFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.SendFeedbackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.SendFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/SendFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendFeedbackResponse> sendFeedback(Consumer<SendFeedbackRequest.Builder> sendFeedbackRequest) {
        return sendFeedback(SendFeedbackRequest.builder().applyMutation(sendFeedbackRequest).build());
    }

    /**
     * <p>
     * Adds a tag(s) to a designated resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag(s) to a designated resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag(s) from a designate resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag(s) from a designate resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing case.
     * </p>
     *
     * @param updateCaseRequest
     * @return A Java Future containing the result of the UpdateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCaseResponse> updateCase(UpdateCaseRequest updateCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaseRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCaseRequest#builder()}
     * </p>
     *
     * @param updateCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCaseResponse> updateCase(Consumer<UpdateCaseRequest.Builder> updateCaseRequest) {
        return updateCase(UpdateCaseRequest.builder().applyMutation(updateCaseRequest).build());
    }

    /**
     * <p>
     * Updates an existing case comment.
     * </p>
     *
     * @param updateCaseCommentRequest
     * @return A Java Future containing the result of the UpdateCaseComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCaseCommentResponse> updateCaseComment(UpdateCaseCommentRequest updateCaseCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing case comment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaseCommentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCaseCommentRequest#builder()}
     * </p>
     *
     * @param updateCaseCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateCaseCommentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCaseComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCaseCommentResponse> updateCaseComment(
            Consumer<UpdateCaseCommentRequest.Builder> updateCaseCommentRequest) {
        return updateCaseComment(UpdateCaseCommentRequest.builder().applyMutation(updateCaseCommentRequest).build());
    }

    /**
     * <p>
     * Updates the state transitions for a designated cases.
     * </p>
     * <p>
     * <b>Self-managed</b>: the following states are available for self-managed cases.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Any → Closed
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>AWS supported</b>: You must use the <code>CloseCase</code> API to close.
     * </p>
     *
     * @param updateCaseStatusRequest
     * @return A Java Future containing the result of the UpdateCaseStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCaseStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCaseStatusResponse> updateCaseStatus(UpdateCaseStatusRequest updateCaseStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the state transitions for a designated cases.
     * </p>
     * <p>
     * <b>Self-managed</b>: the following states are available for self-managed cases.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Any → Closed
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>AWS supported</b>: You must use the <code>CloseCase</code> API to close.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaseStatusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCaseStatusRequest#builder()}
     * </p>
     *
     * @param updateCaseStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateCaseStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCaseStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCaseStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCaseStatusResponse> updateCaseStatus(
            Consumer<UpdateCaseStatusRequest.Builder> updateCaseStatusRequest) {
        return updateCaseStatus(UpdateCaseStatusRequest.builder().applyMutation(updateCaseStatusRequest).build());
    }

    /**
     * <p>
     * Updates membership configuration.
     * </p>
     *
     * @param updateMembershipRequest
     * @return A Java Future containing the result of the UpdateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMembershipResponse> updateMembership(UpdateMembershipRequest updateMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates membership configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMembershipRequest#builder()}
     * </p>
     *
     * @param updateMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMembershipResponse> updateMembership(
            Consumer<UpdateMembershipRequest.Builder> updateMembershipRequest) {
        return updateMembership(UpdateMembershipRequest.builder().applyMutation(updateMembershipRequest).build());
    }

    /**
     * <p>
     * Updates the resolver type for a case.
     * </p>
     * <important>
     * <p>
     * This is a one-way action and cannot be reversed.
     * </p>
     * </important>
     *
     * @param updateResolverTypeRequest
     * @return A Java Future containing the result of the UpdateResolverType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateResolverType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateResolverType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverTypeResponse> updateResolverType(UpdateResolverTypeRequest updateResolverTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the resolver type for a case.
     * </p>
     * <important>
     * <p>
     * This is a one-way action and cannot be reversed.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverTypeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResolverTypeRequest#builder()}
     * </p>
     *
     * @param updateResolverTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateResolverTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResolverType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateResolverType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateResolverType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResolverTypeResponse> updateResolverType(
            Consumer<UpdateResolverTypeRequest.Builder> updateResolverTypeRequest) {
        return updateResolverType(UpdateResolverTypeRequest.builder().applyMutation(updateResolverTypeRequest).build());
    }

    @Override
    default SecurityIrServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SecurityIrAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityIrAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityIrAsyncClient}.
     */
    static SecurityIrAsyncClientBuilder builder() {
        return new DefaultSecurityIrAsyncClientBuilder();
    }
}
