/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.DateRangeUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateRange> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DateRange.getter(DateRange::value)).setter(DateRange.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DateRange.getter(DateRange::unitAsString)).setter(DateRange.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer value;
    private final String unit;

    private DateRange(BuilderImpl builder) {
        this.value = builder.value;
        this.unit = builder.unit;
    }

    public Integer value() {
        return this.value;
    }

    public DateRangeUnit unit() {
        return DateRangeUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public String toString() {
        return ToString.builder((String)"DateRange").add("Value", (Object)this.value()).add("Unit", (Object)this.unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateRange, T> g) {
        return obj -> g.apply((DateRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer value;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DateRange model) {
            this.value(model.value);
            this.unit(model.unit);
        }

        public final Integer getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        public final String getUnitAsString() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(DateRangeUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public DateRange build() {
            return new DateRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateRange> {
        public Builder value(Integer var1);

        public Builder unit(String var1);

        public Builder unit(DateRangeUnit var1);
    }
}

