/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class VpcInfoIpv6CidrBlockSetListCopier {
    static List<VpcInfoIpv6CidrBlockSetDetails> copy(
            Collection<? extends VpcInfoIpv6CidrBlockSetDetails> vpcInfoIpv6CidrBlockSetListParam) {
        List<VpcInfoIpv6CidrBlockSetDetails> list;
        if (vpcInfoIpv6CidrBlockSetListParam == null || vpcInfoIpv6CidrBlockSetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcInfoIpv6CidrBlockSetDetails> modifiableList = new ArrayList<>(vpcInfoIpv6CidrBlockSetListParam.size());
            vpcInfoIpv6CidrBlockSetListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VpcInfoIpv6CidrBlockSetDetails> copyFromBuilder(
            Collection<? extends VpcInfoIpv6CidrBlockSetDetails.Builder> vpcInfoIpv6CidrBlockSetListParam) {
        List<VpcInfoIpv6CidrBlockSetDetails> list;
        if (vpcInfoIpv6CidrBlockSetListParam == null || vpcInfoIpv6CidrBlockSetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcInfoIpv6CidrBlockSetDetails> modifiableList = new ArrayList<>(vpcInfoIpv6CidrBlockSetListParam.size());
            vpcInfoIpv6CidrBlockSetListParam.forEach(entry -> {
                VpcInfoIpv6CidrBlockSetDetails member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VpcInfoIpv6CidrBlockSetDetails.Builder> copyToBuilder(
            Collection<? extends VpcInfoIpv6CidrBlockSetDetails> vpcInfoIpv6CidrBlockSetListParam) {
        List<VpcInfoIpv6CidrBlockSetDetails.Builder> list;
        if (vpcInfoIpv6CidrBlockSetListParam == null || vpcInfoIpv6CidrBlockSetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcInfoIpv6CidrBlockSetDetails.Builder> modifiableList = new ArrayList<>(vpcInfoIpv6CidrBlockSetListParam.size());
            vpcInfoIpv6CidrBlockSetListParam.forEach(entry -> {
                VpcInfoIpv6CidrBlockSetDetails.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
