/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateConnectorV2Request.Builder, UpdateConnectorV2Request> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(UpdateConnectorV2Request::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("ConnectorId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateConnectorV2Request::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ProviderUpdateConfiguration> PROVIDER_FIELD = SdkField
            .<ProviderUpdateConfiguration> builder(MarshallingType.SDK_POJO).memberName("Provider")
            .getter(getter(UpdateConnectorV2Request::provider)).setter(setter(Builder::provider))
            .constructor(ProviderUpdateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            DESCRIPTION_FIELD, PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorId;

    private final String description;

    private final ProviderUpdateConfiguration provider;

    private UpdateConnectorV2Request(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.description = builder.description;
        this.provider = builder.provider;
    }

    /**
     * <p>
     * The UUID of the connectorV2 to identify connectorV2 resource.
     * </p>
     * 
     * @return The UUID of the connectorV2 to identify connectorV2 resource.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The description of the connectorV2.
     * </p>
     * 
     * @return The description of the connectorV2.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The third-party provider’s service configuration.
     * </p>
     * 
     * @return The third-party provider’s service configuration.
     */
    public final ProviderUpdateConfiguration provider() {
        return provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorV2Request)) {
            return false;
        }
        UpdateConnectorV2Request other = (UpdateConnectorV2Request) obj;
        return Objects.equals(connectorId(), other.connectorId()) && Objects.equals(description(), other.description())
                && Objects.equals(provider(), other.provider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorV2Request").add("ConnectorId", connectorId()).add("Description", description())
                .add("Provider", provider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(provider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorV2Request, T> g) {
        return obj -> g.apply((UpdateConnectorV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectorV2Request> {
        /**
         * <p>
         * The UUID of the connectorV2 to identify connectorV2 resource.
         * </p>
         * 
         * @param connectorId
         *        The UUID of the connectorV2 to identify connectorV2 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The description of the connectorV2.
         * </p>
         * 
         * @param description
         *        The description of the connectorV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The third-party provider’s service configuration.
         * </p>
         * 
         * @param provider
         *        The third-party provider’s service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(ProviderUpdateConfiguration provider);

        /**
         * <p>
         * The third-party provider’s service configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderUpdateConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProviderUpdateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderUpdateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #provider(ProviderUpdateConfiguration)}.
         * 
         * @param provider
         *        a consumer that will call methods on {@link ProviderUpdateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provider(ProviderUpdateConfiguration)
         */
        default Builder provider(Consumer<ProviderUpdateConfiguration.Builder> provider) {
            return provider(ProviderUpdateConfiguration.builder().applyMutation(provider).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String connectorId;

        private String description;

        private ProviderUpdateConfiguration provider;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorV2Request model) {
            super(model);
            connectorId(model.connectorId);
            description(model.description);
            provider(model.provider);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProviderUpdateConfiguration.Builder getProvider() {
            return provider != null ? provider.toBuilder() : null;
        }

        public final void setProvider(ProviderUpdateConfiguration.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        @Override
        public final Builder provider(ProviderUpdateConfiguration provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorV2Request build() {
            return new UpdateConnectorV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
