/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationPolicyRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateConfigurationPolicyRequest.Builder, UpdateConfigurationPolicyRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateConfigurationPolicyRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateConfigurationPolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateConfigurationPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> UPDATED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedReason").getter(getter(UpdateConfigurationPolicyRequest::updatedReason))
            .setter(setter(Builder::updatedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedReason").build()).build();

    private static final SdkField<Policy> CONFIGURATION_POLICY_FIELD = SdkField.<Policy> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigurationPolicy").getter(getter(UpdateConfigurationPolicyRequest::configurationPolicy))
            .setter(setter(Builder::configurationPolicy)).constructor(Policy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, UPDATED_REASON_FIELD, CONFIGURATION_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String name;

    private final String description;

    private final String updatedReason;

    private final Policy configurationPolicy;

    private UpdateConfigurationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.description = builder.description;
        this.updatedReason = builder.updatedReason;
        this.configurationPolicy = builder.configurationPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the configuration policy. Alphanumeric characters and the following ASCII characters are permitted:
     * <code>-, ., !, *, /</code>.
     * </p>
     * 
     * @return The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
     *         permitted: <code>-, ., !, *, /</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the configuration policy.
     * </p>
     * 
     * @return The description of the configuration policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The reason for updating the configuration policy.
     * </p>
     * 
     * @return The reason for updating the configuration policy.
     */
    public final String updatedReason() {
        return updatedReason;
    }

    /**
     * <p>
     * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a
     * list of enabled security standards, a list of enabled or disabled security controls, and a list of custom
     * parameter values for specified controls. If you provide a list of security controls that are enabled in the
     * configuration policy, Security Hub disables all other controls (including newly released controls). If you
     * provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other
     * controls (including newly released controls).
     * </p>
     * <p>
     * When updating a configuration policy, provide a complete list of standards that you want to enable and a complete
     * list of controls that you want to enable or disable. The updated configuration replaces the current
     * configuration.
     * </p>
     * 
     * @return An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
     *         disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a
     *         list of custom parameter values for specified controls. If you provide a list of security controls that
     *         are enabled in the configuration policy, Security Hub disables all other controls (including newly
     *         released controls). If you provide a list of security controls that are disabled in the configuration
     *         policy, Security Hub enables all other controls (including newly released controls). </p>
     *         <p>
     *         When updating a configuration policy, provide a complete list of standards that you want to enable and a
     *         complete list of controls that you want to enable or disable. The updated configuration replaces the
     *         current configuration.
     */
    public final Policy configurationPolicy() {
        return configurationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updatedReason());
        hashCode = 31 * hashCode + Objects.hashCode(configurationPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationPolicyRequest)) {
            return false;
        }
        UpdateConfigurationPolicyRequest other = (UpdateConfigurationPolicyRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(updatedReason(), other.updatedReason())
                && Objects.equals(configurationPolicy(), other.configurationPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigurationPolicyRequest").add("Identifier", identifier()).add("Name", name())
                .add("Description", description()).add("UpdatedReason", updatedReason())
                .add("ConfigurationPolicy", configurationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UpdatedReason":
            return Optional.ofNullable(clazz.cast(updatedReason()));
        case "ConfigurationPolicy":
            return Optional.ofNullable(clazz.cast(configurationPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("UpdatedReason", UPDATED_REASON_FIELD);
        map.put("ConfigurationPolicy", CONFIGURATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationPolicyRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfigurationPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
         * </p>
         * 
         * @param identifier
         *        The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
         * permitted: <code>-, ., !, *, /</code>.
         * </p>
         * 
         * @param name
         *        The name of the configuration policy. Alphanumeric characters and the following ASCII characters are
         *        permitted: <code>-, ., !, *, /</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the configuration policy.
         * </p>
         * 
         * @param description
         *        The description of the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reason for updating the configuration policy.
         * </p>
         * 
         * @param updatedReason
         *        The reason for updating the configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedReason(String updatedReason);

        /**
         * <p>
         * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         * disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list
         * of custom parameter values for specified controls. If you provide a list of security controls that are
         * enabled in the configuration policy, Security Hub disables all other controls (including newly released
         * controls). If you provide a list of security controls that are disabled in the configuration policy, Security
         * Hub enables all other controls (including newly released controls).
         * </p>
         * <p>
         * When updating a configuration policy, provide a complete list of standards that you want to enable and a
         * complete list of controls that you want to enable or disable. The updated configuration replaces the current
         * configuration.
         * </p>
         * 
         * @param configurationPolicy
         *        An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         *        disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a
         *        list of custom parameter values for specified controls. If you provide a list of security controls
         *        that are enabled in the configuration policy, Security Hub disables all other controls (including
         *        newly released controls). If you provide a list of security controls that are disabled in the
         *        configuration policy, Security Hub enables all other controls (including newly released controls).
         *        </p>
         *        <p>
         *        When updating a configuration policy, provide a complete list of standards that you want to enable and
         *        a complete list of controls that you want to enable or disable. The updated configuration replaces the
         *        current configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicy(Policy configurationPolicy);

        /**
         * <p>
         * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or
         * disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list
         * of custom parameter values for specified controls. If you provide a list of security controls that are
         * enabled in the configuration policy, Security Hub disables all other controls (including newly released
         * controls). If you provide a list of security controls that are disabled in the configuration policy, Security
         * Hub enables all other controls (including newly released controls).
         * </p>
         * <p>
         * When updating a configuration policy, provide a complete list of standards that you want to enable and a
         * complete list of controls that you want to enable or disable. The updated configuration replaces the current
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Policy.Builder} avoiding the need to
         * create one manually via {@link Policy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Policy.Builder#build()} is called immediately and its result is
         * passed to {@link #configurationPolicy(Policy)}.
         * 
         * @param configurationPolicy
         *        a consumer that will call methods on {@link Policy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationPolicy(Policy)
         */
        default Builder configurationPolicy(Consumer<Policy.Builder> configurationPolicy) {
            return configurationPolicy(Policy.builder().applyMutation(configurationPolicy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String identifier;

        private String name;

        private String description;

        private String updatedReason;

        private Policy configurationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationPolicyRequest model) {
            super(model);
            identifier(model.identifier);
            name(model.name);
            description(model.description);
            updatedReason(model.updatedReason);
            configurationPolicy(model.configurationPolicy);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUpdatedReason() {
            return updatedReason;
        }

        public final void setUpdatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
        }

        @Override
        public final Builder updatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
            return this;
        }

        public final Policy.Builder getConfigurationPolicy() {
            return configurationPolicy != null ? configurationPolicy.toBuilder() : null;
        }

        public final void setConfigurationPolicy(Policy.BuilderImpl configurationPolicy) {
            this.configurationPolicy = configurationPolicy != null ? configurationPolicy.build() : null;
        }

        @Override
        public final Builder configurationPolicy(Policy configurationPolicy) {
            this.configurationPolicy = configurationPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationPolicyRequest build() {
            return new UpdateConfigurationPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
