/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateActionTargetRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateActionTargetRequest.Builder, UpdateActionTargetRequest> {
    private static final SdkField<String> ACTION_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionTargetArn").getter(getter(UpdateActionTargetRequest::actionTargetArn))
            .setter(setter(Builder::actionTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("ActionTargetArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateActionTargetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateActionTargetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TARGET_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String actionTargetArn;

    private final String name;

    private final String description;

    private UpdateActionTargetRequest(BuilderImpl builder) {
        super(builder);
        this.actionTargetArn = builder.actionTargetArn;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ARN of the custom action target to update.
     * </p>
     * 
     * @return The ARN of the custom action target to update.
     */
    public final String actionTargetArn() {
        return actionTargetArn;
    }

    /**
     * <p>
     * The updated name of the custom action target.
     * </p>
     * 
     * @return The updated name of the custom action target.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated description for the custom action target.
     * </p>
     * 
     * @return The updated description for the custom action target.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActionTargetRequest)) {
            return false;
        }
        UpdateActionTargetRequest other = (UpdateActionTargetRequest) obj;
        return Objects.equals(actionTargetArn(), other.actionTargetArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateActionTargetRequest").add("ActionTargetArn", actionTargetArn()).add("Name", name())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionTargetArn":
            return Optional.ofNullable(clazz.cast(actionTargetArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionTargetArn", ACTION_TARGET_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateActionTargetRequest, T> g) {
        return obj -> g.apply((UpdateActionTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateActionTargetRequest> {
        /**
         * <p>
         * The ARN of the custom action target to update.
         * </p>
         * 
         * @param actionTargetArn
         *        The ARN of the custom action target to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTargetArn(String actionTargetArn);

        /**
         * <p>
         * The updated name of the custom action target.
         * </p>
         * 
         * @param name
         *        The updated name of the custom action target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated description for the custom action target.
         * </p>
         * 
         * @param description
         *        The updated description for the custom action target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String actionTargetArn;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActionTargetRequest model) {
            super(model);
            actionTargetArn(model.actionTargetArn);
            name(model.name);
            description(model.description);
        }

        public final String getActionTargetArn() {
            return actionTargetArn;
        }

        public final void setActionTargetArn(String actionTargetArn) {
            this.actionTargetArn = actionTargetArn;
        }

        @Override
        public final Builder actionTargetArn(String actionTargetArn) {
            this.actionTargetArn = actionTargetArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateActionTargetRequest build() {
            return new UpdateActionTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
