/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about which control's enablement status could not be updated in a specified standard when calling
 * the <a
 * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
 * >BatchUpdateStandardsControlAssociations</a> API. This parameter also provides details about why the request was
 * unprocessed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessedStandardsControlAssociationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<UnprocessedStandardsControlAssociationUpdate.Builder, UnprocessedStandardsControlAssociationUpdate> {
    private static final SdkField<StandardsControlAssociationUpdate> STANDARDS_CONTROL_ASSOCIATION_UPDATE_FIELD = SdkField
            .<StandardsControlAssociationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("StandardsControlAssociationUpdate")
            .getter(getter(UnprocessedStandardsControlAssociationUpdate::standardsControlAssociationUpdate))
            .setter(setter(Builder::standardsControlAssociationUpdate))
            .constructor(StandardsControlAssociationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationUpdate")
                    .build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(UnprocessedStandardsControlAssociationUpdate::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorReason").getter(getter(UnprocessedStandardsControlAssociationUpdate::errorReason))
            .setter(setter(Builder::errorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STANDARDS_CONTROL_ASSOCIATION_UPDATE_FIELD, ERROR_CODE_FIELD, ERROR_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StandardsControlAssociationUpdate standardsControlAssociationUpdate;

    private final String errorCode;

    private final String errorReason;

    private UnprocessedStandardsControlAssociationUpdate(BuilderImpl builder) {
        this.standardsControlAssociationUpdate = builder.standardsControlAssociationUpdate;
        this.errorCode = builder.errorCode;
        this.errorReason = builder.errorReason;
    }

    /**
     * <p>
     * An array of control and standard associations for which an update failed when calling <a href=
     * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
     * >BatchUpdateStandardsControlAssociations</a>.
     * </p>
     * 
     * @return An array of control and standard associations for which an update failed when calling <a href=
     *         "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
     *         >BatchUpdateStandardsControlAssociations</a>.
     */
    public final StandardsControlAssociationUpdate standardsControlAssociationUpdate() {
        return standardsControlAssociationUpdate;
    }

    /**
     * <p>
     * The error code for the unprocessed update of the control's enablement status in the specified standard. The
     * <code>NOT_FOUND</code> value has been deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UnprocessedErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the unprocessed update of the control's enablement status in the specified standard.
     *         The <code>NOT_FOUND</code> value has been deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code>
     *         value.
     * @see UnprocessedErrorCode
     */
    public final UnprocessedErrorCode errorCode() {
        return UnprocessedErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code for the unprocessed update of the control's enablement status in the specified standard. The
     * <code>NOT_FOUND</code> value has been deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UnprocessedErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the unprocessed update of the control's enablement status in the specified standard.
     *         The <code>NOT_FOUND</code> value has been deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code>
     *         value.
     * @see UnprocessedErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The reason why a control's enablement status in the specified standard couldn't be updated.
     * </p>
     * 
     * @return The reason why a control's enablement status in the specified standard couldn't be updated.
     */
    public final String errorReason() {
        return errorReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsControlAssociationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedStandardsControlAssociationUpdate)) {
            return false;
        }
        UnprocessedStandardsControlAssociationUpdate other = (UnprocessedStandardsControlAssociationUpdate) obj;
        return Objects.equals(standardsControlAssociationUpdate(), other.standardsControlAssociationUpdate())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorReason(), other.errorReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnprocessedStandardsControlAssociationUpdate")
                .add("StandardsControlAssociationUpdate", standardsControlAssociationUpdate())
                .add("ErrorCode", errorCodeAsString()).add("ErrorReason", errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsControlAssociationUpdate":
            return Optional.ofNullable(clazz.cast(standardsControlAssociationUpdate()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "ErrorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StandardsControlAssociationUpdate", STANDARDS_CONTROL_ASSOCIATION_UPDATE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorReason", ERROR_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedStandardsControlAssociationUpdate, T> g) {
        return obj -> g.apply((UnprocessedStandardsControlAssociationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessedStandardsControlAssociationUpdate> {
        /**
         * <p>
         * An array of control and standard associations for which an update failed when calling <a href=
         * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
         * >BatchUpdateStandardsControlAssociations</a>.
         * </p>
         * 
         * @param standardsControlAssociationUpdate
         *        An array of control and standard associations for which an update failed when calling <a href=
         *        "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
         *        >BatchUpdateStandardsControlAssociations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsControlAssociationUpdate(StandardsControlAssociationUpdate standardsControlAssociationUpdate);

        /**
         * <p>
         * An array of control and standard associations for which an update failed when calling <a href=
         * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
         * >BatchUpdateStandardsControlAssociations</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StandardsControlAssociationUpdate.Builder} avoiding the need to create one manually via
         * {@link StandardsControlAssociationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardsControlAssociationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #standardsControlAssociationUpdate(StandardsControlAssociationUpdate)}.
         * 
         * @param standardsControlAssociationUpdate
         *        a consumer that will call methods on {@link StandardsControlAssociationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardsControlAssociationUpdate(StandardsControlAssociationUpdate)
         */
        default Builder standardsControlAssociationUpdate(
                Consumer<StandardsControlAssociationUpdate.Builder> standardsControlAssociationUpdate) {
            return standardsControlAssociationUpdate(StandardsControlAssociationUpdate.builder()
                    .applyMutation(standardsControlAssociationUpdate).build());
        }

        /**
         * <p>
         * The error code for the unprocessed update of the control's enablement status in the specified standard. The
         * <code>NOT_FOUND</code> value has been deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
         * </p>
         * 
         * @param errorCode
         *        The error code for the unprocessed update of the control's enablement status in the specified
         *        standard. The <code>NOT_FOUND</code> value has been deprecated and replaced by the
         *        <code>RESOURCE_NOT_FOUND</code> value.
         * @see UnprocessedErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnprocessedErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code for the unprocessed update of the control's enablement status in the specified standard. The
         * <code>NOT_FOUND</code> value has been deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
         * </p>
         * 
         * @param errorCode
         *        The error code for the unprocessed update of the control's enablement status in the specified
         *        standard. The <code>NOT_FOUND</code> value has been deprecated and replaced by the
         *        <code>RESOURCE_NOT_FOUND</code> value.
         * @see UnprocessedErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnprocessedErrorCode
         */
        Builder errorCode(UnprocessedErrorCode errorCode);

        /**
         * <p>
         * The reason why a control's enablement status in the specified standard couldn't be updated.
         * </p>
         * 
         * @param errorReason
         *        The reason why a control's enablement status in the specified standard couldn't be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(String errorReason);
    }

    static final class BuilderImpl implements Builder {
        private StandardsControlAssociationUpdate standardsControlAssociationUpdate;

        private String errorCode;

        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedStandardsControlAssociationUpdate model) {
            standardsControlAssociationUpdate(model.standardsControlAssociationUpdate);
            errorCode(model.errorCode);
            errorReason(model.errorReason);
        }

        public final StandardsControlAssociationUpdate.Builder getStandardsControlAssociationUpdate() {
            return standardsControlAssociationUpdate != null ? standardsControlAssociationUpdate.toBuilder() : null;
        }

        public final void setStandardsControlAssociationUpdate(
                StandardsControlAssociationUpdate.BuilderImpl standardsControlAssociationUpdate) {
            this.standardsControlAssociationUpdate = standardsControlAssociationUpdate != null ? standardsControlAssociationUpdate
                    .build() : null;
        }

        @Override
        public final Builder standardsControlAssociationUpdate(StandardsControlAssociationUpdate standardsControlAssociationUpdate) {
            this.standardsControlAssociationUpdate = standardsControlAssociationUpdate;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UnprocessedErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorReason() {
            return errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        @Override
        public UnprocessedStandardsControlAssociationUpdate build() {
            return new UnprocessedStandardsControlAssociationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
