/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a security control for which a response couldn't be returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessedSecurityControl implements SdkPojo, Serializable,
        ToCopyableBuilder<UnprocessedSecurityControl.Builder, UnprocessedSecurityControl> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityControlId").getter(getter(UnprocessedSecurityControl::securityControlId))
            .setter(setter(Builder::securityControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(UnprocessedSecurityControl::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorReason").getter(getter(UnprocessedSecurityControl::errorReason))
            .setter(setter(Builder::errorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD,
            ERROR_CODE_FIELD, ERROR_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String securityControlId;

    private final String errorCode;

    private final String errorReason;

    private UnprocessedSecurityControl(BuilderImpl builder) {
        this.securityControlId = builder.securityControlId;
        this.errorCode = builder.errorCode;
        this.errorReason = builder.errorReason;
    }

    /**
     * <p>
     * The control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both
     * parameters) for which a response couldn't be returned.
     * </p>
     * 
     * @return The control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of
     *         both parameters) for which a response couldn't be returned.
     */
    public final String securityControlId() {
        return securityControlId;
    }

    /**
     * <p>
     * The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been deprecated and
     * replaced by the <code>RESOURCE_NOT_FOUND</code> value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UnprocessedErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been deprecated
     *         and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
     * @see UnprocessedErrorCode
     */
    public final UnprocessedErrorCode errorCode() {
        return UnprocessedErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been deprecated and
     * replaced by the <code>RESOURCE_NOT_FOUND</code> value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UnprocessedErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been deprecated
     *         and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
     * @see UnprocessedErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The reason why the security control was unprocessed.
     * </p>
     * 
     * @return The reason why the security control was unprocessed.
     */
    public final String errorReason() {
        return errorReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedSecurityControl)) {
            return false;
        }
        UnprocessedSecurityControl other = (UnprocessedSecurityControl) obj;
        return Objects.equals(securityControlId(), other.securityControlId())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorReason(), other.errorReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnprocessedSecurityControl").add("SecurityControlId", securityControlId())
                .add("ErrorCode", errorCodeAsString()).add("ErrorReason", errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControlId":
            return Optional.ofNullable(clazz.cast(securityControlId()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "ErrorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorReason", ERROR_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedSecurityControl, T> g) {
        return obj -> g.apply((UnprocessedSecurityControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessedSecurityControl> {
        /**
         * <p>
         * The control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of
         * both parameters) for which a response couldn't be returned.
         * </p>
         * 
         * @param securityControlId
         *        The control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         *        of both parameters) for which a response couldn't be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlId(String securityControlId);

        /**
         * <p>
         * The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been deprecated and
         * replaced by the <code>RESOURCE_NOT_FOUND</code> value.
         * </p>
         * 
         * @param errorCode
         *        The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been
         *        deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
         * @see UnprocessedErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnprocessedErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been deprecated and
         * replaced by the <code>RESOURCE_NOT_FOUND</code> value.
         * </p>
         * 
         * @param errorCode
         *        The error code for the unprocessed security control. The <code>NOT_FOUND</code> value has been
         *        deprecated and replaced by the <code>RESOURCE_NOT_FOUND</code> value.
         * @see UnprocessedErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnprocessedErrorCode
         */
        Builder errorCode(UnprocessedErrorCode errorCode);

        /**
         * <p>
         * The reason why the security control was unprocessed.
         * </p>
         * 
         * @param errorReason
         *        The reason why the security control was unprocessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(String errorReason);
    }

    static final class BuilderImpl implements Builder {
        private String securityControlId;

        private String errorCode;

        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedSecurityControl model) {
            securityControlId(model.securityControlId);
            errorCode(model.errorCode);
            errorReason(model.errorReason);
        }

        public final String getSecurityControlId() {
            return securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UnprocessedErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorReason() {
            return errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        @Override
        public UnprocessedSecurityControl build() {
            return new UnprocessedSecurityControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
