/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of configuration policy associations, one for each configuration policy association identifier, that was
 * specified in a <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an
 * error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessedConfigurationPolicyAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<UnprocessedConfigurationPolicyAssociation.Builder, UnprocessedConfigurationPolicyAssociation> {
    private static final SdkField<ConfigurationPolicyAssociation> CONFIGURATION_POLICY_ASSOCIATION_IDENTIFIERS_FIELD = SdkField
            .<ConfigurationPolicyAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigurationPolicyAssociationIdentifiers")
            .getter(getter(UnprocessedConfigurationPolicyAssociation::configurationPolicyAssociationIdentifiers))
            .setter(setter(Builder::configurationPolicyAssociationIdentifiers))
            .constructor(ConfigurationPolicyAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ConfigurationPolicyAssociationIdentifiers").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(UnprocessedConfigurationPolicyAssociation::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorReason").getter(getter(UnprocessedConfigurationPolicyAssociation::errorReason))
            .setter(setter(Builder::errorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_POLICY_ASSOCIATION_IDENTIFIERS_FIELD, ERROR_CODE_FIELD, ERROR_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConfigurationPolicyAssociation configurationPolicyAssociationIdentifiers;

    private final String errorCode;

    private final String errorReason;

    private UnprocessedConfigurationPolicyAssociation(BuilderImpl builder) {
        this.configurationPolicyAssociationIdentifiers = builder.configurationPolicyAssociationIdentifiers;
        this.errorCode = builder.errorCode;
        this.errorReason = builder.errorReason;
    }

    /**
     * <p>
     * Configuration policy association identifiers that were specified in a
     * <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an error.
     * </p>
     * 
     * @return Configuration policy association identifiers that were specified in a
     *         <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an error.
     */
    public final ConfigurationPolicyAssociation configurationPolicyAssociationIdentifiers() {
        return configurationPolicyAssociationIdentifiers;
    }

    /**
     * <p>
     * An HTTP status code that identifies why the configuration policy association failed.
     * </p>
     * 
     * @return An HTTP status code that identifies why the configuration policy association failed.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A string that identifies why the configuration policy association failed.
     * </p>
     * 
     * @return A string that identifies why the configuration policy association failed.
     */
    public final String errorReason() {
        return errorReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationPolicyAssociationIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedConfigurationPolicyAssociation)) {
            return false;
        }
        UnprocessedConfigurationPolicyAssociation other = (UnprocessedConfigurationPolicyAssociation) obj;
        return Objects.equals(configurationPolicyAssociationIdentifiers(), other.configurationPolicyAssociationIdentifiers())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorReason(), other.errorReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnprocessedConfigurationPolicyAssociation")
                .add("ConfigurationPolicyAssociationIdentifiers", configurationPolicyAssociationIdentifiers())
                .add("ErrorCode", errorCode()).add("ErrorReason", errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationPolicyAssociationIdentifiers":
            return Optional.ofNullable(clazz.cast(configurationPolicyAssociationIdentifiers()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationPolicyAssociationIdentifiers", CONFIGURATION_POLICY_ASSOCIATION_IDENTIFIERS_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorReason", ERROR_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedConfigurationPolicyAssociation, T> g) {
        return obj -> g.apply((UnprocessedConfigurationPolicyAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessedConfigurationPolicyAssociation> {
        /**
         * <p>
         * Configuration policy association identifiers that were specified in a
         * <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an error.
         * </p>
         * 
         * @param configurationPolicyAssociationIdentifiers
         *        Configuration policy association identifiers that were specified in a
         *        <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationPolicyAssociationIdentifiers(ConfigurationPolicyAssociation configurationPolicyAssociationIdentifiers);

        /**
         * <p>
         * Configuration policy association identifiers that were specified in a
         * <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an error.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationPolicyAssociation.Builder}
         * avoiding the need to create one manually via {@link ConfigurationPolicyAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationPolicyAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #configurationPolicyAssociationIdentifiers(ConfigurationPolicyAssociation)}.
         * 
         * @param configurationPolicyAssociationIdentifiers
         *        a consumer that will call methods on {@link ConfigurationPolicyAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationPolicyAssociationIdentifiers(ConfigurationPolicyAssociation)
         */
        default Builder configurationPolicyAssociationIdentifiers(
                Consumer<ConfigurationPolicyAssociation.Builder> configurationPolicyAssociationIdentifiers) {
            return configurationPolicyAssociationIdentifiers(ConfigurationPolicyAssociation.builder()
                    .applyMutation(configurationPolicyAssociationIdentifiers).build());
        }

        /**
         * <p>
         * An HTTP status code that identifies why the configuration policy association failed.
         * </p>
         * 
         * @param errorCode
         *        An HTTP status code that identifies why the configuration policy association failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A string that identifies why the configuration policy association failed.
         * </p>
         * 
         * @param errorReason
         *        A string that identifies why the configuration policy association failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(String errorReason);
    }

    static final class BuilderImpl implements Builder {
        private ConfigurationPolicyAssociation configurationPolicyAssociationIdentifiers;

        private String errorCode;

        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedConfigurationPolicyAssociation model) {
            configurationPolicyAssociationIdentifiers(model.configurationPolicyAssociationIdentifiers);
            errorCode(model.errorCode);
            errorReason(model.errorReason);
        }

        public final ConfigurationPolicyAssociation.Builder getConfigurationPolicyAssociationIdentifiers() {
            return configurationPolicyAssociationIdentifiers != null ? configurationPolicyAssociationIdentifiers.toBuilder()
                    : null;
        }

        public final void setConfigurationPolicyAssociationIdentifiers(
                ConfigurationPolicyAssociation.BuilderImpl configurationPolicyAssociationIdentifiers) {
            this.configurationPolicyAssociationIdentifiers = configurationPolicyAssociationIdentifiers != null ? configurationPolicyAssociationIdentifiers
                    .build() : null;
        }

        @Override
        public final Builder configurationPolicyAssociationIdentifiers(
                ConfigurationPolicyAssociation configurationPolicyAssociationIdentifiers) {
            this.configurationPolicyAssociationIdentifiers = configurationPolicyAssociationIdentifiers;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorReason() {
            return errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        @Override
        public UnprocessedConfigurationPolicyAssociation build() {
            return new UnprocessedConfigurationPolicyAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
