/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the aggregated finding values for a specific point in the findings trend timeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrendsValues implements SdkPojo, Serializable, ToCopyableBuilder<TrendsValues.Builder, TrendsValues> {
    private static final SdkField<SeverityTrendsCount> SEVERITY_TRENDS_FIELD = SdkField
            .<SeverityTrendsCount> builder(MarshallingType.SDK_POJO).memberName("SeverityTrends")
            .getter(getter(TrendsValues::severityTrends)).setter(setter(Builder::severityTrends))
            .constructor(SeverityTrendsCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityTrends").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_TRENDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SeverityTrendsCount severityTrends;

    private TrendsValues(BuilderImpl builder) {
        this.severityTrends = builder.severityTrends;
    }

    /**
     * <p>
     * The count of findings organized by severity level for this data point in the trend timeline.
     * </p>
     * 
     * @return The count of findings organized by severity level for this data point in the trend timeline.
     */
    public final SeverityTrendsCount severityTrends() {
        return severityTrends;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(severityTrends());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrendsValues)) {
            return false;
        }
        TrendsValues other = (TrendsValues) obj;
        return Objects.equals(severityTrends(), other.severityTrends());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrendsValues").add("SeverityTrends", severityTrends()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SeverityTrends":
            return Optional.ofNullable(clazz.cast(severityTrends()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SeverityTrends", SEVERITY_TRENDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrendsValues, T> g) {
        return obj -> g.apply((TrendsValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrendsValues> {
        /**
         * <p>
         * The count of findings organized by severity level for this data point in the trend timeline.
         * </p>
         * 
         * @param severityTrends
         *        The count of findings organized by severity level for this data point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityTrends(SeverityTrendsCount severityTrends);

        /**
         * <p>
         * The count of findings organized by severity level for this data point in the trend timeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityTrendsCount.Builder} avoiding the
         * need to create one manually via {@link SeverityTrendsCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityTrendsCount.Builder#build()} is called immediately and
         * its result is passed to {@link #severityTrends(SeverityTrendsCount)}.
         * 
         * @param severityTrends
         *        a consumer that will call methods on {@link SeverityTrendsCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityTrends(SeverityTrendsCount)
         */
        default Builder severityTrends(Consumer<SeverityTrendsCount.Builder> severityTrends) {
            return severityTrends(SeverityTrendsCount.builder().applyMutation(severityTrends).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SeverityTrendsCount severityTrends;

        private BuilderImpl() {
        }

        private BuilderImpl(TrendsValues model) {
            severityTrends(model.severityTrends);
        }

        public final SeverityTrendsCount.Builder getSeverityTrends() {
            return severityTrends != null ? severityTrends.toBuilder() : null;
        }

        public final void setSeverityTrends(SeverityTrendsCount.BuilderImpl severityTrends) {
            this.severityTrends = severityTrends != null ? severityTrends.build() : null;
        }

        @Override
        public final Builder severityTrends(SeverityTrendsCount severityTrends) {
            this.severityTrends = severityTrends;
            return this;
        }

        @Override
        public TrendsValues build() {
            return new TrendsValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
