/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The standard that you want to enable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardsSubscriptionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardsSubscriptionRequest.Builder, StandardsSubscriptionRequest> {
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsArn").getter(getter(StandardsSubscriptionRequest::standardsArn))
            .setter(setter(Builder::standardsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()).build();

    private static final SdkField<Map<String, String>> STANDARDS_INPUT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StandardsInput")
            .getter(getter(StandardsSubscriptionRequest::standardsInput))
            .setter(setter(Builder::standardsInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsInput").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ARN_FIELD,
            STANDARDS_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String standardsArn;

    private final Map<String, String> standardsInput;

    private StandardsSubscriptionRequest(BuilderImpl builder) {
        this.standardsArn = builder.standardsArn;
        this.standardsInput = builder.standardsInput;
    }

    /**
     * <p>
     * The ARN of the standard that you want to enable. To view the list of available standards and their ARNs, use the
     * <code>DescribeStandards</code> operation.
     * </p>
     * 
     * @return The ARN of the standard that you want to enable. To view the list of available standards and their ARNs,
     *         use the <code>DescribeStandards</code> operation.
     */
    public final String standardsArn() {
        return standardsArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the StandardsInput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStandardsInput() {
        return standardsInput != null && !(standardsInput instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value pair of input for the standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandardsInput} method.
     * </p>
     * 
     * @return A key-value pair of input for the standard.
     */
    public final Map<String, String> standardsInput() {
        return standardsInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasStandardsInput() ? standardsInput() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsSubscriptionRequest)) {
            return false;
        }
        StandardsSubscriptionRequest other = (StandardsSubscriptionRequest) obj;
        return Objects.equals(standardsArn(), other.standardsArn()) && hasStandardsInput() == other.hasStandardsInput()
                && Objects.equals(standardsInput(), other.standardsInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardsSubscriptionRequest").add("StandardsArn", standardsArn())
                .add("StandardsInput", hasStandardsInput() ? standardsInput() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsArn":
            return Optional.ofNullable(clazz.cast(standardsArn()));
        case "StandardsInput":
            return Optional.ofNullable(clazz.cast(standardsInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StandardsArn", STANDARDS_ARN_FIELD);
        map.put("StandardsInput", STANDARDS_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardsSubscriptionRequest, T> g) {
        return obj -> g.apply((StandardsSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardsSubscriptionRequest> {
        /**
         * <p>
         * The ARN of the standard that you want to enable. To view the list of available standards and their ARNs, use
         * the <code>DescribeStandards</code> operation.
         * </p>
         * 
         * @param standardsArn
         *        The ARN of the standard that you want to enable. To view the list of available standards and their
         *        ARNs, use the <code>DescribeStandards</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsArn(String standardsArn);

        /**
         * <p>
         * A key-value pair of input for the standard.
         * </p>
         * 
         * @param standardsInput
         *        A key-value pair of input for the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsInput(Map<String, String> standardsInput);
    }

    static final class BuilderImpl implements Builder {
        private String standardsArn;

        private Map<String, String> standardsInput = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsSubscriptionRequest model) {
            standardsArn(model.standardsArn);
            standardsInput(model.standardsInput);
        }

        public final String getStandardsArn() {
            return standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final Map<String, String> getStandardsInput() {
            if (standardsInput instanceof SdkAutoConstructMap) {
                return null;
            }
            return standardsInput;
        }

        public final void setStandardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
        }

        @Override
        public final Builder standardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
            return this;
        }

        @Override
        public StandardsSubscriptionRequest build() {
            return new StandardsSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
