/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reason for the current status of your subscription to the standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardsStatusReason implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardsStatusReason.Builder, StandardsStatusReason> {
    private static final SdkField<String> STATUS_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReasonCode").getter(getter(StandardsStatusReason::statusReasonCodeAsString))
            .setter(setter(Builder::statusReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasonCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_REASON_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String statusReasonCode;

    private StandardsStatusReason(BuilderImpl builder) {
        this.statusReasonCode = builder.statusReasonCode;
    }

    /**
     * <p>
     * The reason code that represents the reason for the current status of a standard subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReasonCode}
     * will return {@link StatusReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonCodeAsString}.
     * </p>
     * 
     * @return The reason code that represents the reason for the current status of a standard subscription.
     * @see StatusReasonCode
     */
    public final StatusReasonCode statusReasonCode() {
        return StatusReasonCode.fromValue(statusReasonCode);
    }

    /**
     * <p>
     * The reason code that represents the reason for the current status of a standard subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReasonCode}
     * will return {@link StatusReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonCodeAsString}.
     * </p>
     * 
     * @return The reason code that represents the reason for the current status of a standard subscription.
     * @see StatusReasonCode
     */
    public final String statusReasonCodeAsString() {
        return statusReasonCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsStatusReason)) {
            return false;
        }
        StandardsStatusReason other = (StandardsStatusReason) obj;
        return Objects.equals(statusReasonCodeAsString(), other.statusReasonCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardsStatusReason").add("StatusReasonCode", statusReasonCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusReasonCode":
            return Optional.ofNullable(clazz.cast(statusReasonCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatusReasonCode", STATUS_REASON_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardsStatusReason, T> g) {
        return obj -> g.apply((StandardsStatusReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardsStatusReason> {
        /**
         * <p>
         * The reason code that represents the reason for the current status of a standard subscription.
         * </p>
         * 
         * @param statusReasonCode
         *        The reason code that represents the reason for the current status of a standard subscription.
         * @see StatusReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusReasonCode
         */
        Builder statusReasonCode(String statusReasonCode);

        /**
         * <p>
         * The reason code that represents the reason for the current status of a standard subscription.
         * </p>
         * 
         * @param statusReasonCode
         *        The reason code that represents the reason for the current status of a standard subscription.
         * @see StatusReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusReasonCode
         */
        Builder statusReasonCode(StatusReasonCode statusReasonCode);
    }

    static final class BuilderImpl implements Builder {
        private String statusReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsStatusReason model) {
            statusReasonCode(model.statusReasonCode);
        }

        public final String getStatusReasonCode() {
            return statusReasonCode;
        }

        public final void setStatusReasonCode(String statusReasonCode) {
            this.statusReasonCode = statusReasonCode;
        }

        @Override
        public final Builder statusReasonCode(String statusReasonCode) {
            this.statusReasonCode = statusReasonCode;
            return this;
        }

        @Override
        public final Builder statusReasonCode(StatusReasonCode statusReasonCode) {
            this.statusReasonCode(statusReasonCode == null ? null : statusReasonCode.toString());
            return this;
        }

        @Override
        public StandardsStatusReason build() {
            return new StandardsStatusReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
