/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of requested updates to the enablement status of controls in specified standards. The objects in the array
 * include a security control ID, the Amazon Resource Name (ARN) of the standard, the requested enablement status, and
 * the reason for updating the enablement status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardsControlAssociationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardsControlAssociationUpdate.Builder, StandardsControlAssociationUpdate> {
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsArn").getter(getter(StandardsControlAssociationUpdate::standardsArn))
            .setter(setter(Builder::standardsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()).build();

    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityControlId").getter(getter(StandardsControlAssociationUpdate::securityControlId))
            .setter(setter(Builder::securityControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationStatus").getter(getter(StandardsControlAssociationUpdate::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()).build();

    private static final SdkField<String> UPDATED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedReason").getter(getter(StandardsControlAssociationUpdate::updatedReason))
            .setter(setter(Builder::updatedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ARN_FIELD,
            SECURITY_CONTROL_ID_FIELD, ASSOCIATION_STATUS_FIELD, UPDATED_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String standardsArn;

    private final String securityControlId;

    private final String associationStatus;

    private final String updatedReason;

    private StandardsControlAssociationUpdate(BuilderImpl builder) {
        this.standardsArn = builder.standardsArn;
        this.securityControlId = builder.securityControlId;
        this.associationStatus = builder.associationStatus;
        this.updatedReason = builder.updatedReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement
     *         status.
     */
    public final String standardsArn() {
        return standardsArn;
    }

    /**
     * <p>
     * The unique identifier for the security control whose enablement status you want to update.
     * </p>
     * 
     * @return The unique identifier for the security control whose enablement status you want to update.
     */
    public final String securityControlId() {
        return securityControlId;
    }

    /**
     * <p>
     * The desired enablement status of the control in the standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link AssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The desired enablement status of the control in the standard.
     * @see AssociationStatus
     */
    public final AssociationStatus associationStatus() {
        return AssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * The desired enablement status of the control in the standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link AssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The desired enablement status of the control in the standard.
     * @see AssociationStatus
     */
    public final String associationStatusAsString() {
        return associationStatus;
    }

    /**
     * <p>
     * The reason for updating the control's enablement status in the standard.
     * </p>
     * 
     * @return The reason for updating the control's enablement status in the standard.
     */
    public final String updatedReason() {
        return updatedReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsControlAssociationUpdate)) {
            return false;
        }
        StandardsControlAssociationUpdate other = (StandardsControlAssociationUpdate) obj;
        return Objects.equals(standardsArn(), other.standardsArn())
                && Objects.equals(securityControlId(), other.securityControlId())
                && Objects.equals(associationStatusAsString(), other.associationStatusAsString())
                && Objects.equals(updatedReason(), other.updatedReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardsControlAssociationUpdate").add("StandardsArn", standardsArn())
                .add("SecurityControlId", securityControlId()).add("AssociationStatus", associationStatusAsString())
                .add("UpdatedReason", updatedReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsArn":
            return Optional.ofNullable(clazz.cast(standardsArn()));
        case "SecurityControlId":
            return Optional.ofNullable(clazz.cast(securityControlId()));
        case "AssociationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        case "UpdatedReason":
            return Optional.ofNullable(clazz.cast(updatedReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StandardsArn", STANDARDS_ARN_FIELD);
        map.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
        map.put("AssociationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("UpdatedReason", UPDATED_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardsControlAssociationUpdate, T> g) {
        return obj -> g.apply((StandardsControlAssociationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardsControlAssociationUpdate> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.
         * </p>
         * 
         * @param standardsArn
         *        The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsArn(String standardsArn);

        /**
         * <p>
         * The unique identifier for the security control whose enablement status you want to update.
         * </p>
         * 
         * @param securityControlId
         *        The unique identifier for the security control whose enablement status you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlId(String securityControlId);

        /**
         * <p>
         * The desired enablement status of the control in the standard.
         * </p>
         * 
         * @param associationStatus
         *        The desired enablement status of the control in the standard.
         * @see AssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The desired enablement status of the control in the standard.
         * </p>
         * 
         * @param associationStatus
         *        The desired enablement status of the control in the standard.
         * @see AssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatus
         */
        Builder associationStatus(AssociationStatus associationStatus);

        /**
         * <p>
         * The reason for updating the control's enablement status in the standard.
         * </p>
         * 
         * @param updatedReason
         *        The reason for updating the control's enablement status in the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedReason(String updatedReason);
    }

    static final class BuilderImpl implements Builder {
        private String standardsArn;

        private String securityControlId;

        private String associationStatus;

        private String updatedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsControlAssociationUpdate model) {
            standardsArn(model.standardsArn);
            securityControlId(model.securityControlId);
            associationStatus(model.associationStatus);
            updatedReason(model.updatedReason);
        }

        public final String getStandardsArn() {
            return standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final String getSecurityControlId() {
            return securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getUpdatedReason() {
            return updatedReason;
        }

        public final void setUpdatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
        }

        @Override
        public final Builder updatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
            return this;
        }

        @Override
        public StandardsControlAssociationUpdate build() {
            return new StandardsControlAssociationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
