/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array with one or more objects that includes a security control (identified with <code>SecurityControlId</code>,
 * <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon Resource Name (ARN) of a standard. The
 * security control ID or ARN is the same across standards.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardsControlAssociationId implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardsControlAssociationId.Builder, StandardsControlAssociationId> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityControlId").getter(getter(StandardsControlAssociationId::securityControlId))
            .setter(setter(Builder::securityControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()).build();

    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsArn").getter(getter(StandardsControlAssociationId::standardsArn))
            .setter(setter(Builder::standardsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD,
            STANDARDS_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String securityControlId;

    private final String standardsArn;

    private StandardsControlAssociationId(BuilderImpl builder) {
        this.securityControlId = builder.securityControlId;
        this.standardsArn = builder.standardsArn;
    }

    /**
     * <p>
     * The unique identifier (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
     * of both parameters) of a security control across standards.
     * </p>
     * 
     * @return The unique identifier (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
     *         or a mix of both parameters) of a security control across standards.
     */
    public final String securityControlId() {
        return securityControlId;
    }

    /**
     * <p>
     * The ARN of a standard.
     * </p>
     * 
     * @return The ARN of a standard.
     */
    public final String standardsArn() {
        return standardsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(standardsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsControlAssociationId)) {
            return false;
        }
        StandardsControlAssociationId other = (StandardsControlAssociationId) obj;
        return Objects.equals(securityControlId(), other.securityControlId())
                && Objects.equals(standardsArn(), other.standardsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardsControlAssociationId").add("SecurityControlId", securityControlId())
                .add("StandardsArn", standardsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControlId":
            return Optional.ofNullable(clazz.cast(securityControlId()));
        case "StandardsArn":
            return Optional.ofNullable(clazz.cast(standardsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
        map.put("StandardsArn", STANDARDS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardsControlAssociationId, T> g) {
        return obj -> g.apply((StandardsControlAssociationId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardsControlAssociationId> {
        /**
         * <p>
         * The unique identifier (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a
         * mix of both parameters) of a security control across standards.
         * </p>
         * 
         * @param securityControlId
         *        The unique identifier (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>
         *        , or a mix of both parameters) of a security control across standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlId(String securityControlId);

        /**
         * <p>
         * The ARN of a standard.
         * </p>
         * 
         * @param standardsArn
         *        The ARN of a standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsArn(String standardsArn);
    }

    static final class BuilderImpl implements Builder {
        private String securityControlId;

        private String standardsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsControlAssociationId model) {
            securityControlId(model.securityControlId);
            standardsArn(model.standardsArn);
        }

        public final String getSecurityControlId() {
            return securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getStandardsArn() {
            return standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        @Override
        public StandardsControlAssociationId build() {
            return new StandardsControlAssociationId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
