/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a ServiceNow ITSM integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNowDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNowDetail.Builder, ServiceNowDetail> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceName").getter(getter(ServiceNowDetail::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceName").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(ServiceNowDetail::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> AUTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthStatus").getter(getter(ServiceNowDetail::authStatusAsString)).setter(setter(Builder::authStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD,
            SECRET_ARN_FIELD, AUTH_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceName;

    private final String secretArn;

    private final String authStatus;

    private ServiceNowDetail(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.secretArn = builder.secretArn;
        this.authStatus = builder.authStatus;
    }

    /**
     * <p>
     * The instanceName of ServiceNow ITSM.
     * </p>
     * 
     * @return The instanceName of ServiceNow ITSM.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the ServiceNow
     * credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the
     *         ServiceNow credentials.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The status of the authorization between ServiceNow and the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authStatus} will
     * return {@link ConnectorAuthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authStatusAsString}.
     * </p>
     * 
     * @return The status of the authorization between ServiceNow and the service.
     * @see ConnectorAuthStatus
     */
    public final ConnectorAuthStatus authStatus() {
        return ConnectorAuthStatus.fromValue(authStatus);
    }

    /**
     * <p>
     * The status of the authorization between ServiceNow and the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authStatus} will
     * return {@link ConnectorAuthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authStatusAsString}.
     * </p>
     * 
     * @return The status of the authorization between ServiceNow and the service.
     * @see ConnectorAuthStatus
     */
    public final String authStatusAsString() {
        return authStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(authStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowDetail)) {
            return false;
        }
        ServiceNowDetail other = (ServiceNowDetail) obj;
        return Objects.equals(instanceName(), other.instanceName()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(authStatusAsString(), other.authStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceNowDetail").add("InstanceName", instanceName()).add("SecretArn", secretArn())
                .add("AuthStatus", authStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "AuthStatus":
            return Optional.ofNullable(clazz.cast(authStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceName", INSTANCE_NAME_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("AuthStatus", AUTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowDetail, T> g) {
        return obj -> g.apply((ServiceNowDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNowDetail> {
        /**
         * <p>
         * The instanceName of ServiceNow ITSM.
         * </p>
         * 
         * @param instanceName
         *        The instanceName of ServiceNow ITSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the ServiceNow
         * credentials.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the
         *        ServiceNow credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The status of the authorization between ServiceNow and the service.
         * </p>
         * 
         * @param authStatus
         *        The status of the authorization between ServiceNow and the service.
         * @see ConnectorAuthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorAuthStatus
         */
        Builder authStatus(String authStatus);

        /**
         * <p>
         * The status of the authorization between ServiceNow and the service.
         * </p>
         * 
         * @param authStatus
         *        The status of the authorization between ServiceNow and the service.
         * @see ConnectorAuthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorAuthStatus
         */
        Builder authStatus(ConnectorAuthStatus authStatus);
    }

    static final class BuilderImpl implements Builder {
        private String instanceName;

        private String secretArn;

        private String authStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowDetail model) {
            instanceName(model.instanceName);
            secretArn(model.secretArn);
            authStatus(model.authStatus);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getAuthStatus() {
            return authStatus;
        }

        public final void setAuthStatus(String authStatus) {
            this.authStatus = authStatus;
        }

        @Override
        public final Builder authStatus(String authStatus) {
            this.authStatus = authStatus;
            return this;
        }

        @Override
        public final Builder authStatus(ConnectorAuthStatus authStatus) {
            this.authStatus(authStatus == null ? null : authStatus.toString());
            return this;
        }

        @Override
        public ServiceNowDetail build() {
            return new ServiceNowDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
