/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines which security controls are enabled in an Security Hub configuration policy. The enablement
 * status of a control is aligned across all of the enabled standards in an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityControlsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityControlsConfiguration.Builder, SecurityControlsConfiguration> {
    private static final SdkField<List<String>> ENABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledSecurityControlIdentifiers")
            .getter(getter(SecurityControlsConfiguration::enabledSecurityControlIdentifiers))
            .setter(setter(Builder::enabledSecurityControlIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledSecurityControlIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DISABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DisabledSecurityControlIdentifiers")
            .getter(getter(SecurityControlsConfiguration::disabledSecurityControlIdentifiers))
            .setter(setter(Builder::disabledSecurityControlIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledSecurityControlIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SecurityControlCustomParameter>> SECURITY_CONTROL_CUSTOM_PARAMETERS_FIELD = SdkField
            .<List<SecurityControlCustomParameter>> builder(MarshallingType.LIST)
            .memberName("SecurityControlCustomParameters")
            .getter(getter(SecurityControlsConfiguration::securityControlCustomParameters))
            .setter(setter(Builder::securityControlCustomParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlCustomParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityControlCustomParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityControlCustomParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD, DISABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD,
            SECURITY_CONTROL_CUSTOM_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> enabledSecurityControlIdentifiers;

    private final List<String> disabledSecurityControlIdentifiers;

    private final List<SecurityControlCustomParameter> securityControlCustomParameters;

    private SecurityControlsConfiguration(BuilderImpl builder) {
        this.enabledSecurityControlIdentifiers = builder.enabledSecurityControlIdentifiers;
        this.disabledSecurityControlIdentifiers = builder.disabledSecurityControlIdentifiers;
        this.securityControlCustomParameters = builder.securityControlCustomParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledSecurityControlIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEnabledSecurityControlIdentifiers() {
        return enabledSecurityControlIdentifiers != null && !(enabledSecurityControlIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security controls that are enabled in the configuration policy. Security Hub disables all other
     * controls (including newly released controls) other than the listed controls.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledSecurityControlIdentifiers}
     * method.
     * </p>
     * 
     * @return A list of security controls that are enabled in the configuration policy. Security Hub disables all other
     *         controls (including newly released controls) other than the listed controls.
     */
    public final List<String> enabledSecurityControlIdentifiers() {
        return enabledSecurityControlIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisabledSecurityControlIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDisabledSecurityControlIdentifiers() {
        return disabledSecurityControlIdentifiers != null
                && !(disabledSecurityControlIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security controls that are disabled in the configuration policy. Security Hub enables all other
     * controls (including newly released controls) other than the listed controls.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisabledSecurityControlIdentifiers}
     * method.
     * </p>
     * 
     * @return A list of security controls that are disabled in the configuration policy. Security Hub enables all other
     *         controls (including newly released controls) other than the listed controls.
     */
    public final List<String> disabledSecurityControlIdentifiers() {
        return disabledSecurityControlIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityControlCustomParameters
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSecurityControlCustomParameters() {
        return securityControlCustomParameters != null && !(securityControlCustomParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security controls and control parameter values that are included in a configuration policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityControlCustomParameters}
     * method.
     * </p>
     * 
     * @return A list of security controls and control parameter values that are included in a configuration policy.
     */
    public final List<SecurityControlCustomParameter> securityControlCustomParameters() {
        return securityControlCustomParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEnabledSecurityControlIdentifiers() ? enabledSecurityControlIdentifiers() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDisabledSecurityControlIdentifiers() ? disabledSecurityControlIdentifiers() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSecurityControlCustomParameters() ? securityControlCustomParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControlsConfiguration)) {
            return false;
        }
        SecurityControlsConfiguration other = (SecurityControlsConfiguration) obj;
        return hasEnabledSecurityControlIdentifiers() == other.hasEnabledSecurityControlIdentifiers()
                && Objects.equals(enabledSecurityControlIdentifiers(), other.enabledSecurityControlIdentifiers())
                && hasDisabledSecurityControlIdentifiers() == other.hasDisabledSecurityControlIdentifiers()
                && Objects.equals(disabledSecurityControlIdentifiers(), other.disabledSecurityControlIdentifiers())
                && hasSecurityControlCustomParameters() == other.hasSecurityControlCustomParameters()
                && Objects.equals(securityControlCustomParameters(), other.securityControlCustomParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SecurityControlsConfiguration")
                .add("EnabledSecurityControlIdentifiers",
                        hasEnabledSecurityControlIdentifiers() ? enabledSecurityControlIdentifiers() : null)
                .add("DisabledSecurityControlIdentifiers",
                        hasDisabledSecurityControlIdentifiers() ? disabledSecurityControlIdentifiers() : null)
                .add("SecurityControlCustomParameters",
                        hasSecurityControlCustomParameters() ? securityControlCustomParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnabledSecurityControlIdentifiers":
            return Optional.ofNullable(clazz.cast(enabledSecurityControlIdentifiers()));
        case "DisabledSecurityControlIdentifiers":
            return Optional.ofNullable(clazz.cast(disabledSecurityControlIdentifiers()));
        case "SecurityControlCustomParameters":
            return Optional.ofNullable(clazz.cast(securityControlCustomParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnabledSecurityControlIdentifiers", ENABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD);
        map.put("DisabledSecurityControlIdentifiers", DISABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD);
        map.put("SecurityControlCustomParameters", SECURITY_CONTROL_CUSTOM_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityControlsConfiguration, T> g) {
        return obj -> g.apply((SecurityControlsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityControlsConfiguration> {
        /**
         * <p>
         * A list of security controls that are enabled in the configuration policy. Security Hub disables all other
         * controls (including newly released controls) other than the listed controls.
         * </p>
         * 
         * @param enabledSecurityControlIdentifiers
         *        A list of security controls that are enabled in the configuration policy. Security Hub disables all
         *        other controls (including newly released controls) other than the listed controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledSecurityControlIdentifiers(Collection<String> enabledSecurityControlIdentifiers);

        /**
         * <p>
         * A list of security controls that are enabled in the configuration policy. Security Hub disables all other
         * controls (including newly released controls) other than the listed controls.
         * </p>
         * 
         * @param enabledSecurityControlIdentifiers
         *        A list of security controls that are enabled in the configuration policy. Security Hub disables all
         *        other controls (including newly released controls) other than the listed controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledSecurityControlIdentifiers(String... enabledSecurityControlIdentifiers);

        /**
         * <p>
         * A list of security controls that are disabled in the configuration policy. Security Hub enables all other
         * controls (including newly released controls) other than the listed controls.
         * </p>
         * 
         * @param disabledSecurityControlIdentifiers
         *        A list of security controls that are disabled in the configuration policy. Security Hub enables all
         *        other controls (including newly released controls) other than the listed controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledSecurityControlIdentifiers(Collection<String> disabledSecurityControlIdentifiers);

        /**
         * <p>
         * A list of security controls that are disabled in the configuration policy. Security Hub enables all other
         * controls (including newly released controls) other than the listed controls.
         * </p>
         * 
         * @param disabledSecurityControlIdentifiers
         *        A list of security controls that are disabled in the configuration policy. Security Hub enables all
         *        other controls (including newly released controls) other than the listed controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledSecurityControlIdentifiers(String... disabledSecurityControlIdentifiers);

        /**
         * <p>
         * A list of security controls and control parameter values that are included in a configuration policy.
         * </p>
         * 
         * @param securityControlCustomParameters
         *        A list of security controls and control parameter values that are included in a configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlCustomParameters(Collection<SecurityControlCustomParameter> securityControlCustomParameters);

        /**
         * <p>
         * A list of security controls and control parameter values that are included in a configuration policy.
         * </p>
         * 
         * @param securityControlCustomParameters
         *        A list of security controls and control parameter values that are included in a configuration policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlCustomParameters(SecurityControlCustomParameter... securityControlCustomParameters);

        /**
         * <p>
         * A list of security controls and control parameter values that are included in a configuration policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControlCustomParameter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControlCustomParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.SecurityControlCustomParameter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #securityControlCustomParameters(List<SecurityControlCustomParameter>)}.
         * 
         * @param securityControlCustomParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.SecurityControlCustomParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityControlCustomParameters(java.util.Collection<SecurityControlCustomParameter>)
         */
        Builder securityControlCustomParameters(
                Consumer<SecurityControlCustomParameter.Builder>... securityControlCustomParameters);
    }

    static final class BuilderImpl implements Builder {
        private List<String> enabledSecurityControlIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> disabledSecurityControlIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<SecurityControlCustomParameter> securityControlCustomParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityControlsConfiguration model) {
            enabledSecurityControlIdentifiers(model.enabledSecurityControlIdentifiers);
            disabledSecurityControlIdentifiers(model.disabledSecurityControlIdentifiers);
            securityControlCustomParameters(model.securityControlCustomParameters);
        }

        public final Collection<String> getEnabledSecurityControlIdentifiers() {
            if (enabledSecurityControlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledSecurityControlIdentifiers;
        }

        public final void setEnabledSecurityControlIdentifiers(Collection<String> enabledSecurityControlIdentifiers) {
            this.enabledSecurityControlIdentifiers = EnabledSecurityControlIdentifierListCopier
                    .copy(enabledSecurityControlIdentifiers);
        }

        @Override
        public final Builder enabledSecurityControlIdentifiers(Collection<String> enabledSecurityControlIdentifiers) {
            this.enabledSecurityControlIdentifiers = EnabledSecurityControlIdentifierListCopier
                    .copy(enabledSecurityControlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledSecurityControlIdentifiers(String... enabledSecurityControlIdentifiers) {
            enabledSecurityControlIdentifiers(Arrays.asList(enabledSecurityControlIdentifiers));
            return this;
        }

        public final Collection<String> getDisabledSecurityControlIdentifiers() {
            if (disabledSecurityControlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return disabledSecurityControlIdentifiers;
        }

        public final void setDisabledSecurityControlIdentifiers(Collection<String> disabledSecurityControlIdentifiers) {
            this.disabledSecurityControlIdentifiers = DisabledSecurityControlIdentifierListCopier
                    .copy(disabledSecurityControlIdentifiers);
        }

        @Override
        public final Builder disabledSecurityControlIdentifiers(Collection<String> disabledSecurityControlIdentifiers) {
            this.disabledSecurityControlIdentifiers = DisabledSecurityControlIdentifierListCopier
                    .copy(disabledSecurityControlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disabledSecurityControlIdentifiers(String... disabledSecurityControlIdentifiers) {
            disabledSecurityControlIdentifiers(Arrays.asList(disabledSecurityControlIdentifiers));
            return this;
        }

        public final List<SecurityControlCustomParameter.Builder> getSecurityControlCustomParameters() {
            List<SecurityControlCustomParameter.Builder> result = SecurityControlCustomParametersListCopier
                    .copyToBuilder(this.securityControlCustomParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityControlCustomParameters(
                Collection<SecurityControlCustomParameter.BuilderImpl> securityControlCustomParameters) {
            this.securityControlCustomParameters = SecurityControlCustomParametersListCopier
                    .copyFromBuilder(securityControlCustomParameters);
        }

        @Override
        public final Builder securityControlCustomParameters(
                Collection<SecurityControlCustomParameter> securityControlCustomParameters) {
            this.securityControlCustomParameters = SecurityControlCustomParametersListCopier
                    .copy(securityControlCustomParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlCustomParameters(SecurityControlCustomParameter... securityControlCustomParameters) {
            securityControlCustomParameters(Arrays.asList(securityControlCustomParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlCustomParameters(
                Consumer<SecurityControlCustomParameter.Builder>... securityControlCustomParameters) {
            securityControlCustomParameters(Stream.of(securityControlCustomParameters)
                    .map(c -> SecurityControlCustomParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SecurityControlsConfiguration build() {
            return new SecurityControlsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
