/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional settings to use in the specified rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupVariables implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupVariables.Builder, RuleGroupVariables> {
    private static final SdkField<RuleGroupVariablesIpSetsDetails> IP_SETS_FIELD = SdkField
            .<RuleGroupVariablesIpSetsDetails> builder(MarshallingType.SDK_POJO).memberName("IpSets")
            .getter(getter(RuleGroupVariables::ipSets)).setter(setter(Builder::ipSets))
            .constructor(RuleGroupVariablesIpSetsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpSets").build()).build();

    private static final SdkField<RuleGroupVariablesPortSetsDetails> PORT_SETS_FIELD = SdkField
            .<RuleGroupVariablesPortSetsDetails> builder(MarshallingType.SDK_POJO).memberName("PortSets")
            .getter(getter(RuleGroupVariables::portSets)).setter(setter(Builder::portSets))
            .constructor(RuleGroupVariablesPortSetsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortSets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IP_SETS_FIELD, PORT_SETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RuleGroupVariablesIpSetsDetails ipSets;

    private final RuleGroupVariablesPortSetsDetails portSets;

    private RuleGroupVariables(BuilderImpl builder) {
        this.ipSets = builder.ipSets;
        this.portSets = builder.portSets;
    }

    /**
     * <p>
     * A list of IP addresses and address ranges, in CIDR notation.
     * </p>
     * 
     * @return A list of IP addresses and address ranges, in CIDR notation.
     */
    public final RuleGroupVariablesIpSetsDetails ipSets() {
        return ipSets;
    }

    /**
     * <p>
     * A list of port ranges.
     * </p>
     * 
     * @return A list of port ranges.
     */
    public final RuleGroupVariablesPortSetsDetails portSets() {
        return portSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipSets());
        hashCode = 31 * hashCode + Objects.hashCode(portSets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupVariables)) {
            return false;
        }
        RuleGroupVariables other = (RuleGroupVariables) obj;
        return Objects.equals(ipSets(), other.ipSets()) && Objects.equals(portSets(), other.portSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupVariables").add("IpSets", ipSets()).add("PortSets", portSets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpSets":
            return Optional.ofNullable(clazz.cast(ipSets()));
        case "PortSets":
            return Optional.ofNullable(clazz.cast(portSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpSets", IP_SETS_FIELD);
        map.put("PortSets", PORT_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupVariables, T> g) {
        return obj -> g.apply((RuleGroupVariables) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupVariables> {
        /**
         * <p>
         * A list of IP addresses and address ranges, in CIDR notation.
         * </p>
         * 
         * @param ipSets
         *        A list of IP addresses and address ranges, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(RuleGroupVariablesIpSetsDetails ipSets);

        /**
         * <p>
         * A list of IP addresses and address ranges, in CIDR notation.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroupVariablesIpSetsDetails.Builder}
         * avoiding the need to create one manually via {@link RuleGroupVariablesIpSetsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupVariablesIpSetsDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #ipSets(RuleGroupVariablesIpSetsDetails)}.
         * 
         * @param ipSets
         *        a consumer that will call methods on {@link RuleGroupVariablesIpSetsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSets(RuleGroupVariablesIpSetsDetails)
         */
        default Builder ipSets(Consumer<RuleGroupVariablesIpSetsDetails.Builder> ipSets) {
            return ipSets(RuleGroupVariablesIpSetsDetails.builder().applyMutation(ipSets).build());
        }

        /**
         * <p>
         * A list of port ranges.
         * </p>
         * 
         * @param portSets
         *        A list of port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portSets(RuleGroupVariablesPortSetsDetails portSets);

        /**
         * <p>
         * A list of port ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RuleGroupVariablesPortSetsDetails.Builder} avoiding the need to create one manually via
         * {@link RuleGroupVariablesPortSetsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupVariablesPortSetsDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #portSets(RuleGroupVariablesPortSetsDetails)}.
         * 
         * @param portSets
         *        a consumer that will call methods on {@link RuleGroupVariablesPortSetsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portSets(RuleGroupVariablesPortSetsDetails)
         */
        default Builder portSets(Consumer<RuleGroupVariablesPortSetsDetails.Builder> portSets) {
            return portSets(RuleGroupVariablesPortSetsDetails.builder().applyMutation(portSets).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuleGroupVariablesIpSetsDetails ipSets;

        private RuleGroupVariablesPortSetsDetails portSets;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupVariables model) {
            ipSets(model.ipSets);
            portSets(model.portSets);
        }

        public final RuleGroupVariablesIpSetsDetails.Builder getIpSets() {
            return ipSets != null ? ipSets.toBuilder() : null;
        }

        public final void setIpSets(RuleGroupVariablesIpSetsDetails.BuilderImpl ipSets) {
            this.ipSets = ipSets != null ? ipSets.build() : null;
        }

        @Override
        public final Builder ipSets(RuleGroupVariablesIpSetsDetails ipSets) {
            this.ipSets = ipSets;
            return this;
        }

        public final RuleGroupVariablesPortSetsDetails.Builder getPortSets() {
            return portSets != null ? portSets.toBuilder() : null;
        }

        public final void setPortSets(RuleGroupVariablesPortSetsDetails.BuilderImpl portSets) {
            this.portSets = portSets != null ? portSets.build() : null;
        }

        @Override
        public final Builder portSets(RuleGroupVariablesPortSetsDetails portSets) {
            this.portSets = portSets;
            return this;
        }

        @Override
        public RuleGroupVariables build() {
            return new RuleGroupVariables(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
