/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the aggregated resource count values for a specific point in the resources trend timeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcesTrendsValues implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcesTrendsValues.Builder, ResourcesTrendsValues> {
    private static final SdkField<ResourcesCount> RESOURCES_COUNT_FIELD = SdkField
            .<ResourcesCount> builder(MarshallingType.SDK_POJO).memberName("ResourcesCount")
            .getter(getter(ResourcesTrendsValues::resourcesCount)).setter(setter(Builder::resourcesCount))
            .constructor(ResourcesCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResourcesCount resourcesCount;

    private ResourcesTrendsValues(BuilderImpl builder) {
        this.resourcesCount = builder.resourcesCount;
    }

    /**
     * <p>
     * The resource count statistics for this data point in the trend timeline.
     * </p>
     * 
     * @return The resource count statistics for this data point in the trend timeline.
     */
    public final ResourcesCount resourcesCount() {
        return resourcesCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourcesCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesTrendsValues)) {
            return false;
        }
        ResourcesTrendsValues other = (ResourcesTrendsValues) obj;
        return Objects.equals(resourcesCount(), other.resourcesCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcesTrendsValues").add("ResourcesCount", resourcesCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourcesCount":
            return Optional.ofNullable(clazz.cast(resourcesCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourcesCount", RESOURCES_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesTrendsValues, T> g) {
        return obj -> g.apply((ResourcesTrendsValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcesTrendsValues> {
        /**
         * <p>
         * The resource count statistics for this data point in the trend timeline.
         * </p>
         * 
         * @param resourcesCount
         *        The resource count statistics for this data point in the trend timeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesCount(ResourcesCount resourcesCount);

        /**
         * <p>
         * The resource count statistics for this data point in the trend timeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcesCount.Builder} avoiding the need
         * to create one manually via {@link ResourcesCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourcesCount.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcesCount(ResourcesCount)}.
         * 
         * @param resourcesCount
         *        a consumer that will call methods on {@link ResourcesCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesCount(ResourcesCount)
         */
        default Builder resourcesCount(Consumer<ResourcesCount.Builder> resourcesCount) {
            return resourcesCount(ResourcesCount.builder().applyMutation(resourcesCount).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourcesCount resourcesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesTrendsValues model) {
            resourcesCount(model.resourcesCount);
        }

        public final ResourcesCount.Builder getResourcesCount() {
            return resourcesCount != null ? resourcesCount.toBuilder() : null;
        }

        public final void setResourcesCount(ResourcesCount.BuilderImpl resourcesCount) {
            this.resourcesCount = resourcesCount != null ? resourcesCount.build() : null;
        }

        @Override
        public final Builder resourcesCount(ResourcesCount resourcesCount) {
            this.resourcesCount = resourcesCount;
            return this;
        }

        @Override
        public ResourcesTrendsValues build() {
            return new ResourcesTrendsValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
