/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains counts of resources for trend analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcesCount implements SdkPojo, Serializable, ToCopyableBuilder<ResourcesCount.Builder, ResourcesCount> {
    private static final SdkField<Long> ALL_RESOURCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AllResources").getter(getter(ResourcesCount::allResources)).setter(setter(Builder::allResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllResources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long allResources;

    private ResourcesCount(BuilderImpl builder) {
        this.allResources = builder.allResources;
    }

    /**
     * <p>
     * The total count of all resources for the given time interval.
     * </p>
     * 
     * @return The total count of all resources for the given time interval.
     */
    public final Long allResources() {
        return allResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesCount)) {
            return false;
        }
        ResourcesCount other = (ResourcesCount) obj;
        return Objects.equals(allResources(), other.allResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcesCount").add("AllResources", allResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllResources":
            return Optional.ofNullable(clazz.cast(allResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllResources", ALL_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesCount, T> g) {
        return obj -> g.apply((ResourcesCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcesCount> {
        /**
         * <p>
         * The total count of all resources for the given time interval.
         * </p>
         * 
         * @param allResources
         *        The total count of all resources for the given time interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allResources(Long allResources);
    }

    static final class BuilderImpl implements Builder {
        private Long allResources;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesCount model) {
            allResources(model.allResources);
        }

        public final Long getAllResources() {
            return allResources;
        }

        public final void setAllResources(Long allResources) {
            this.allResources = allResources;
        }

        @Override
        public final Builder allResources(Long allResources) {
            this.allResources = allResources;
            return this;
        }

        @Override
        public ResourcesCount build() {
            return new ResourcesCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
