/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables the creation of criteria for Amazon Web Services resources in Security Hub.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcesCompositeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcesCompositeFilter.Builder, ResourcesCompositeFilter> {
    private static final SdkField<List<ResourcesStringFilter>> STRING_FILTERS_FIELD = SdkField
            .<List<ResourcesStringFilter>> builder(MarshallingType.LIST)
            .memberName("StringFilters")
            .getter(getter(ResourcesCompositeFilter::stringFilters))
            .setter(setter(Builder::stringFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcesStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcesStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourcesDateFilter>> DATE_FILTERS_FIELD = SdkField
            .<List<ResourcesDateFilter>> builder(MarshallingType.LIST)
            .memberName("DateFilters")
            .getter(getter(ResourcesCompositeFilter::dateFilters))
            .setter(setter(Builder::dateFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcesDateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcesDateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourcesNumberFilter>> NUMBER_FILTERS_FIELD = SdkField
            .<List<ResourcesNumberFilter>> builder(MarshallingType.LIST)
            .memberName("NumberFilters")
            .getter(getter(ResourcesCompositeFilter::numberFilters))
            .setter(setter(Builder::numberFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcesNumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcesNumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourcesMapFilter>> MAP_FILTERS_FIELD = SdkField
            .<List<ResourcesMapFilter>> builder(MarshallingType.LIST)
            .memberName("MapFilters")
            .getter(getter(ResourcesCompositeFilter::mapFilters))
            .setter(setter(Builder::mapFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcesMapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcesMapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourcesCompositeFilter>> NESTED_COMPOSITE_FILTERS_FIELD = SdkField
            .<List<ResourcesCompositeFilter>> builder(MarshallingType.LIST)
            .memberName("NestedCompositeFilters")
            .getter(getter(ResourcesCompositeFilter::nestedCompositeFilters))
            .setter(setter(Builder::nestedCompositeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedCompositeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcesCompositeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcesCompositeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(ResourcesCompositeFilter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_FILTERS_FIELD,
            DATE_FILTERS_FIELD, NUMBER_FILTERS_FIELD, MAP_FILTERS_FIELD, NESTED_COMPOSITE_FILTERS_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ResourcesStringFilter> stringFilters;

    private final List<ResourcesDateFilter> dateFilters;

    private final List<ResourcesNumberFilter> numberFilters;

    private final List<ResourcesMapFilter> mapFilters;

    private final List<ResourcesCompositeFilter> nestedCompositeFilters;

    private final String operator;

    private ResourcesCompositeFilter(BuilderImpl builder) {
        this.stringFilters = builder.stringFilters;
        this.dateFilters = builder.dateFilters;
        this.numberFilters = builder.numberFilters;
        this.mapFilters = builder.mapFilters;
        this.nestedCompositeFilters = builder.nestedCompositeFilters;
        this.operator = builder.operator;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringFilters() {
        return stringFilters != null && !(stringFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on string field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringFilters} method.
     * </p>
     * 
     * @return Enables filtering based on string field values.
     */
    public final List<ResourcesStringFilter> stringFilters() {
        return stringFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the DateFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDateFilters() {
        return dateFilters != null && !(dateFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on date and timestamp field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDateFilters} method.
     * </p>
     * 
     * @return Enables filtering based on date and timestamp field values.
     */
    public final List<ResourcesDateFilter> dateFilters() {
        return dateFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NumberFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNumberFilters() {
        return numberFilters != null && !(numberFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on numerical field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberFilters} method.
     * </p>
     * 
     * @return Enables filtering based on numerical field values.
     */
    public final List<ResourcesNumberFilter> numberFilters() {
        return numberFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapFilters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapFilters() {
        return mapFilters != null && !(mapFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables filtering based on map-based field values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapFilters} method.
     * </p>
     * 
     * @return Enables filtering based on map-based field values.
     */
    public final List<ResourcesMapFilter> mapFilters() {
        return mapFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NestedCompositeFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNestedCompositeFilters() {
        return nestedCompositeFilters != null && !(nestedCompositeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
     * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>). The
     * second layer is a <code>CompositeFilter</code> object that contains direct filters and
     * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
     * additional filter conditions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNestedCompositeFilters} method.
     * </p>
     * 
     * @return Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
     *         <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/
     *         <code>OR</code>). The second layer is a <code>CompositeFilter</code> object that contains direct filters
     *         and <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which
     *         contains additional filter conditions.
     */
    public final List<ResourcesCompositeFilter> nestedCompositeFilters() {
        return nestedCompositeFilters;
    }

    /**
     * <p>
     * The logical operator used to combine multiple filter conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The logical operator used to combine multiple filter conditions.
     * @see AllowedOperators
     */
    public final AllowedOperators operator() {
        return AllowedOperators.fromValue(operator);
    }

    /**
     * <p>
     * The logical operator used to combine multiple filter conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link AllowedOperators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The logical operator used to combine multiple filter conditions.
     * @see AllowedOperators
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringFilters() ? stringFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDateFilters() ? dateFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNumberFilters() ? numberFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMapFilters() ? mapFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNestedCompositeFilters() ? nestedCompositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesCompositeFilter)) {
            return false;
        }
        ResourcesCompositeFilter other = (ResourcesCompositeFilter) obj;
        return hasStringFilters() == other.hasStringFilters() && Objects.equals(stringFilters(), other.stringFilters())
                && hasDateFilters() == other.hasDateFilters() && Objects.equals(dateFilters(), other.dateFilters())
                && hasNumberFilters() == other.hasNumberFilters() && Objects.equals(numberFilters(), other.numberFilters())
                && hasMapFilters() == other.hasMapFilters() && Objects.equals(mapFilters(), other.mapFilters())
                && hasNestedCompositeFilters() == other.hasNestedCompositeFilters()
                && Objects.equals(nestedCompositeFilters(), other.nestedCompositeFilters())
                && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcesCompositeFilter").add("StringFilters", hasStringFilters() ? stringFilters() : null)
                .add("DateFilters", hasDateFilters() ? dateFilters() : null)
                .add("NumberFilters", hasNumberFilters() ? numberFilters() : null)
                .add("MapFilters", hasMapFilters() ? mapFilters() : null)
                .add("NestedCompositeFilters", hasNestedCompositeFilters() ? nestedCompositeFilters() : null)
                .add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringFilters":
            return Optional.ofNullable(clazz.cast(stringFilters()));
        case "DateFilters":
            return Optional.ofNullable(clazz.cast(dateFilters()));
        case "NumberFilters":
            return Optional.ofNullable(clazz.cast(numberFilters()));
        case "MapFilters":
            return Optional.ofNullable(clazz.cast(mapFilters()));
        case "NestedCompositeFilters":
            return Optional.ofNullable(clazz.cast(nestedCompositeFilters()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringFilters", STRING_FILTERS_FIELD);
        map.put("DateFilters", DATE_FILTERS_FIELD);
        map.put("NumberFilters", NUMBER_FILTERS_FIELD);
        map.put("MapFilters", MAP_FILTERS_FIELD);
        map.put("NestedCompositeFilters", NESTED_COMPOSITE_FILTERS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesCompositeFilter, T> g) {
        return obj -> g.apply((ResourcesCompositeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcesCompositeFilter> {
        /**
         * <p>
         * Enables filtering based on string field values.
         * </p>
         * 
         * @param stringFilters
         *        Enables filtering based on string field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilters(Collection<ResourcesStringFilter> stringFilters);

        /**
         * <p>
         * Enables filtering based on string field values.
         * </p>
         * 
         * @param stringFilters
         *        Enables filtering based on string field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilters(ResourcesStringFilter... stringFilters);

        /**
         * <p>
         * Enables filtering based on string field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #stringFilters(List<ResourcesStringFilter>)}.
         * 
         * @param stringFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourcesStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringFilters(java.util.Collection<ResourcesStringFilter>)
         */
        Builder stringFilters(Consumer<ResourcesStringFilter.Builder>... stringFilters);

        /**
         * <p>
         * Enables filtering based on date and timestamp field values.
         * </p>
         * 
         * @param dateFilters
         *        Enables filtering based on date and timestamp field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFilters(Collection<ResourcesDateFilter> dateFilters);

        /**
         * <p>
         * Enables filtering based on date and timestamp field values.
         * </p>
         * 
         * @param dateFilters
         *        Enables filtering based on date and timestamp field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFilters(ResourcesDateFilter... dateFilters);

        /**
         * <p>
         * Enables filtering based on date and timestamp field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesDateFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #dateFilters(List<ResourcesDateFilter>)}.
         * 
         * @param dateFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourcesDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateFilters(java.util.Collection<ResourcesDateFilter>)
         */
        Builder dateFilters(Consumer<ResourcesDateFilter.Builder>... dateFilters);

        /**
         * <p>
         * Enables filtering based on numerical field values.
         * </p>
         * 
         * @param numberFilters
         *        Enables filtering based on numerical field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberFilters(Collection<ResourcesNumberFilter> numberFilters);

        /**
         * <p>
         * Enables filtering based on numerical field values.
         * </p>
         * 
         * @param numberFilters
         *        Enables filtering based on numerical field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberFilters(ResourcesNumberFilter... numberFilters);

        /**
         * <p>
         * Enables filtering based on numerical field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesNumberFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesNumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesNumberFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #numberFilters(List<ResourcesNumberFilter>)}.
         * 
         * @param numberFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourcesNumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberFilters(java.util.Collection<ResourcesNumberFilter>)
         */
        Builder numberFilters(Consumer<ResourcesNumberFilter.Builder>... numberFilters);

        /**
         * <p>
         * Enables filtering based on map-based field values.
         * </p>
         * 
         * @param mapFilters
         *        Enables filtering based on map-based field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapFilters(Collection<ResourcesMapFilter> mapFilters);

        /**
         * <p>
         * Enables filtering based on map-based field values.
         * </p>
         * 
         * @param mapFilters
         *        Enables filtering based on map-based field values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapFilters(ResourcesMapFilter... mapFilters);

        /**
         * <p>
         * Enables filtering based on map-based field values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesMapFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesMapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesMapFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #mapFilters(List<ResourcesMapFilter>)}.
         * 
         * @param mapFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourcesMapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapFilters(java.util.Collection<ResourcesMapFilter>)
         */
        Builder mapFilters(Consumer<ResourcesMapFilter.Builder>... mapFilters);

        /**
         * <p>
         * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
         * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>).
         * The second layer is a <code>CompositeFilter</code> object that contains direct filters and
         * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
         * additional filter conditions.
         * </p>
         * 
         * @param nestedCompositeFilters
         *        Provides an additional level of filtering, creating a three-layer nested structure. The first layer is
         *        a <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/
         *        <code>OR</code>). The second layer is a <code>CompositeFilter</code> object that contains direct
         *        filters and <code>NestedCompositeFilters</code>. The third layer is
         *        <code>NestedCompositeFilters</code>, which contains additional filter conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedCompositeFilters(Collection<ResourcesCompositeFilter> nestedCompositeFilters);

        /**
         * <p>
         * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
         * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>).
         * The second layer is a <code>CompositeFilter</code> object that contains direct filters and
         * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
         * additional filter conditions.
         * </p>
         * 
         * @param nestedCompositeFilters
         *        Provides an additional level of filtering, creating a three-layer nested structure. The first layer is
         *        a <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/
         *        <code>OR</code>). The second layer is a <code>CompositeFilter</code> object that contains direct
         *        filters and <code>NestedCompositeFilters</code>. The third layer is
         *        <code>NestedCompositeFilters</code>, which contains additional filter conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedCompositeFilters(ResourcesCompositeFilter... nestedCompositeFilters);

        /**
         * <p>
         * Provides an additional level of filtering, creating a three-layer nested structure. The first layer is a
         * <code>CompositeFilters</code> array with a <code>CompositeOperator</code> (<code>AND</code>/<code>OR</code>).
         * The second layer is a <code>CompositeFilter</code> object that contains direct filters and
         * <code>NestedCompositeFilters</code>. The third layer is <code>NestedCompositeFilters</code>, which contains
         * additional filter conditions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesCompositeFilter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesCompositeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.ResourcesCompositeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #nestedCompositeFilters(List<ResourcesCompositeFilter>)}.
         * 
         * @param nestedCompositeFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.ResourcesCompositeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nestedCompositeFilters(java.util.Collection<ResourcesCompositeFilter>)
         */
        Builder nestedCompositeFilters(Consumer<Builder>... nestedCompositeFilters);

        /**
         * <p>
         * The logical operator used to combine multiple filter conditions.
         * </p>
         * 
         * @param operator
         *        The logical operator used to combine multiple filter conditions.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder operator(String operator);

        /**
         * <p>
         * The logical operator used to combine multiple filter conditions.
         * </p>
         * 
         * @param operator
         *        The logical operator used to combine multiple filter conditions.
         * @see AllowedOperators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedOperators
         */
        Builder operator(AllowedOperators operator);
    }

    static final class BuilderImpl implements Builder {
        private List<ResourcesStringFilter> stringFilters = DefaultSdkAutoConstructList.getInstance();

        private List<ResourcesDateFilter> dateFilters = DefaultSdkAutoConstructList.getInstance();

        private List<ResourcesNumberFilter> numberFilters = DefaultSdkAutoConstructList.getInstance();

        private List<ResourcesMapFilter> mapFilters = DefaultSdkAutoConstructList.getInstance();

        private List<ResourcesCompositeFilter> nestedCompositeFilters = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesCompositeFilter model) {
            stringFilters(model.stringFilters);
            dateFilters(model.dateFilters);
            numberFilters(model.numberFilters);
            mapFilters(model.mapFilters);
            nestedCompositeFilters(model.nestedCompositeFilters);
            operator(model.operator);
        }

        public final List<ResourcesStringFilter.Builder> getStringFilters() {
            List<ResourcesStringFilter.Builder> result = ResourcesStringFilterListCopier.copyToBuilder(this.stringFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringFilters(Collection<ResourcesStringFilter.BuilderImpl> stringFilters) {
            this.stringFilters = ResourcesStringFilterListCopier.copyFromBuilder(stringFilters);
        }

        @Override
        public final Builder stringFilters(Collection<ResourcesStringFilter> stringFilters) {
            this.stringFilters = ResourcesStringFilterListCopier.copy(stringFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(ResourcesStringFilter... stringFilters) {
            stringFilters(Arrays.asList(stringFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(Consumer<ResourcesStringFilter.Builder>... stringFilters) {
            stringFilters(Stream.of(stringFilters).map(c -> ResourcesStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcesDateFilter.Builder> getDateFilters() {
            List<ResourcesDateFilter.Builder> result = ResourcesDateFilterListCopier.copyToBuilder(this.dateFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDateFilters(Collection<ResourcesDateFilter.BuilderImpl> dateFilters) {
            this.dateFilters = ResourcesDateFilterListCopier.copyFromBuilder(dateFilters);
        }

        @Override
        public final Builder dateFilters(Collection<ResourcesDateFilter> dateFilters) {
            this.dateFilters = ResourcesDateFilterListCopier.copy(dateFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(ResourcesDateFilter... dateFilters) {
            dateFilters(Arrays.asList(dateFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(Consumer<ResourcesDateFilter.Builder>... dateFilters) {
            dateFilters(Stream.of(dateFilters).map(c -> ResourcesDateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcesNumberFilter.Builder> getNumberFilters() {
            List<ResourcesNumberFilter.Builder> result = ResourcesNumberFilterListCopier.copyToBuilder(this.numberFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNumberFilters(Collection<ResourcesNumberFilter.BuilderImpl> numberFilters) {
            this.numberFilters = ResourcesNumberFilterListCopier.copyFromBuilder(numberFilters);
        }

        @Override
        public final Builder numberFilters(Collection<ResourcesNumberFilter> numberFilters) {
            this.numberFilters = ResourcesNumberFilterListCopier.copy(numberFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(ResourcesNumberFilter... numberFilters) {
            numberFilters(Arrays.asList(numberFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(Consumer<ResourcesNumberFilter.Builder>... numberFilters) {
            numberFilters(Stream.of(numberFilters).map(c -> ResourcesNumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcesMapFilter.Builder> getMapFilters() {
            List<ResourcesMapFilter.Builder> result = ResourcesMapFilterListCopier.copyToBuilder(this.mapFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapFilters(Collection<ResourcesMapFilter.BuilderImpl> mapFilters) {
            this.mapFilters = ResourcesMapFilterListCopier.copyFromBuilder(mapFilters);
        }

        @Override
        public final Builder mapFilters(Collection<ResourcesMapFilter> mapFilters) {
            this.mapFilters = ResourcesMapFilterListCopier.copy(mapFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(ResourcesMapFilter... mapFilters) {
            mapFilters(Arrays.asList(mapFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(Consumer<ResourcesMapFilter.Builder>... mapFilters) {
            mapFilters(Stream.of(mapFilters).map(c -> ResourcesMapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getNestedCompositeFilters() {
            List<Builder> result = ResourcesCompositeFilterListCopier.copyToBuilder(this.nestedCompositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNestedCompositeFilters(Collection<BuilderImpl> nestedCompositeFilters) {
            this.nestedCompositeFilters = ResourcesCompositeFilterListCopier.copyFromBuilder(nestedCompositeFilters);
        }

        @Override
        public final Builder nestedCompositeFilters(Collection<ResourcesCompositeFilter> nestedCompositeFilters) {
            this.nestedCompositeFilters = ResourcesCompositeFilterListCopier.copy(nestedCompositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(ResourcesCompositeFilter... nestedCompositeFilters) {
            nestedCompositeFilters(Arrays.asList(nestedCompositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(Consumer<Builder>... nestedCompositeFilters) {
            nestedCompositeFilters(Stream.of(nestedCompositeFilters)
                    .map(c -> ResourcesCompositeFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AllowedOperators operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public ResourcesCompositeFilter build() {
            return new ResourcesCompositeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
