/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A comprehensive distribution of security findings by severity level for Amazon Web Services resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSeverityBreakdown implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSeverityBreakdown.Builder, ResourceSeverityBreakdown> {
    private static final SdkField<Integer> OTHER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Other")
            .getter(getter(ResourceSeverityBreakdown::other)).setter(setter(Builder::other))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build()).build();

    private static final SdkField<Integer> FATAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Fatal")
            .getter(getter(ResourceSeverityBreakdown::fatal)).setter(setter(Builder::fatal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fatal").build()).build();

    private static final SdkField<Integer> CRITICAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Critical").getter(getter(ResourceSeverityBreakdown::critical)).setter(setter(Builder::critical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()).build();

    private static final SdkField<Integer> HIGH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("High")
            .getter(getter(ResourceSeverityBreakdown::high)).setter(setter(Builder::high))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("High").build()).build();

    private static final SdkField<Integer> MEDIUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Medium").getter(getter(ResourceSeverityBreakdown::medium)).setter(setter(Builder::medium))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Medium").build()).build();

    private static final SdkField<Integer> LOW_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Low")
            .getter(getter(ResourceSeverityBreakdown::low)).setter(setter(Builder::low))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Low").build()).build();

    private static final SdkField<Integer> INFORMATIONAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Informational").getter(getter(ResourceSeverityBreakdown::informational))
            .setter(setter(Builder::informational))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Informational").build()).build();

    private static final SdkField<Integer> UNKNOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Unknown").getter(getter(ResourceSeverityBreakdown::unknown)).setter(setter(Builder::unknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unknown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTHER_FIELD, FATAL_FIELD,
            CRITICAL_FIELD, HIGH_FIELD, MEDIUM_FIELD, LOW_FIELD, INFORMATIONAL_FIELD, UNKNOWN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer other;

    private final Integer fatal;

    private final Integer critical;

    private final Integer high;

    private final Integer medium;

    private final Integer low;

    private final Integer informational;

    private final Integer unknown;

    private ResourceSeverityBreakdown(BuilderImpl builder) {
        this.other = builder.other;
        this.fatal = builder.fatal;
        this.critical = builder.critical;
        this.high = builder.high;
        this.medium = builder.medium;
        this.low = builder.low;
        this.informational = builder.informational;
        this.unknown = builder.unknown;
    }

    /**
     * <p>
     * The number of findings not in any of the severity categories.
     * </p>
     * 
     * @return The number of findings not in any of the severity categories.
     */
    public final Integer other() {
        return other;
    }

    /**
     * <p>
     * The number of findings with a severity level of fatal.
     * </p>
     * 
     * @return The number of findings with a severity level of fatal.
     */
    public final Integer fatal() {
        return fatal;
    }

    /**
     * <p>
     * The number of findings with a severity level of critical.
     * </p>
     * 
     * @return The number of findings with a severity level of critical.
     */
    public final Integer critical() {
        return critical;
    }

    /**
     * <p>
     * The number of findings with a severity level of high.
     * </p>
     * 
     * @return The number of findings with a severity level of high.
     */
    public final Integer high() {
        return high;
    }

    /**
     * <p>
     * The number of findings with a severity level of medium.
     * </p>
     * 
     * @return The number of findings with a severity level of medium.
     */
    public final Integer medium() {
        return medium;
    }

    /**
     * <p>
     * The number of findings with a severity level of low.
     * </p>
     * 
     * @return The number of findings with a severity level of low.
     */
    public final Integer low() {
        return low;
    }

    /**
     * <p>
     * The number of findings that provide security-related information.
     * </p>
     * 
     * @return The number of findings that provide security-related information.
     */
    public final Integer informational() {
        return informational;
    }

    /**
     * <p>
     * The number of findings with a severity level cannot be determined.
     * </p>
     * 
     * @return The number of findings with a severity level cannot be determined.
     */
    public final Integer unknown() {
        return unknown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(other());
        hashCode = 31 * hashCode + Objects.hashCode(fatal());
        hashCode = 31 * hashCode + Objects.hashCode(critical());
        hashCode = 31 * hashCode + Objects.hashCode(high());
        hashCode = 31 * hashCode + Objects.hashCode(medium());
        hashCode = 31 * hashCode + Objects.hashCode(low());
        hashCode = 31 * hashCode + Objects.hashCode(informational());
        hashCode = 31 * hashCode + Objects.hashCode(unknown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSeverityBreakdown)) {
            return false;
        }
        ResourceSeverityBreakdown other = (ResourceSeverityBreakdown) obj;
        return Objects.equals(other(), other.other()) && Objects.equals(fatal(), other.fatal())
                && Objects.equals(critical(), other.critical()) && Objects.equals(high(), other.high())
                && Objects.equals(medium(), other.medium()) && Objects.equals(low(), other.low())
                && Objects.equals(informational(), other.informational()) && Objects.equals(unknown(), other.unknown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSeverityBreakdown").add("Other", other()).add("Fatal", fatal())
                .add("Critical", critical()).add("High", high()).add("Medium", medium()).add("Low", low())
                .add("Informational", informational()).add("Unknown", unknown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Other":
            return Optional.ofNullable(clazz.cast(other()));
        case "Fatal":
            return Optional.ofNullable(clazz.cast(fatal()));
        case "Critical":
            return Optional.ofNullable(clazz.cast(critical()));
        case "High":
            return Optional.ofNullable(clazz.cast(high()));
        case "Medium":
            return Optional.ofNullable(clazz.cast(medium()));
        case "Low":
            return Optional.ofNullable(clazz.cast(low()));
        case "Informational":
            return Optional.ofNullable(clazz.cast(informational()));
        case "Unknown":
            return Optional.ofNullable(clazz.cast(unknown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Other", OTHER_FIELD);
        map.put("Fatal", FATAL_FIELD);
        map.put("Critical", CRITICAL_FIELD);
        map.put("High", HIGH_FIELD);
        map.put("Medium", MEDIUM_FIELD);
        map.put("Low", LOW_FIELD);
        map.put("Informational", INFORMATIONAL_FIELD);
        map.put("Unknown", UNKNOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSeverityBreakdown, T> g) {
        return obj -> g.apply((ResourceSeverityBreakdown) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSeverityBreakdown> {
        /**
         * <p>
         * The number of findings not in any of the severity categories.
         * </p>
         * 
         * @param other
         *        The number of findings not in any of the severity categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder other(Integer other);

        /**
         * <p>
         * The number of findings with a severity level of fatal.
         * </p>
         * 
         * @param fatal
         *        The number of findings with a severity level of fatal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fatal(Integer fatal);

        /**
         * <p>
         * The number of findings with a severity level of critical.
         * </p>
         * 
         * @param critical
         *        The number of findings with a severity level of critical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder critical(Integer critical);

        /**
         * <p>
         * The number of findings with a severity level of high.
         * </p>
         * 
         * @param high
         *        The number of findings with a severity level of high.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder high(Integer high);

        /**
         * <p>
         * The number of findings with a severity level of medium.
         * </p>
         * 
         * @param medium
         *        The number of findings with a severity level of medium.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medium(Integer medium);

        /**
         * <p>
         * The number of findings with a severity level of low.
         * </p>
         * 
         * @param low
         *        The number of findings with a severity level of low.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder low(Integer low);

        /**
         * <p>
         * The number of findings that provide security-related information.
         * </p>
         * 
         * @param informational
         *        The number of findings that provide security-related information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder informational(Integer informational);

        /**
         * <p>
         * The number of findings with a severity level cannot be determined.
         * </p>
         * 
         * @param unknown
         *        The number of findings with a severity level cannot be determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknown(Integer unknown);
    }

    static final class BuilderImpl implements Builder {
        private Integer other;

        private Integer fatal;

        private Integer critical;

        private Integer high;

        private Integer medium;

        private Integer low;

        private Integer informational;

        private Integer unknown;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSeverityBreakdown model) {
            other(model.other);
            fatal(model.fatal);
            critical(model.critical);
            high(model.high);
            medium(model.medium);
            low(model.low);
            informational(model.informational);
            unknown(model.unknown);
        }

        public final Integer getOther() {
            return other;
        }

        public final void setOther(Integer other) {
            this.other = other;
        }

        @Override
        public final Builder other(Integer other) {
            this.other = other;
            return this;
        }

        public final Integer getFatal() {
            return fatal;
        }

        public final void setFatal(Integer fatal) {
            this.fatal = fatal;
        }

        @Override
        public final Builder fatal(Integer fatal) {
            this.fatal = fatal;
            return this;
        }

        public final Integer getCritical() {
            return critical;
        }

        public final void setCritical(Integer critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Integer critical) {
            this.critical = critical;
            return this;
        }

        public final Integer getHigh() {
            return high;
        }

        public final void setHigh(Integer high) {
            this.high = high;
        }

        @Override
        public final Builder high(Integer high) {
            this.high = high;
            return this;
        }

        public final Integer getMedium() {
            return medium;
        }

        public final void setMedium(Integer medium) {
            this.medium = medium;
        }

        @Override
        public final Builder medium(Integer medium) {
            this.medium = medium;
            return this;
        }

        public final Integer getLow() {
            return low;
        }

        public final void setLow(Integer low) {
            this.low = low;
        }

        @Override
        public final Builder low(Integer low) {
            this.low = low;
            return this;
        }

        public final Integer getInformational() {
            return informational;
        }

        public final void setInformational(Integer informational) {
            this.informational = informational;
        }

        @Override
        public final Builder informational(Integer informational) {
            this.informational = informational;
            return this;
        }

        public final Integer getUnknown() {
            return unknown;
        }

        public final void setUnknown(Integer unknown) {
            this.unknown = unknown;
        }

        @Override
        public final Builder unknown(Integer unknown) {
            this.unknown = unknown;
            return this;
        }

        @Override
        public ResourceSeverityBreakdown build() {
            return new ResourceSeverityBreakdown(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
