/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of summaries for all finding types on a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceFindingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceFindingsSummary.Builder, ResourceFindingsSummary> {
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingType").getter(getter(ResourceFindingsSummary::findingType)).setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingType").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(ResourceFindingsSummary::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFindings").getter(getter(ResourceFindingsSummary::totalFindings))
            .setter(setter(Builder::totalFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFindings").build()).build();

    private static final SdkField<ResourceSeverityBreakdown> SEVERITIES_FIELD = SdkField
            .<ResourceSeverityBreakdown> builder(MarshallingType.SDK_POJO).memberName("Severities")
            .getter(getter(ResourceFindingsSummary::severities)).setter(setter(Builder::severities))
            .constructor(ResourceSeverityBreakdown::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_TYPE_FIELD,
            PRODUCT_NAME_FIELD, TOTAL_FINDINGS_FIELD, SEVERITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String findingType;

    private final String productName;

    private final Integer totalFindings;

    private final ResourceSeverityBreakdown severities;

    private ResourceFindingsSummary(BuilderImpl builder) {
        this.findingType = builder.findingType;
        this.productName = builder.productName;
        this.totalFindings = builder.totalFindings;
        this.severities = builder.severities;
    }

    /**
     * <p>
     * The category or classification of the security finding.
     * </p>
     * 
     * @return The category or classification of the security finding.
     */
    public final String findingType() {
        return findingType;
    }

    /**
     * <p>
     * The name of the product associated with the security finding.
     * </p>
     * 
     * @return The name of the product associated with the security finding.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * The total count of security findings.
     * </p>
     * 
     * @return The total count of security findings.
     */
    public final Integer totalFindings() {
        return totalFindings;
    }

    /**
     * <p>
     * A breakdown of security findings by their severity levels.
     * </p>
     * 
     * @return A breakdown of security findings by their severity levels.
     */
    public final ResourceSeverityBreakdown severities() {
        return severities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingType());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(totalFindings());
        hashCode = 31 * hashCode + Objects.hashCode(severities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceFindingsSummary)) {
            return false;
        }
        ResourceFindingsSummary other = (ResourceFindingsSummary) obj;
        return Objects.equals(findingType(), other.findingType()) && Objects.equals(productName(), other.productName())
                && Objects.equals(totalFindings(), other.totalFindings()) && Objects.equals(severities(), other.severities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceFindingsSummary").add("FindingType", findingType()).add("ProductName", productName())
                .add("TotalFindings", totalFindings()).add("Severities", severities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingType":
            return Optional.ofNullable(clazz.cast(findingType()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "TotalFindings":
            return Optional.ofNullable(clazz.cast(totalFindings()));
        case "Severities":
            return Optional.ofNullable(clazz.cast(severities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FindingType", FINDING_TYPE_FIELD);
        map.put("ProductName", PRODUCT_NAME_FIELD);
        map.put("TotalFindings", TOTAL_FINDINGS_FIELD);
        map.put("Severities", SEVERITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceFindingsSummary, T> g) {
        return obj -> g.apply((ResourceFindingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceFindingsSummary> {
        /**
         * <p>
         * The category or classification of the security finding.
         * </p>
         * 
         * @param findingType
         *        The category or classification of the security finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingType(String findingType);

        /**
         * <p>
         * The name of the product associated with the security finding.
         * </p>
         * 
         * @param productName
         *        The name of the product associated with the security finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * The total count of security findings.
         * </p>
         * 
         * @param totalFindings
         *        The total count of security findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFindings(Integer totalFindings);

        /**
         * <p>
         * A breakdown of security findings by their severity levels.
         * </p>
         * 
         * @param severities
         *        A breakdown of security findings by their severity levels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severities(ResourceSeverityBreakdown severities);

        /**
         * <p>
         * A breakdown of security findings by their severity levels.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSeverityBreakdown.Builder}
         * avoiding the need to create one manually via {@link ResourceSeverityBreakdown#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSeverityBreakdown.Builder#build()} is called immediately
         * and its result is passed to {@link #severities(ResourceSeverityBreakdown)}.
         * 
         * @param severities
         *        a consumer that will call methods on {@link ResourceSeverityBreakdown.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severities(ResourceSeverityBreakdown)
         */
        default Builder severities(Consumer<ResourceSeverityBreakdown.Builder> severities) {
            return severities(ResourceSeverityBreakdown.builder().applyMutation(severities).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String findingType;

        private String productName;

        private Integer totalFindings;

        private ResourceSeverityBreakdown severities;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceFindingsSummary model) {
            findingType(model.findingType);
            productName(model.productName);
            totalFindings(model.totalFindings);
            severities(model.severities);
        }

        public final String getFindingType() {
            return findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final Integer getTotalFindings() {
            return totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        public final ResourceSeverityBreakdown.Builder getSeverities() {
            return severities != null ? severities.toBuilder() : null;
        }

        public final void setSeverities(ResourceSeverityBreakdown.BuilderImpl severities) {
            this.severities = severities != null ? severities.build() : null;
        }

        @Override
        public final Builder severities(ResourceSeverityBreakdown severities) {
            this.severities = severities;
            return this;
        }

        @Override
        public ResourceFindingsSummary build() {
            return new ResourceFindingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
