/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the remediation steps for a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Remediation implements SdkPojo, Serializable, ToCopyableBuilder<Remediation.Builder, Remediation> {
    private static final SdkField<Recommendation> RECOMMENDATION_FIELD = SdkField
            .<Recommendation> builder(MarshallingType.SDK_POJO).memberName("Recommendation")
            .getter(getter(Remediation::recommendation)).setter(setter(Builder::recommendation))
            .constructor(Recommendation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Recommendation recommendation;

    private Remediation(BuilderImpl builder) {
        this.recommendation = builder.recommendation;
    }

    /**
     * <p>
     * A recommendation on the steps to take to remediate the issue identified by a finding.
     * </p>
     * 
     * @return A recommendation on the steps to take to remediate the issue identified by a finding.
     */
    public final Recommendation recommendation() {
        return recommendation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Remediation)) {
            return false;
        }
        Remediation other = (Remediation) obj;
        return Objects.equals(recommendation(), other.recommendation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Remediation").add("Recommendation", recommendation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Recommendation", RECOMMENDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Remediation, T> g) {
        return obj -> g.apply((Remediation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Remediation> {
        /**
         * <p>
         * A recommendation on the steps to take to remediate the issue identified by a finding.
         * </p>
         * 
         * @param recommendation
         *        A recommendation on the steps to take to remediate the issue identified by a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(Recommendation recommendation);

        /**
         * <p>
         * A recommendation on the steps to take to remediate the issue identified by a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Recommendation.Builder} avoiding the need
         * to create one manually via {@link Recommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Recommendation.Builder#build()} is called immediately and its
         * result is passed to {@link #recommendation(Recommendation)}.
         * 
         * @param recommendation
         *        a consumer that will call methods on {@link Recommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendation(Recommendation)
         */
        default Builder recommendation(Consumer<Recommendation.Builder> recommendation) {
            return recommendation(Recommendation.builder().applyMutation(recommendation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Recommendation recommendation;

        private BuilderImpl() {
        }

        private BuilderImpl(Remediation model) {
            recommendation(model.recommendation);
        }

        public final Recommendation.Builder getRecommendation() {
            return recommendation != null ? recommendation.toBuilder() : null;
        }

        public final void setRecommendation(Recommendation.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(Recommendation recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        @Override
        public Remediation build() {
            return new Remediation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
