/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterConnectorV2Request extends SecurityHubRequest implements
        ToCopyableBuilder<RegisterConnectorV2Request.Builder, RegisterConnectorV2Request> {
    private static final SdkField<String> AUTH_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthCode").getter(getter(RegisterConnectorV2Request::authCode)).setter(setter(Builder::authCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthCode").build()).build();

    private static final SdkField<String> AUTH_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthState").getter(getter(RegisterConnectorV2Request::authState)).setter(setter(Builder::authState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CODE_FIELD,
            AUTH_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authCode;

    private final String authState;

    private RegisterConnectorV2Request(BuilderImpl builder) {
        super(builder);
        this.authCode = builder.authCode;
        this.authState = builder.authState;
    }

    /**
     * <p>
     * The authCode retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
     * </p>
     * 
     * @return The authCode retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
     */
    public final String authCode() {
        return authCode;
    }

    /**
     * <p>
     * The authState retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
     * </p>
     * 
     * @return The authState retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
     */
    public final String authState() {
        return authState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authCode());
        hashCode = 31 * hashCode + Objects.hashCode(authState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterConnectorV2Request)) {
            return false;
        }
        RegisterConnectorV2Request other = (RegisterConnectorV2Request) obj;
        return Objects.equals(authCode(), other.authCode()) && Objects.equals(authState(), other.authState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterConnectorV2Request").add("AuthCode", authCode()).add("AuthState", authState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthCode":
            return Optional.ofNullable(clazz.cast(authCode()));
        case "AuthState":
            return Optional.ofNullable(clazz.cast(authState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthCode", AUTH_CODE_FIELD);
        map.put("AuthState", AUTH_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterConnectorV2Request, T> g) {
        return obj -> g.apply((RegisterConnectorV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterConnectorV2Request> {
        /**
         * <p>
         * The authCode retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
         * </p>
         * 
         * @param authCode
         *        The authCode retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCode(String authCode);

        /**
         * <p>
         * The authState retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
         * </p>
         * 
         * @param authState
         *        The authState retrieved from authUrl to complete the OAuth 2.0 authorization code flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authState(String authState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String authCode;

        private String authState;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterConnectorV2Request model) {
            super(model);
            authCode(model.authCode);
            authState(model.authState);
        }

        public final String getAuthCode() {
            return authCode;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final String getAuthState() {
            return authState;
        }

        public final void setAuthState(String authState) {
            this.authState = authState;
        }

        @Override
        public final Builder authState(String authState) {
            this.authState = authState;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterConnectorV2Request build() {
            return new RegisterConnectorV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
