/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connectorV2 third-party provider configuration summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderSummary implements SdkPojo, Serializable, ToCopyableBuilder<ProviderSummary.Builder, ProviderSummary> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderName").getter(getter(ProviderSummary::providerNameAsString))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<String> CONNECTOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorStatus").getter(getter(ProviderSummary::connectorStatusAsString))
            .setter(setter(Builder::connectorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            CONNECTOR_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerName;

    private final String connectorStatus;

    private ProviderSummary(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.connectorStatus = builder.connectorStatus;
    }

    /**
     * <p>
     * The name of the provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerName} will
     * return {@link ConnectorProviderName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerNameAsString}.
     * </p>
     * 
     * @return The name of the provider.
     * @see ConnectorProviderName
     */
    public final ConnectorProviderName providerName() {
        return ConnectorProviderName.fromValue(providerName);
    }

    /**
     * <p>
     * The name of the provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerName} will
     * return {@link ConnectorProviderName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerNameAsString}.
     * </p>
     * 
     * @return The name of the provider.
     * @see ConnectorProviderName
     */
    public final String providerNameAsString() {
        return providerName;
    }

    /**
     * <p>
     * The status for the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The status for the connectorV2.
     * @see ConnectorStatus
     */
    public final ConnectorStatus connectorStatus() {
        return ConnectorStatus.fromValue(connectorStatus);
    }

    /**
     * <p>
     * The status for the connectorV2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorStatus}
     * will return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStatusAsString}.
     * </p>
     * 
     * @return The status for the connectorV2.
     * @see ConnectorStatus
     */
    public final String connectorStatusAsString() {
        return connectorStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderSummary)) {
            return false;
        }
        ProviderSummary other = (ProviderSummary) obj;
        return Objects.equals(providerNameAsString(), other.providerNameAsString())
                && Objects.equals(connectorStatusAsString(), other.connectorStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderSummary").add("ProviderName", providerNameAsString())
                .add("ConnectorStatus", connectorStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerNameAsString()));
        case "ConnectorStatus":
            return Optional.ofNullable(clazz.cast(connectorStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("ConnectorStatus", CONNECTOR_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderSummary, T> g) {
        return obj -> g.apply((ProviderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderSummary> {
        /**
         * <p>
         * The name of the provider.
         * </p>
         * 
         * @param providerName
         *        The name of the provider.
         * @see ConnectorProviderName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProviderName
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The name of the provider.
         * </p>
         * 
         * @param providerName
         *        The name of the provider.
         * @see ConnectorProviderName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProviderName
         */
        Builder providerName(ConnectorProviderName providerName);

        /**
         * <p>
         * The status for the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The status for the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(String connectorStatus);

        /**
         * <p>
         * The status for the connectorV2.
         * </p>
         * 
         * @param connectorStatus
         *        The status for the connectorV2.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder connectorStatus(ConnectorStatus connectorStatus);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String connectorStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderSummary model) {
            providerName(model.providerName);
            connectorStatus(model.connectorStatus);
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Override
        public final Builder providerName(ConnectorProviderName providerName) {
            this.providerName(providerName == null ? null : providerName.toString());
            return this;
        }

        public final String getConnectorStatus() {
            return connectorStatus;
        }

        public final void setConnectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
        }

        @Override
        public final Builder connectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
            return this;
        }

        @Override
        public final Builder connectorStatus(ConnectorStatus connectorStatus) {
            this.connectorStatus(connectorStatus == null ? null : connectorStatus.toString());
            return this;
        }

        @Override
        public ProviderSummary build() {
            return new ProviderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
