/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The third-party provider detail for a service configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderDetail implements SdkPojo, Serializable, ToCopyableBuilder<ProviderDetail.Builder, ProviderDetail> {
    private static final SdkField<JiraCloudDetail> JIRA_CLOUD_FIELD = SdkField
            .<JiraCloudDetail> builder(MarshallingType.SDK_POJO).memberName("JiraCloud")
            .getter(getter(ProviderDetail::jiraCloud)).setter(setter(Builder::jiraCloud)).constructor(JiraCloudDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraCloud").build()).build();

    private static final SdkField<ServiceNowDetail> SERVICE_NOW_FIELD = SdkField
            .<ServiceNowDetail> builder(MarshallingType.SDK_POJO).memberName("ServiceNow")
            .getter(getter(ProviderDetail::serviceNow)).setter(setter(Builder::serviceNow))
            .constructor(ServiceNowDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JIRA_CLOUD_FIELD,
            SERVICE_NOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JiraCloudDetail jiraCloud;

    private final ServiceNowDetail serviceNow;

    private final Type type;

    private ProviderDetail(BuilderImpl builder) {
        this.jiraCloud = builder.jiraCloud;
        this.serviceNow = builder.serviceNow;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about a Jira Cloud integration.
     * </p>
     * 
     * @return Details about a Jira Cloud integration.
     */
    public final JiraCloudDetail jiraCloud() {
        return jiraCloud;
    }

    /**
     * <p>
     * Details about a ServiceNow ITSM integration.
     * </p>
     * 
     * @return Details about a ServiceNow ITSM integration.
     */
    public final ServiceNowDetail serviceNow() {
        return serviceNow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jiraCloud());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderDetail)) {
            return false;
        }
        ProviderDetail other = (ProviderDetail) obj;
        return Objects.equals(jiraCloud(), other.jiraCloud()) && Objects.equals(serviceNow(), other.serviceNow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderDetail").add("JiraCloud", jiraCloud()).add("ServiceNow", serviceNow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JiraCloud":
            return Optional.ofNullable(clazz.cast(jiraCloud()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNow()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #jiraCloud()} initialized to the given value.
     *
     * <p>
     * Details about a Jira Cloud integration.
     * </p>
     * 
     * @param jiraCloud
     *        Details about a Jira Cloud integration.
     */
    public static ProviderDetail fromJiraCloud(JiraCloudDetail jiraCloud) {
        return builder().jiraCloud(jiraCloud).build();
    }

    /**
     * Create an instance of this class with {@link #jiraCloud()} initialized to the given value.
     *
     * <p>
     * Details about a Jira Cloud integration.
     * </p>
     * 
     * @param jiraCloud
     *        Details about a Jira Cloud integration.
     */
    public static ProviderDetail fromJiraCloud(Consumer<JiraCloudDetail.Builder> jiraCloud) {
        JiraCloudDetail.Builder builder = JiraCloudDetail.builder();
        jiraCloud.accept(builder);
        return fromJiraCloud(builder.build());
    }

    /**
     * Create an instance of this class with {@link #serviceNow()} initialized to the given value.
     *
     * <p>
     * Details about a ServiceNow ITSM integration.
     * </p>
     * 
     * @param serviceNow
     *        Details about a ServiceNow ITSM integration.
     */
    public static ProviderDetail fromServiceNow(ServiceNowDetail serviceNow) {
        return builder().serviceNow(serviceNow).build();
    }

    /**
     * Create an instance of this class with {@link #serviceNow()} initialized to the given value.
     *
     * <p>
     * Details about a ServiceNow ITSM integration.
     * </p>
     * 
     * @param serviceNow
     *        Details about a ServiceNow ITSM integration.
     */
    public static ProviderDetail fromServiceNow(Consumer<ServiceNowDetail.Builder> serviceNow) {
        ServiceNowDetail.Builder builder = ServiceNowDetail.builder();
        serviceNow.accept(builder);
        return fromServiceNow(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JiraCloud", JIRA_CLOUD_FIELD);
        map.put("ServiceNow", SERVICE_NOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderDetail, T> g) {
        return obj -> g.apply((ProviderDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderDetail> {
        /**
         * <p>
         * Details about a Jira Cloud integration.
         * </p>
         * 
         * @param jiraCloud
         *        Details about a Jira Cloud integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraCloud(JiraCloudDetail jiraCloud);

        /**
         * <p>
         * Details about a Jira Cloud integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JiraCloudDetail.Builder} avoiding the
         * need to create one manually via {@link JiraCloudDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JiraCloudDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #jiraCloud(JiraCloudDetail)}.
         * 
         * @param jiraCloud
         *        a consumer that will call methods on {@link JiraCloudDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jiraCloud(JiraCloudDetail)
         */
        default Builder jiraCloud(Consumer<JiraCloudDetail.Builder> jiraCloud) {
            return jiraCloud(JiraCloudDetail.builder().applyMutation(jiraCloud).build());
        }

        /**
         * <p>
         * Details about a ServiceNow ITSM integration.
         * </p>
         * 
         * @param serviceNow
         *        Details about a ServiceNow ITSM integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNow(ServiceNowDetail serviceNow);

        /**
         * <p>
         * Details about a ServiceNow ITSM integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceNowDetail.Builder} avoiding the
         * need to create one manually via {@link ServiceNowDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceNowDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceNow(ServiceNowDetail)}.
         * 
         * @param serviceNow
         *        a consumer that will call methods on {@link ServiceNowDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNow(ServiceNowDetail)
         */
        default Builder serviceNow(Consumer<ServiceNowDetail.Builder> serviceNow) {
            return serviceNow(ServiceNowDetail.builder().applyMutation(serviceNow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JiraCloudDetail jiraCloud;

        private ServiceNowDetail serviceNow;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderDetail model) {
            jiraCloud(model.jiraCloud);
            serviceNow(model.serviceNow);
        }

        public final JiraCloudDetail.Builder getJiraCloud() {
            return jiraCloud != null ? jiraCloud.toBuilder() : null;
        }

        public final void setJiraCloud(JiraCloudDetail.BuilderImpl jiraCloud) {
            Object oldValue = this.jiraCloud;
            this.jiraCloud = jiraCloud != null ? jiraCloud.build() : null;
            handleUnionValueChange(Type.JIRA_CLOUD, oldValue, this.jiraCloud);
        }

        @Override
        public final Builder jiraCloud(JiraCloudDetail jiraCloud) {
            Object oldValue = this.jiraCloud;
            this.jiraCloud = jiraCloud;
            handleUnionValueChange(Type.JIRA_CLOUD, oldValue, this.jiraCloud);
            return this;
        }

        public final ServiceNowDetail.Builder getServiceNow() {
            return serviceNow != null ? serviceNow.toBuilder() : null;
        }

        public final void setServiceNow(ServiceNowDetail.BuilderImpl serviceNow) {
            Object oldValue = this.serviceNow;
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
            handleUnionValueChange(Type.SERVICE_NOW, oldValue, this.serviceNow);
        }

        @Override
        public final Builder serviceNow(ServiceNowDetail serviceNow) {
            Object oldValue = this.serviceNow;
            this.serviceNow = serviceNow;
            handleUnionValueChange(Type.SERVICE_NOW, oldValue, this.serviceNow);
            return this;
        }

        @Override
        public ProviderDetail build() {
            return new ProviderDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProviderDetail#type()
     */
    public enum Type {
        JIRA_CLOUD,

        SERVICE_NOW,

        UNKNOWN_TO_SDK_VERSION
    }
}
