/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the structure for the productV2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductV2 implements SdkPojo, Serializable, ToCopyableBuilder<ProductV2.Builder, ProductV2> {
    private static final SdkField<String> PRODUCT_V2_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductV2Name").getter(getter(ProductV2::productV2Name)).setter(setter(Builder::productV2Name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductV2Name").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(ProductV2::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ProductV2::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(ProductV2::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INTEGRATION_V2_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IntegrationV2Types")
            .getter(getter(ProductV2::integrationV2TypesAsStrings))
            .setter(setter(Builder::integrationV2TypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationV2Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKETPLACE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarketplaceUrl").getter(getter(ProductV2::marketplaceUrl)).setter(setter(Builder::marketplaceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceUrl").build()).build();

    private static final SdkField<String> ACTIVATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationUrl").getter(getter(ProductV2::activationUrl)).setter(setter(Builder::activationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_V2_NAME_FIELD,
            COMPANY_NAME_FIELD, DESCRIPTION_FIELD, CATEGORIES_FIELD, INTEGRATION_V2_TYPES_FIELD, MARKETPLACE_URL_FIELD,
            ACTIVATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String productV2Name;

    private final String companyName;

    private final String description;

    private final List<String> categories;

    private final List<String> integrationV2Types;

    private final String marketplaceUrl;

    private final String activationUrl;

    private ProductV2(BuilderImpl builder) {
        this.productV2Name = builder.productV2Name;
        this.companyName = builder.companyName;
        this.description = builder.description;
        this.categories = builder.categories;
        this.integrationV2Types = builder.integrationV2Types;
        this.marketplaceUrl = builder.marketplaceUrl;
        this.activationUrl = builder.activationUrl;
    }

    /**
     * <p>
     * The name of the productV2.
     * </p>
     * 
     * @return The name of the productV2.
     */
    public final String productV2Name() {
        return productV2Name;
    }

    /**
     * <p>
     * The name of the organization or vendor that provides the productV2.
     * </p>
     * 
     * @return The name of the organization or vendor that provides the productV2.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * Detailed information about the productV2.
     * </p>
     * 
     * @return Detailed information about the productV2.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains or functional areas the productV2 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return The domains or functional areas the productV2 addresses.
     */
    public final List<String> categories() {
        return categories;
    }

    /**
     * <p>
     * The type of integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegrationV2Types} method.
     * </p>
     * 
     * @return The type of integration.
     */
    public final List<IntegrationV2Type> integrationV2Types() {
        return IntegrationV2TypeListCopier.copyStringToEnum(integrationV2Types);
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegrationV2Types property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegrationV2Types() {
        return integrationV2Types != null && !(integrationV2Types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegrationV2Types} method.
     * </p>
     * 
     * @return The type of integration.
     */
    public final List<String> integrationV2TypesAsStrings() {
        return integrationV2Types;
    }

    /**
     * <p>
     * The console URL where you can purchase or subscribe to products.
     * </p>
     * 
     * @return The console URL where you can purchase or subscribe to products.
     */
    public final String marketplaceUrl() {
        return marketplaceUrl;
    }

    /**
     * <p>
     * The URL to the serviceV@ or productV2 documentation about the integration, which includes how to activate the
     * integration.
     * </p>
     * 
     * @return The URL to the serviceV@ or productV2 documentation about the integration, which includes how to activate
     *         the integration.
     */
    public final String activationUrl() {
        return activationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productV2Name());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegrationV2Types() ? integrationV2TypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(activationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductV2)) {
            return false;
        }
        ProductV2 other = (ProductV2) obj;
        return Objects.equals(productV2Name(), other.productV2Name()) && Objects.equals(companyName(), other.companyName())
                && Objects.equals(description(), other.description()) && hasCategories() == other.hasCategories()
                && Objects.equals(categories(), other.categories()) && hasIntegrationV2Types() == other.hasIntegrationV2Types()
                && Objects.equals(integrationV2TypesAsStrings(), other.integrationV2TypesAsStrings())
                && Objects.equals(marketplaceUrl(), other.marketplaceUrl())
                && Objects.equals(activationUrl(), other.activationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductV2").add("ProductV2Name", productV2Name()).add("CompanyName", companyName())
                .add("Description", description()).add("Categories", hasCategories() ? categories() : null)
                .add("IntegrationV2Types", hasIntegrationV2Types() ? integrationV2TypesAsStrings() : null)
                .add("MarketplaceUrl", marketplaceUrl()).add("ActivationUrl", activationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductV2Name":
            return Optional.ofNullable(clazz.cast(productV2Name()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "IntegrationV2Types":
            return Optional.ofNullable(clazz.cast(integrationV2TypesAsStrings()));
        case "MarketplaceUrl":
            return Optional.ofNullable(clazz.cast(marketplaceUrl()));
        case "ActivationUrl":
            return Optional.ofNullable(clazz.cast(activationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProductV2Name", PRODUCT_V2_NAME_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("IntegrationV2Types", INTEGRATION_V2_TYPES_FIELD);
        map.put("MarketplaceUrl", MARKETPLACE_URL_FIELD);
        map.put("ActivationUrl", ACTIVATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductV2, T> g) {
        return obj -> g.apply((ProductV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductV2> {
        /**
         * <p>
         * The name of the productV2.
         * </p>
         * 
         * @param productV2Name
         *        The name of the productV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productV2Name(String productV2Name);

        /**
         * <p>
         * The name of the organization or vendor that provides the productV2.
         * </p>
         * 
         * @param companyName
         *        The name of the organization or vendor that provides the productV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * Detailed information about the productV2.
         * </p>
         * 
         * @param description
         *        Detailed information about the productV2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domains or functional areas the productV2 addresses.
         * </p>
         * 
         * @param categories
         *        The domains or functional areas the productV2 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<String> categories);

        /**
         * <p>
         * The domains or functional areas the productV2 addresses.
         * </p>
         * 
         * @param categories
         *        The domains or functional areas the productV2 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(String... categories);

        /**
         * <p>
         * The type of integration.
         * </p>
         * 
         * @param integrationV2Types
         *        The type of integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationV2TypesWithStrings(Collection<String> integrationV2Types);

        /**
         * <p>
         * The type of integration.
         * </p>
         * 
         * @param integrationV2Types
         *        The type of integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationV2TypesWithStrings(String... integrationV2Types);

        /**
         * <p>
         * The type of integration.
         * </p>
         * 
         * @param integrationV2Types
         *        The type of integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationV2Types(Collection<IntegrationV2Type> integrationV2Types);

        /**
         * <p>
         * The type of integration.
         * </p>
         * 
         * @param integrationV2Types
         *        The type of integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationV2Types(IntegrationV2Type... integrationV2Types);

        /**
         * <p>
         * The console URL where you can purchase or subscribe to products.
         * </p>
         * 
         * @param marketplaceUrl
         *        The console URL where you can purchase or subscribe to products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceUrl(String marketplaceUrl);

        /**
         * <p>
         * The URL to the serviceV@ or productV2 documentation about the integration, which includes how to activate the
         * integration.
         * </p>
         * 
         * @param activationUrl
         *        The URL to the serviceV@ or productV2 documentation about the integration, which includes how to
         *        activate the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationUrl(String activationUrl);
    }

    static final class BuilderImpl implements Builder {
        private String productV2Name;

        private String companyName;

        private String description;

        private List<String> categories = DefaultSdkAutoConstructList.getInstance();

        private List<String> integrationV2Types = DefaultSdkAutoConstructList.getInstance();

        private String marketplaceUrl;

        private String activationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductV2 model) {
            productV2Name(model.productV2Name);
            companyName(model.companyName);
            description(model.description);
            categories(model.categories);
            integrationV2TypesWithStrings(model.integrationV2Types);
            marketplaceUrl(model.marketplaceUrl);
            activationUrl(model.activationUrl);
        }

        public final String getProductV2Name() {
            return productV2Name;
        }

        public final void setProductV2Name(String productV2Name) {
            this.productV2Name = productV2Name;
        }

        @Override
        public final Builder productV2Name(String productV2Name) {
            this.productV2Name = productV2Name;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCategories() {
            if (categories instanceof SdkAutoConstructList) {
                return null;
            }
            return categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        public final Collection<String> getIntegrationV2Types() {
            if (integrationV2Types instanceof SdkAutoConstructList) {
                return null;
            }
            return integrationV2Types;
        }

        public final void setIntegrationV2Types(Collection<String> integrationV2Types) {
            this.integrationV2Types = IntegrationV2TypeListCopier.copy(integrationV2Types);
        }

        @Override
        public final Builder integrationV2TypesWithStrings(Collection<String> integrationV2Types) {
            this.integrationV2Types = IntegrationV2TypeListCopier.copy(integrationV2Types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationV2TypesWithStrings(String... integrationV2Types) {
            integrationV2TypesWithStrings(Arrays.asList(integrationV2Types));
            return this;
        }

        @Override
        public final Builder integrationV2Types(Collection<IntegrationV2Type> integrationV2Types) {
            this.integrationV2Types = IntegrationV2TypeListCopier.copyEnumToString(integrationV2Types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationV2Types(IntegrationV2Type... integrationV2Types) {
            integrationV2Types(Arrays.asList(integrationV2Types));
            return this;
        }

        public final String getMarketplaceUrl() {
            return marketplaceUrl;
        }

        public final void setMarketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
        }

        @Override
        public final Builder marketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
            return this;
        }

        public final String getActivationUrl() {
            return activationUrl;
        }

        public final void setActivationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
        }

        @Override
        public final Builder activationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
            return this;
        }

        @Override
        public ProductV2 build() {
            return new ProductV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
