/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes a security control parameter and the options for customizing it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterDefinition.Builder, ParameterDefinition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ParameterDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ConfigurationOptions> CONFIGURATION_OPTIONS_FIELD = SdkField
            .<ConfigurationOptions> builder(MarshallingType.SDK_POJO).memberName("ConfigurationOptions")
            .getter(getter(ParameterDefinition::configurationOptions)).setter(setter(Builder::configurationOptions))
            .constructor(ConfigurationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            CONFIGURATION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ConfigurationOptions configurationOptions;

    private ParameterDefinition(BuilderImpl builder) {
        this.description = builder.description;
        this.configurationOptions = builder.configurationOptions;
    }

    /**
     * <p>
     * Description of a control parameter.
     * </p>
     * 
     * @return Description of a control parameter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The options for customizing a control parameter. Customization options vary based on the data type of the
     * parameter.
     * </p>
     * 
     * @return The options for customizing a control parameter. Customization options vary based on the data type of the
     *         parameter.
     */
    public final ConfigurationOptions configurationOptions() {
        return configurationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(configurationOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(configurationOptions(), other.configurationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterDefinition").add("Description", description())
                .add("ConfigurationOptions", configurationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConfigurationOptions":
            return Optional.ofNullable(clazz.cast(configurationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ConfigurationOptions", CONFIGURATION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterDefinition, T> g) {
        return obj -> g.apply((ParameterDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterDefinition> {
        /**
         * <p>
         * Description of a control parameter.
         * </p>
         * 
         * @param description
         *        Description of a control parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The options for customizing a control parameter. Customization options vary based on the data type of the
         * parameter.
         * </p>
         * 
         * @param configurationOptions
         *        The options for customizing a control parameter. Customization options vary based on the data type of
         *        the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationOptions(ConfigurationOptions configurationOptions);

        /**
         * <p>
         * The options for customizing a control parameter. Customization options vary based on the data type of the
         * parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationOptions.Builder} avoiding
         * the need to create one manually via {@link ConfigurationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationOptions(ConfigurationOptions)}.
         * 
         * @param configurationOptions
         *        a consumer that will call methods on {@link ConfigurationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationOptions(ConfigurationOptions)
         */
        default Builder configurationOptions(Consumer<ConfigurationOptions.Builder> configurationOptions) {
            return configurationOptions(ConfigurationOptions.builder().applyMutation(configurationOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ConfigurationOptions configurationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDefinition model) {
            description(model.description);
            configurationOptions(model.configurationOptions);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ConfigurationOptions.Builder getConfigurationOptions() {
            return configurationOptions != null ? configurationOptions.toBuilder() : null;
        }

        public final void setConfigurationOptions(ConfigurationOptions.BuilderImpl configurationOptions) {
            this.configurationOptions = configurationOptions != null ? configurationOptions.build() : null;
        }

        @Override
        public final Builder configurationOptions(ConfigurationOptions configurationOptions) {
            this.configurationOptions = configurationOptions;
            return this;
        }

        @Override
        public ParameterDefinition build() {
            return new ParameterDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
